/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.SkipInHeadlessEnvironment;
import com.intellij.testFramework.SkipSlowTestLocally;
import java.awt.GraphicsEnvironment;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.junit.Test;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.runner.RunWith;

public final class TestFrameworkUtil {
    public static final boolean SKIP_HEADLESS = GraphicsEnvironment.isHeadless();
    public static final boolean SKIP_SLOW = Boolean.getBoolean("skip.slow.tests.locally");

    public static boolean canRunTest(@NotNull Class<?> testCaseClass) {
        if (testCaseClass == null) {
            TestFrameworkUtil.$$$reportNull$$$0(0);
        }
        if (!SKIP_SLOW && !SKIP_HEADLESS) {
            return true;
        }
        for (Class<?> clazz = testCaseClass; clazz != null; clazz = clazz.getSuperclass()) {
            if (SKIP_HEADLESS && clazz.getAnnotation(SkipInHeadlessEnvironment.class) != null) {
                System.out.println("Class '" + testCaseClass.getName() + "' is skipped because it requires working UI environment");
                return false;
            }
            if (!SKIP_SLOW || clazz.getAnnotation(SkipSlowTestLocally.class) == null) continue;
            System.out.println("Class '" + testCaseClass.getName() + "' is skipped because it is dog slow");
            return false;
        }
        return true;
    }

    @TestOnly
    public static boolean isJUnit4TestClass(@NotNull Class<?> aClass, boolean allowAbstract) {
        if (aClass == null) {
            TestFrameworkUtil.$$$reportNull$$$0(1);
        }
        int modifiers = aClass.getModifiers();
        if (!allowAbstract && Modifier.isAbstract(modifiers)) {
            return false;
        }
        if (!Modifier.isPublic(modifiers)) {
            return false;
        }
        if (aClass.getAnnotation(RunWith.class) != null) {
            return true;
        }
        for (Method method : aClass.getMethods()) {
            if (method.getAnnotation(Test.class) == null) continue;
            return true;
        }
        return false;
    }

    @TestOnly
    public static boolean isJUnit5TestClass(@NotNull Class<?> aClass, boolean allowAbstract) {
        if (aClass == null) {
            TestFrameworkUtil.$$$reportNull$$$0(2);
        }
        int modifiers = aClass.getModifiers();
        if (!allowAbstract && Modifier.isAbstract(modifiers)) {
            return false;
        }
        if (!Modifier.isPublic(modifiers)) {
            return false;
        }
        if (aClass.getAnnotation(ExtendWith.class) != null) {
            return true;
        }
        for (Method method : aClass.getMethods()) {
            if (method.getAnnotation(org.junit.jupiter.api.Test.class) != null) {
                return true;
            }
            if (method.getAnnotation(TestFactory.class) != null) {
                return true;
            }
            if (method.getAnnotation(TestTemplate.class) != null) {
                return true;
            }
            if (method.getAnnotation(RepeatedTest.class) != null) {
                return true;
            }
            for (Annotation annotation : method.getAnnotations()) {
                String name = annotation.annotationType().getCanonicalName();
                if (!"org.junit.jupiter.params.ParameterizedTest".equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPerformanceTest(@Nullable String testName, @Nullable String className) {
        return TestFrameworkUtil.containsWord(testName, className, "performance");
    }

    public static boolean isStressTest(@Nullable String testName, @Nullable String className) {
        return TestFrameworkUtil.isPerformanceTest(testName, className) || TestFrameworkUtil.containsWord(testName, className, "stress") || TestFrameworkUtil.containsWord(testName, className, "slow");
    }

    private static boolean containsWord(@Nullable String testName, @Nullable String className, @NotNull String word) {
        if (word == null) {
            TestFrameworkUtil.$$$reportNull$$$0(3);
        }
        return testName != null && StringUtil.containsIgnoreCase((String)testName, (String)word) || className != null && StringUtil.containsIgnoreCase((String)className, (String)word);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCaseClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/TestFrameworkUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canRunTest";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isJUnit4TestClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isJUnit5TestClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "containsWord";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

