/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractFloatCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.CharCollection;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharFloatAssociativeContainer;
import com.carrotsearch.hppc.CharFloatHashMap;
import com.carrotsearch.hppc.CharFloatMap;
import com.carrotsearch.hppc.CharLookupContainer;
import com.carrotsearch.hppc.FloatContainer;
import com.carrotsearch.hppc.comparators.CharComparator;
import com.carrotsearch.hppc.comparators.CharFloatComparator;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.cursors.CharFloatCursor;
import com.carrotsearch.hppc.cursors.FloatCursor;
import com.carrotsearch.hppc.predicates.CharFloatPredicate;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.predicates.FloatPredicate;
import com.carrotsearch.hppc.procedures.CharFloatProcedure;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.procedures.FloatProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationCharFloatHashMap
implements CharFloatMap {
    public final CharFloatHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationCharFloatHashMap(CharFloatHashMap delegate, CharComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationCharFloatHashMap(CharFloatHashMap delegate, CharFloatComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        char[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != '\u0000') {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, CharComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            char[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final CharFloatComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final char[] keys;
            final float[] values;
            {
                this.keys = SortedIterationCharFloatHashMap.this.delegate.keys;
                this.values = SortedIterationCharFloatHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<CharFloatCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(char key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(CharContainer container) {
        throw SortedIterationCharFloatHashMap.readOnlyException();
    }

    @Override
    public int removeAll(CharPredicate predicate) {
        throw SortedIterationCharFloatHashMap.readOnlyException();
    }

    @Override
    public int removeAll(CharFloatPredicate predicate) {
        throw SortedIterationCharFloatHashMap.readOnlyException();
    }

    @Override
    public <T extends CharFloatProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        char[] keys = this.delegate.keys;
        float[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends CharFloatPredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        char[] keys = this.delegate.keys;
        float[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public CharCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public FloatContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public float get(char key) {
        return this.delegate.get(key);
    }

    @Override
    public float getOrDefault(char key, float defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public float put(char key, float value) {
        throw SortedIterationCharFloatHashMap.readOnlyException();
    }

    @Override
    public int putAll(CharFloatAssociativeContainer container) {
        throw SortedIterationCharFloatHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends CharFloatCursor> iterable) {
        throw SortedIterationCharFloatHashMap.readOnlyException();
    }

    @Override
    public float putOrAdd(char key, float putValue, float incrementValue) {
        throw SortedIterationCharFloatHashMap.readOnlyException();
    }

    @Override
    public float addTo(char key, float additionValue) {
        throw SortedIterationCharFloatHashMap.readOnlyException();
    }

    @Override
    public float remove(char key) {
        throw SortedIterationCharFloatHashMap.readOnlyException();
    }

    @Override
    public int indexOf(char key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public float indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public float indexReplace(int index, float newValue) {
        throw SortedIterationCharFloatHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, char key, float value) {
        throw SortedIterationCharFloatHashMap.readOnlyException();
    }

    @Override
    public float indexRemove(int index) {
        throw SortedIterationCharFloatHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationCharFloatHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationCharFloatHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<CharFloatCursor> {
        private final CharFloatCursor cursor = new CharFloatCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected CharFloatCursor fetch() {
            if (this.index < SortedIterationCharFloatHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationCharFloatHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationCharFloatHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationCharFloatHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (CharFloatCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final SortedIterationCharFloatHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationCharFloatHashMap.this;
        }

        @Override
        public boolean contains(char e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationCharFloatHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationCharFloatHashMap.readOnlyException();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            throw SortedIterationCharFloatHashMap.readOnlyException();
        }

        @Override
        public int removeAll(char e) {
            throw SortedIterationCharFloatHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractFloatCollection {
        private final SortedIterationCharFloatHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationCharFloatHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(float value) {
            for (CharFloatCursor c : this.owner) {
                if (Float.floatToIntBits(value) != Float.floatToIntBits(c.value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends FloatProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<FloatCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(float e) {
            throw SortedIterationCharFloatHashMap.readOnlyException();
        }

        @Override
        public int removeAll(FloatPredicate predicate) {
            throw SortedIterationCharFloatHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationCharFloatHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationCharFloatHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor = new FloatCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected FloatCursor fetch() {
            if (this.index < SortedIterationCharFloatHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationCharFloatHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationCharFloatHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (FloatCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected CharCursor fetch() {
            if (this.index < SortedIterationCharFloatHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationCharFloatHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationCharFloatHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }
}

