/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.websocket.event;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.events.Event;
import org.openhab.core.io.websocket.event.EventDTO;
import org.openhab.core.io.websocket.event.EventProcessingException;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.events.ItemEventFactory;
import org.openhab.core.types.Command;
import org.openhab.core.types.RefreshType;
import org.openhab.core.types.State;
import org.openhab.core.types.TimeSeries;
import org.openhab.core.types.Type;
import org.openhab.core.types.TypeParser;
import org.openhab.core.types.UnDefType;

@NonNullByDefault
public class ItemEventUtility {
    private static final Pattern TOPIC_PATTERN = Pattern.compile("openhab/items/(?<entity>\\w+)/(?<action>\\w+)");
    private static final String TYPE_POSTFIX = "Type";
    private final Gson gson;
    private final ItemRegistry itemRegistry;

    public ItemEventUtility(Gson gson, ItemRegistry itemRegistry) {
        this.gson = gson;
        this.itemRegistry = itemRegistry;
    }

    public Event createCommandEvent(EventDTO eventDTO) throws EventProcessingException {
        Matcher matcher = this.getTopicMatcher(eventDTO.topic, "command");
        Item item = this.getItem(matcher.group("entity"));
        Type command = this.parseType(eventDTO.payload);
        if (command instanceof Command) {
            Command command1 = (Command)command;
            List acceptedItemCommandTypes = item.getAcceptedCommandTypes();
            if (acceptedItemCommandTypes.contains(command.getClass())) {
                return ItemEventFactory.createCommandEvent((String)item.getName(), (Command)command1, (String)eventDTO.source);
            }
        }
        throw new EventProcessingException("Incompatible datatype, rejected.");
    }

    public Event createStateEvent(EventDTO eventDTO) throws EventProcessingException {
        Matcher matcher = this.getTopicMatcher(eventDTO.topic, "state");
        Item item = this.getItem(matcher.group("entity"));
        Type state = this.parseType(eventDTO.payload);
        if (state instanceof State) {
            State state1 = (State)state;
            List acceptedItemStateTypes = item.getAcceptedDataTypes();
            if (acceptedItemStateTypes.contains(state.getClass())) {
                return ItemEventFactory.createStateEvent((String)item.getName(), (State)state1, (String)eventDTO.source);
            }
        }
        throw new EventProcessingException("Incompatible datatype, rejected.");
    }

    public Event createTimeSeriesEvent(EventDTO eventDTO) throws EventProcessingException {
        Matcher matcher = this.getTopicMatcher(eventDTO.topic, "timeseries");
        Item item = this.getItem(matcher.group("entity"));
        TimeSeries timeSeries = this.parseTimeSeries(eventDTO.payload);
        return ItemEventFactory.createTimeSeriesEvent((String)item.getName(), (TimeSeries)timeSeries, (String)eventDTO.source);
    }

    private Matcher getTopicMatcher(@Nullable String topic, String action) throws EventProcessingException {
        if (topic == null) {
            throw new EventProcessingException("Topic must not be null");
        }
        Matcher matcher = TOPIC_PATTERN.matcher(topic);
        if (!matcher.matches()) {
            throw new EventProcessingException("Topic must follow the format {namespace}/{entityType}/{entity}/{action}.");
        }
        if (!action.equals(matcher.group("action"))) {
            throw new EventProcessingException("Topic does not match event type.");
        }
        return matcher;
    }

    private Item getItem(String itemName) throws EventProcessingException {
        try {
            return this.itemRegistry.getItem(itemName);
        }
        catch (ItemNotFoundException e) {
            throw new EventProcessingException("Could not find item '" + itemName + "' in registry.");
        }
    }

    private TimeSeries parseTimeSeries(@Nullable String payload) throws EventProcessingException {
        ItemTimeSeriesEventPayloadBean bean = null;
        try {
            bean = (ItemTimeSeriesEventPayloadBean)this.gson.fromJson(payload, ItemTimeSeriesEventPayloadBean.class);
        }
        catch (JsonParseException jsonParseException) {
            // empty catch block
        }
        if (bean == null) {
            throw new EventProcessingException("Failed to deserialize payload '" + payload + "'.");
        }
        TimeSeries timeSeries = new TimeSeries(TimeSeries.Policy.valueOf((String)bean.policy));
        for (ItemTimeSeriesEventPayloadBean.TimeSeriesPayload timeSeriesPayload : bean.timeSeries) {
            Type value = this.parseType(timeSeriesPayload.type, timeSeriesPayload.value);
            if (value instanceof State) {
                State state = (State)value;
                try {
                    Instant timestamp = Instant.parse(timeSeriesPayload.timestamp);
                    timeSeries.add(timestamp, state);
                    continue;
                }
                catch (DateTimeParseException e) {
                    throw new EventProcessingException("Could not parse '" + timeSeriesPayload.timestamp + "' to an instant.");
                }
            }
            throw new EventProcessingException("Only states are allowed in timeseries events.");
        }
        return timeSeries;
    }

    private Type parseType(@Nullable String payload) throws EventProcessingException {
        ItemEventPayloadBean bean = null;
        try {
            bean = (ItemEventPayloadBean)this.gson.fromJson(payload, ItemEventPayloadBean.class);
        }
        catch (JsonParseException jsonParseException) {
            // empty catch block
        }
        if (bean == null) {
            throw new EventProcessingException("Failed to deserialize payload '" + payload + "'.");
        }
        return this.parseType(bean.type, bean.value);
    }

    private Type parseType(String type, String value) throws EventProcessingException {
        String simpleClassName = type + TYPE_POSTFIX;
        Object returnType = simpleClassName.equals(UnDefType.class.getSimpleName()) ? UnDefType.valueOf((String)value) : (simpleClassName.equals(RefreshType.class.getSimpleName()) ? RefreshType.valueOf((String)value) : TypeParser.parseType((String)simpleClassName, (String)value));
        if (returnType == null) {
            throw new EventProcessingException("Error parsing simpleClassName '" + simpleClassName + "' with value '" + value + "'.");
        }
        return returnType;
    }

    private static class ItemEventPayloadBean {
        @NonNullByDefault(value={})
        public String type;
        @NonNullByDefault(value={})
        public String value;

        private ItemEventPayloadBean() {
        }
    }

    private static class ItemTimeSeriesEventPayloadBean {
        @NonNullByDefault(value={})
        private List<TimeSeriesPayload> timeSeries;
        @NonNullByDefault(value={})
        private String policy;

        private ItemTimeSeriesEventPayloadBean() {
        }

        private static class TimeSeriesPayload {
            @NonNullByDefault(value={})
            private String type;
            @NonNullByDefault(value={})
            private String value;
            @NonNullByDefault(value={})
            private String timestamp;

            private TimeSeriesPayload() {
            }
        }
    }
}

