/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util.collections;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.internal.util.collections.ImmutableIntList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
class ImmutableIntArray
implements ImmutableIntList {
    private final int @NotNull [] array;

    ImmutableIntArray(int ... array) {
        this.array = array;
        assert (array.length > 1);
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public int get(int index) {
        return this.array[Checks.index(index, this.array.length)];
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableIntList)) {
            return false;
        }
        if (o instanceof ImmutableIntArray) {
            return Arrays.equals(this.array, ((ImmutableIntArray)o).array);
        }
        ImmutableIntList that = (ImmutableIntList)o;
        if (this.array.length != that.size()) {
            return false;
        }
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] == that.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    @NotNull
    public String toString() {
        return Arrays.toString(this.array);
    }
}

