/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.util.io.IOUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.storage.BuildTargetConfiguration;
import org.jetbrains.jps.incremental.storage.BuildTargetStateManagerImpl;
import org.jetbrains.jps.model.JpsModel;

@ApiStatus.Internal
public final class BuildTargetTypeState {
    private static final int VERSION = 1;
    private static final Logger LOG = Logger.getInstance(BuildTargetTypeState.class);
    private final Object2IntOpenHashMap<BuildTarget<?>> targetIds;
    private final List<Pair<String, Integer>> staleTargetIds;
    private final ConcurrentMap<BuildTarget<?>, BuildTargetConfiguration> configurations;
    private final BuildTargetType<?> targetType;
    private final BuildTargetStateManagerImpl targetStateManager;
    private final Path targetStateFile;
    private volatile long myAverageTargetBuildTimeMs;

    public BuildTargetTypeState(@NotNull BuildTargetType<?> targetType, @NotNull BuildTargetStateManagerImpl state, @NotNull BuildDataPaths dataPaths, @NotNull JpsModel model) {
        if (targetType == null) {
            BuildTargetTypeState.$$$reportNull$$$0(0);
        }
        if (state == null) {
            BuildTargetTypeState.$$$reportNull$$$0(1);
        }
        if (dataPaths == null) {
            BuildTargetTypeState.$$$reportNull$$$0(2);
        }
        if (model == null) {
            BuildTargetTypeState.$$$reportNull$$$0(3);
        }
        this.targetIds = new Object2IntOpenHashMap();
        this.myAverageTargetBuildTimeMs = -1L;
        this.targetIds.defaultReturnValue(-1);
        this.targetType = targetType;
        this.targetStateManager = state;
        this.targetStateFile = dataPaths.getTargetTypeDataRootDir(targetType).resolve("targets.dat");
        this.configurations = new ConcurrentHashMap();
        this.staleTargetIds = new ArrayList<Pair<String, Integer>>();
        this.load(model);
    }

    private void load(@NotNull JpsModel model) {
        if (model == null) {
            BuildTargetTypeState.$$$reportNull$$$0(4);
        }
        if (Files.notExists(this.targetStateFile, new LinkOption[0])) {
            return;
        }
        try (DataInputStream input = new DataInputStream(new BufferedInputStream(Files.newInputStream(this.targetStateFile, new OpenOption[0])));){
            int version = input.readInt();
            int size = input.readInt();
            BuildTargetLoader<?> loader = this.targetType.createLoader(model);
            while (size-- > 0) {
                String stringId = IOUtil.readString((DataInput)input);
                int intId = input.readInt();
                this.targetStateManager.markUsedId(intId);
                Object target = loader.createTarget(stringId);
                if (target != null) {
                    this.targetIds.put(target, intId);
                    continue;
                }
                this.staleTargetIds.add((Pair<String, Integer>)Pair.create((Object)stringId, (Object)intId));
            }
            if (version >= 1) {
                this.myAverageTargetBuildTimeMs = input.readLong();
            }
        }
        catch (IOException e) {
            LOG.info("Cannot load " + this.targetType.getTypeId() + " targets data: " + e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void save() {
        try {
            NioFiles.createParentDirectories((Path)this.targetStateFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try (DataOutputStream output = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(this.targetStateFile, new OpenOption[0])));){
            output.writeInt(1);
            output.writeInt(this.targetIds.size() + this.staleTargetIds.size());
            for (Object2IntMap.Entry entry : this.targetIds.object2IntEntrySet()) {
                IOUtil.writeString((String)((BuildTarget)entry.getKey()).getId(), (DataOutput)output);
                output.writeInt(entry.getIntValue());
            }
            for (Pair pair : this.staleTargetIds) {
                IOUtil.writeString((String)((String)pair.first), (DataOutput)output);
                output.writeInt((Integer)pair.second);
            }
            output.writeLong(this.myAverageTargetBuildTimeMs);
        }
        catch (IOException e) {
            LOG.info("Cannot save " + this.targetType.getTypeId() + " targets data: " + e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    public synchronized List<Pair<String, Integer>> getStaleTargetIds() {
        return new ArrayList<Pair<String, Integer>>(this.staleTargetIds);
    }

    public synchronized void removeStaleTarget(@NotNull String targetId) {
        if (targetId == null) {
            BuildTargetTypeState.$$$reportNull$$$0(5);
        }
        this.staleTargetIds.removeIf(pair -> ((String)pair.first).equals(targetId));
    }

    public synchronized int getTargetId(BuildTarget<?> target) {
        int result = this.targetIds.getInt(target);
        if (result == -1) {
            result = this.targetStateManager.getFreeId();
            this.targetIds.put(target, result);
        }
        return result;
    }

    public void setAverageTargetBuildTime(long timeInMs) {
        this.myAverageTargetBuildTimeMs = timeInMs;
    }

    public long getAverageTargetBuildTime() {
        return this.myAverageTargetBuildTimeMs;
    }

    @NotNull
    public BuildTargetConfiguration getConfiguration(@NotNull BuildTarget<?> target, @NotNull BuildDataPaths dataPaths) {
        BuildTargetConfiguration configuration;
        if (target == null) {
            BuildTargetTypeState.$$$reportNull$$$0(6);
        }
        if (dataPaths == null) {
            BuildTargetTypeState.$$$reportNull$$$0(7);
        }
        if ((configuration = (BuildTargetConfiguration)this.configurations.get(target)) != null) {
            BuildTargetConfiguration buildTargetConfiguration = configuration;
            if (buildTargetConfiguration == null) {
                BuildTargetTypeState.$$$reportNull$$$0(8);
            }
            return buildTargetConfiguration;
        }
        configuration = new BuildTargetConfiguration(target, dataPaths);
        BuildTargetConfiguration existing = this.configurations.putIfAbsent(target, configuration);
        BuildTargetConfiguration buildTargetConfiguration = existing == null ? configuration : existing;
        if (buildTargetConfiguration == null) {
            BuildTargetTypeState.$$$reportNull$$$0(9);
        }
        return buildTargetConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPaths";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/storage/BuildTargetTypeState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/storage/BuildTargetTypeState";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeStaleTarget";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguration";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

