/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.indexing.shared.generator.IndexedFileHash;
import com.intellij.indexing.shared.generator.SharedIndexBase;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHash;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u00002\u00020\u0001BQ\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\u0004\b\u000e\u0010\u000fR#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R-\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0017\u0010\u0011R!\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0019\u001a\u0004\b\u001b\u0010\u001cR!\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0019\u001a\u0004\b\u001f\u0010\u001c\u00a8\u0006!"}, d2={"Lcom/intellij/indexing/shared/generator/HashedIndexedFiles;", "", "byProvider", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "hashes", "Lcom/intellij/indexing/shared/generator/IndexedFileHash;", "usedBases", "", "Lcom/intellij/indexing/shared/generator/SharedIndexBase;", "usedHashes", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHash;", "<init>", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/List;Ljava/util/List;)V", "getByProvider", "()Ljava/util/Map;", "getHashes", "getUsedBases", "()Ljava/util/List;", "getUsedHashes", "byProviderWithHashes", "getByProviderWithHashes", "byProviderWithHashes$delegate", "Lkotlin/Lazy;", "allHashes", "getAllHashes", "()Ljava/util/Set;", "allHashes$delegate", "allFiles", "getAllFiles", "allFiles$delegate", "intellij.indexing.shared.generator"})
@SourceDebugExtension(value={"SMAP\nIndexedFilesHashingTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexedFilesHashingTask.kt\ncom/intellij/indexing/shared/generator/HashedIndexedFiles\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n413#2:113\n1252#3,2:114\n865#3,2:116\n1255#3:118\n*S KotlinDebug\n*F\n+ 1 IndexedFilesHashingTask.kt\ncom/intellij/indexing/shared/generator/HashedIndexedFiles\n*L\n33#1:113\n33#1:114,2\n34#1:116,2\n33#1:118\n*E\n"})
public final class HashedIndexedFiles {
    @NotNull
    private final Map<IndexableFilesIterator, Set<VirtualFile>> byProvider;
    @NotNull
    private final Map<VirtualFile, IndexedFileHash> hashes;
    @NotNull
    private final List<SharedIndexBase> usedBases;
    @NotNull
    private final List<SharedIndexContentHash> usedHashes;
    @NotNull
    private final Lazy byProviderWithHashes$delegate;
    @NotNull
    private final Lazy allHashes$delegate;
    @NotNull
    private final Lazy allFiles$delegate;

    public HashedIndexedFiles(@NotNull Map<IndexableFilesIterator, ? extends Set<? extends VirtualFile>> byProvider, @NotNull Map<VirtualFile, IndexedFileHash> hashes, @NotNull List<SharedIndexBase> usedBases, @NotNull List<? extends SharedIndexContentHash> usedHashes) {
        Intrinsics.checkNotNullParameter(byProvider, (String)"byProvider");
        Intrinsics.checkNotNullParameter(hashes, (String)"hashes");
        Intrinsics.checkNotNullParameter(usedBases, (String)"usedBases");
        Intrinsics.checkNotNullParameter(usedHashes, (String)"usedHashes");
        this.byProvider = byProvider;
        this.hashes = hashes;
        this.usedBases = usedBases;
        this.usedHashes = usedHashes;
        this.byProviderWithHashes$delegate = LazyKt.lazy(() -> HashedIndexedFiles.byProviderWithHashes_delegate$lambda$2(this));
        this.allHashes$delegate = LazyKt.lazy(() -> HashedIndexedFiles.allHashes_delegate$lambda$3(this));
        this.allFiles$delegate = LazyKt.lazy(() -> HashedIndexedFiles.allFiles_delegate$lambda$4(this));
    }

    @NotNull
    public final Map<IndexableFilesIterator, Set<VirtualFile>> getByProvider() {
        return this.byProvider;
    }

    @NotNull
    public final Map<VirtualFile, IndexedFileHash> getHashes() {
        return this.hashes;
    }

    @NotNull
    public final List<SharedIndexBase> getUsedBases() {
        return this.usedBases;
    }

    @NotNull
    public final List<SharedIndexContentHash> getUsedHashes() {
        return this.usedHashes;
    }

    @NotNull
    public final Map<IndexableFilesIterator, Set<VirtualFile>> getByProviderWithHashes() {
        Lazy lazy = this.byProviderWithHashes$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final Set<IndexedFileHash> getAllHashes() {
        Lazy lazy = this.allHashes$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final Set<VirtualFile> getAllFiles() {
        Lazy lazy = this.allFiles$delegate;
        return (Set)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private static final HashMap byProviderWithHashes_delegate$lambda$2(HashedIndexedFiles this$0) {
        void $this$mapValuesTo$iv;
        Map<IndexableFilesIterator, Set<VirtualFile>> map = this$0.byProvider;
        Map destination$iv = new HashMap();
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv = $this$mapValuesTo$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void $this$filterTo$iv;
            void it;
            void it$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Map map2 = destination$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv;
            Object k = it$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Iterable iterable = (Iterable)it.getValue();
            Collection destination$iv2 = new HashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                VirtualFile file = (VirtualFile)element$iv;
                boolean bl3 = false;
                if (!this$0.hashes.containsKey(file)) continue;
                destination$iv2.add(element$iv);
            }
            HashSet hashSet = (HashSet)destination$iv2;
            map3.put(k, hashSet);
        }
        return (HashMap)destination$iv;
    }

    private static final HashSet allHashes_delegate$lambda$3(HashedIndexedFiles this$0) {
        return CollectionsKt.toHashSet((Iterable)this$0.hashes.values());
    }

    private static final HashSet allFiles_delegate$lambda$4(HashedIndexedFiles this$0) {
        return CollectionsKt.toHashSet((Iterable)this$0.hashes.keySet());
    }
}

