/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.Dbms;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ImportType;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbNamespace;
import com.intellij.database.psi.DbTable;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.project.Project;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ImportEditorContext {
    @NotNull
    private final DbDataSource myDataSource;
    @Nullable
    private final SearchPath mySearchPath;
    private final ImportManager myManager;
    private final DbNamespace myNamespace;
    private final @Unmodifiable List<DbTable> myTables;

    public ImportEditorContext(@NotNull DbDataSource dataSource, @Nullable DbNamespace namespace, @Nullable SearchPath searchPath) {
        if (dataSource == null) {
            ImportEditorContext.$$$reportNull$$$0(0);
        }
        this.myManager = ImportManager.of(dataSource.getDbms(), dataSource.getVersion());
        this.myNamespace = namespace;
        this.myTables = this.getContextTables();
        this.myDataSource = dataSource;
        this.mySearchPath = searchPath;
    }

    @Nullable
    public DbNamespace getNamespace() {
        return this.myNamespace;
    }

    @NotNull
    public ImportManager getManager() {
        ImportManager importManager = this.myManager;
        if (importManager == null) {
            ImportEditorContext.$$$reportNull$$$0(1);
        }
        return importManager;
    }

    public boolean isTableExists(@NotNull String name2) {
        if (name2 == null) {
            ImportEditorContext.$$$reportNull$$$0(2);
        }
        return ContainerUtil.exists(this.myTables, DasUtil.byName(name2));
    }

    @NotNull
    private @Unmodifiable List<DbTable> getContextTables() {
        DasNamespace namespace = DbImplUtilCore.getTopSingleNamespace(this.myNamespace);
        if (namespace == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ImportEditorContext.$$$reportNull$$$0(3);
            }
            return list;
        }
        List list = namespace.getDasChildren(ObjectKind.TABLE).filter(DbTable.class).toList();
        if (list == null) {
            ImportEditorContext.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public ImportType getImportType(@NotNull String consumerName) {
        if (consumerName == null) {
            ImportEditorContext.$$$reportNull$$$0(5);
        }
        ImportType importType = this.isTableExists(consumerName) ? ImportType.EXISTING_TABLE : ImportType.NEW_TABLE;
        if (importType == null) {
            ImportEditorContext.$$$reportNull$$$0(6);
        }
        return importType;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myDataSource.getProject();
        if (project == null) {
            ImportEditorContext.$$$reportNull$$$0(7);
        }
        return project;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.myDataSource.getDbms();
        if (dbms == null) {
            ImportEditorContext.$$$reportNull$$$0(8);
        }
        return dbms;
    }

    @NotNull
    public final DatabaseDialectEx getDialect() {
        DatabaseDialectEx databaseDialectEx = DbImplUtilCore.getDatabaseDialect(this.myDataSource);
        if (databaseDialectEx == null) {
            ImportEditorContext.$$$reportNull$$$0(9);
        }
        return databaseDialectEx;
    }

    @NotNull
    public NamingService getNamingService() {
        NamingService namingService = NamingServices.getNamingService(this.myDataSource.getDbms(), (BasicModel)ObjectUtils.tryCast((Object)this.myDataSource.getModel(), BasicModel.class));
        if (namingService == null) {
            ImportEditorContext.$$$reportNull$$$0(10);
        }
        return namingService;
    }

    @NotNull
    public SqlLanguageDialect getSqlDialect() {
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect(this.myDataSource);
        if (sqlLanguageDialect == null) {
            ImportEditorContext.$$$reportNull$$$0(11);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public CasingProvider getCasingProvider() {
        CasingProvider casingProvider = (CasingProvider)ObjectUtils.chooseNotNull((Object)((CasingProvider)ObjectUtils.tryCast((Object)this.myDataSource.getModel(), BasicModel.class)), (Object)DbImplUtilCore.getDatabaseDialect(this.myDataSource.getDbms()));
        if (casingProvider == null) {
            ImportEditorContext.$$$reportNull$$$0(12);
        }
        return casingProvider;
    }

    @NotNull
    public DbDataSource getDataSource() {
        DbDataSource dbDataSource = this.myDataSource;
        if (dbDataSource == null) {
            ImportEditorContext.$$$reportNull$$$0(13);
        }
        return dbDataSource;
    }

    @Nullable
    public SearchPath getSearchPath() {
        return this.mySearchPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ImportEditorContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumerName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ImportEditorContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextTables";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialect";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamingService";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasingProvider";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isTableExists";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getImportType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

