/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceModelStorage;
import com.intellij.database.dataSource.DataSourceStorageLocal;
import com.intellij.database.dataSource.DataSourceStorageShared;
import com.intellij.database.dataSource.DelegatingPersistentStateComponent;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceSerialization;
import com.intellij.database.model.DataSourceSnapshotManager;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.InternedJDomReader;
import com.intellij.ide.PlatformIdeService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.project.ProjectKt;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.io.SafeFileOutputStream;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.xml.dom.StaxFactory;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.ReaderWrapper;
import com.thoughtworks.xstream.io.xml.JDomWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class DataSourceStorage
extends SimpleModificationTracker
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DataSourceStorage.class);
    public static final Topic<Listener> TOPIC = new Topic(Listener.class);
    @NonNls
    static final String STORAGE_ENTRY_NAME = "dataSources";
    @NonNls
    static final String LEGACY_IDS_EXT = "ids";
    @NonNls
    static final String APP_STORAGE_FILE = "dataSources.ids";
    @NonNls
    static final String COMPONENT_NAME = "dataSourceStorage";
    @NotNull
    private final List<LocalDataSource> myDataSources;
    private final LocalDataSource.Listener myDataSourceListener;
    private final MessageBus myMessageBus;
    private boolean myInitialized;

    public static DataSourceStorage getStorage() {
        return (DataSourceStorage)((Object)ApplicationManager.getApplication().getService(DataSourceStorage.class));
    }

    public static DataSourceStorage getStorage(@Nullable Project project) {
        return project == null ? DataSourceStorage.getStorage() : DataSourceStorage.getProjectStorage(project);
    }

    public static DataSourceStorage getProjectStorage(@NotNull Project project) {
        if (project == null) {
            DataSourceStorage.$$$reportNull$$$0(0);
        }
        return (DataSourceStorage)((Object)project.getService(DataSourceStorage.class));
    }

    public DataSourceStorage(@NotNull ComponentManager componentManager) {
        if (componentManager == null) {
            DataSourceStorage.$$$reportNull$$$0(1);
        }
        this.myDataSources = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myInitialized = false;
        this.myMessageBus = componentManager.getMessageBus();
        this.myDataSourceListener = lds -> {
            this.incModificationCount();
            if (this.myMessageBus.isDisposed()) {
                return;
            }
            ((Listener)this.myMessageBus.syncPublisher(TOPIC)).dataSourceChanged(lds);
        };
    }

    protected void loadFromStorage(@NotNull ComponentManager componentManager, final Project project) {
        if (componentManager == null) {
            DataSourceStorage.$$$reportNull$$$0(2);
        }
        final DataSourceStorageLocal localStorage = DataSourceStorageLocal.getInstance(componentManager);
        final DataSourceStorageShared sharedStorage = DataSourceStorageShared.getInstance(componentManager);
        localStorage.setStateDelegate(new DelegatingPersistentStateComponent.StateDelegate(){

            @Override
            @NotNull
            public Element getState() {
                Element element = DataSourceStorage.this.getLocalState(project);
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return element;
            }

            @Override
            public void onExternalChange() {
                DataSourceStorage.this.readState(project, null, localStorage.getStoredState());
            }

            public long getModificationCount() {
                return DataSourceStorage.this.getModificationCount();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceStorage$1", "getState"));
            }
        });
        sharedStorage.setStateDelegate(new DelegatingPersistentStateComponent.StateDelegate(){

            @Override
            @NotNull
            public Element getState() {
                Element element = DataSourceStorage.this.getSharedState();
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                return element;
            }

            @Override
            public void onExternalChange() {
                DataSourceStorage.this.readState(project, sharedStorage.getStoredState(), localStorage.getStoredState());
            }

            public long getModificationCount() {
                return DataSourceStorage.this.getModificationCount();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceStorage$2", "getState"));
            }
        });
        this.readState(project, sharedStorage.getStoredState(), localStorage.getStoredState());
        this.myInitialized = true;
    }

    protected abstract DataSourceModelStorage getModelStorage();

    @Nullable
    protected DataSourceStorage getParentStorage() {
        return null;
    }

    public void doWhenInitialized(@NotNull Runnable runnable) {
        DataSourceStorage parentStorage;
        if (runnable == null) {
            DataSourceStorage.$$$reportNull$$$0(3);
        }
        Promise promise = (parentStorage = this.getParentStorage()) == null ? this.getLoadedPromise() : Promises.all(Arrays.asList(parentStorage.getLoadedPromise(), this.getLoadedPromise()));
        promise.onSuccess(ignored -> runnable.run());
    }

    @NotNull
    private Promise<?> getLoadedPromise() {
        Promise<?> promise = this.getModelStorage().getLoadedPromise();
        if (promise == null) {
            DataSourceStorage.$$$reportNull$$$0(4);
        }
        return promise;
    }

    @NotNull
    public List<LocalDataSource> getOwnDataSources() {
        List<LocalDataSource> list = this.myDataSources;
        if (list == null) {
            DataSourceStorage.$$$reportNull$$$0(5);
        }
        return list;
    }

    private void addDataSourceInner(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DataSourceStorage.$$$reportNull$$$0(6);
        }
        this.myDataSources.add(dataSource);
        dataSource.registered();
        this.addDataSourceListener(dataSource);
    }

    private void addDataSourceListener(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DataSourceStorage.$$$reportNull$$$0(7);
        }
        dataSource.addStorageListener(this.myDataSourceListener);
    }

    private boolean removeDataSourceInner(@NotNull LocalDataSource dataSource) {
        boolean removed;
        if (dataSource == null) {
            DataSourceStorage.$$$reportNull$$$0(8);
        }
        if (removed = this.myDataSources.remove(dataSource)) {
            dataSource.unregistered();
            dataSource.removeStorageListener(this.myDataSourceListener);
        }
        return removed;
    }

    private void retainAll(@NotNull Set<LocalDataSource> dataSources) {
        if (dataSources == null) {
            DataSourceStorage.$$$reportNull$$$0(9);
        }
        ArrayList<LocalDataSource> existentDataSources = new ArrayList<LocalDataSource>(this.myDataSources);
        for (LocalDataSource dataSource : existentDataSources) {
            if (dataSources.contains(dataSource)) continue;
            this.removeDataSource(dataSource);
        }
    }

    @NotNull
    public List<LocalDataSource> getDataSources() {
        List list = this.getDataSourcesImpl().toList();
        if (list == null) {
            DataSourceStorage.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public JBIterable<LocalDataSource> getDataSourcesImpl() {
        DataSourceStorage parentStorage = this.getParentStorage();
        JBIterable jBIterable = JBIterable.from(this.myDataSources).append(parentStorage != null ? parentStorage.myDataSources : null);
        if (jBIterable == null) {
            DataSourceStorage.$$$reportNull$$$0(11);
        }
        return jBIterable;
    }

    public void addDataSource(LocalDataSource dataSource) {
        LocalDataSource existing = this.getDataSourceById(dataSource.getUniqueId());
        DataSourceStorage parentStorage = this.getParentStorage();
        if (existing != null) {
            LOG.error(String.format("Unable to add %s datasource '%s' (%s@%d): '%s' (%s@%d) has the same id: %s", parentStorage == null ? "global" : "project", dataSource.getName(), dataSource.getClass().getSimpleName(), dataSource.hashCode(), existing.getName(), existing.getClass().getSimpleName(), existing.hashCode(), dataSource.getUniqueId()));
        } else if (dataSource.getDatabaseDriver() == null && ApplicationManager.getApplication() != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error(String.format("Unable to add %s datasource '%s' (%s@%d): driver is not configured", parentStorage == null ? "global" : "project", dataSource.getName(), dataSource.getClass().getSimpleName(), dataSource.hashCode()));
        } else if (dataSource.isGlobal() && parentStorage != null) {
            parentStorage.addDataSource(dataSource);
        } else {
            this.addDataSourceInner(dataSource);
            this.incModificationCount();
            ((Listener)this.myMessageBus.syncPublisher(TOPIC)).dataSourceAdded(dataSource);
        }
    }

    @Nullable
    public LocalDataSource getDataSourceById(String id) {
        return DataSourceStorage.getDataSourcesByIdInner(id, this.getDataSources());
    }

    @Nullable
    private static <L extends RawDataSource> L getDataSourcesByIdInner(@Nullable String id, @NotNull Collection<? extends L> dataSources) {
        if (dataSources == null) {
            DataSourceStorage.$$$reportNull$$$0(12);
        }
        for (RawDataSource dataSource : dataSources) {
            if (!dataSource.getUniqueId().equals(id)) continue;
            return (L)dataSource;
        }
        return null;
    }

    public void removeDataSource(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DataSourceStorage.$$$reportNull$$$0(13);
        }
        if (this.removeDataSourceInner(dataSource)) {
            this.incModificationCount();
            if (!this.myMessageBus.isDisposed()) {
                ((Listener)this.myMessageBus.syncPublisher(TOPIC)).dataSourceRemoved(dataSource);
            }
        } else {
            DataSourceStorage parentStorage = this.getParentStorage();
            if (parentStorage != null) {
                parentStorage.removeDataSource(dataSource);
            }
        }
    }

    public void updateDataSource(LocalDataSource dataSource) {
        dataSource.incModificationCount();
        boolean isMy = this.myDataSources.contains(dataSource);
        DataSourceStorage parentStorage = this.getParentStorage();
        if (parentStorage != null && dataSource.isGlobal() == isMy) {
            this.removeDataSource(dataSource);
            this.addDataSource(dataSource);
        } else if (isMy) {
            this.incModificationCount();
            ((Listener)this.myMessageBus.syncPublisher(TOPIC)).dataSourceChanged(dataSource);
        } else if (parentStorage != null) {
            parentStorage.updateDataSource(dataSource);
        }
    }

    public long getModificationCount() {
        DataSourceStorage parentStorage = this.getParentStorage();
        if (parentStorage != null) {
            return super.getModificationCount() + parentStorage.getModificationCount();
        }
        return super.getModificationCount();
    }

    public void dispose() {
    }

    public Element getSharedState() {
        Element element = new Element(COMPONENT_NAME);
        this.writeState(null, element);
        return element;
    }

    public void loadState(@Nullable Element sharedState, @NotNull Element localState) {
        if (localState == null) {
            DataSourceStorage.$$$reportNull$$$0(14);
        }
        this.readState(null, sharedState, localState);
    }

    public Element getLocalState(@Nullable Project project) {
        Element element = new Element("dataSourceStorageLocal");
        if (!this.myDataSources.isEmpty()) {
            element.setAttribute("created-in", DataSourceStorage.getCurrentVersion());
        }
        JDomWriter serializer2 = new JDomWriter(element);
        for (LocalDataSource dataSource : this.myDataSources) {
            LocalDataSourceSerialization.serialize(project, dataSource, (HierarchicalStreamWriter)serializer2, LocalDataSourceSerialization.SaveMode.LOCAL_CONFIG);
        }
        return element;
    }

    private static void readLocalState(@Nullable Element element, @Nullable Project project, boolean isGlobal, @NotNull Collection<LocalDataSource> dataSources, @Nullable Consumer<LocalDataSource> newDataSourcesConsumer, @NotNull Ref<Boolean> resetJdbcFlag) {
        if (dataSources == null) {
            DataSourceStorage.$$$reportNull$$$0(15);
        }
        if (resetJdbcFlag == null) {
            DataSourceStorage.$$$reportNull$$$0(16);
        }
        if (element == null) {
            for (LocalDataSource dataSource : dataSources) {
                if (!StringUtil.isEmpty((String)dataSource.getUsername())) continue;
                dataSource.setPasswordStorage(LocalDataSource.Storage.NO);
            }
        } else {
            String ver = element.getAttributeValue("created-in");
            resetJdbcFlag.set((Object)(!DataSourceStorage.getCurrentVersion().equals(ver) ? 1 : 0));
            DataSourceStorage.readDataSources((HierarchicalStreamReader)new InternedJDomReader(element), LocalDataSourceSerialization.SaveMode.LOCAL_CONFIG, project, isGlobal, (Function<String, LocalDataSource>)((Function)uuid -> (LocalDataSource)DataSourceStorage.getDataSourcesByIdInner(uuid, dataSources)), newDataSourcesConsumer);
        }
    }

    @NotNull
    private static String getCurrentVersion() {
        String string = ApplicationInfo.getInstance().getBuild().asString();
        if (string == null) {
            DataSourceStorage.$$$reportNull$$$0(17);
        }
        return string;
    }

    void readState(@Nullable Project project, @Nullable Element sharedState, @NotNull Element localState) {
        if (localState == null) {
            DataSourceStorage.$$$reportNull$$$0(18);
        }
        if (project != null && project.isDefault()) {
            return;
        }
        AsyncTask.frame(DatabaseBundle.message("loading.data.sources", new Object[0])).compute(null, () -> {
            this.readStateImpl(project, sharedState, localState);
            return null;
        });
        if (!this.myDataSources.isEmpty()) {
            String dsPart = project == null ? " global data sources" : " data sources for project " + project.getName() + "(" + project.getProjectFilePath() + ")";
            LOG.info("Loaded " + this.myDataSources.size() + dsPart);
        }
    }

    private void readStateImpl(@Nullable Project project, @Nullable Element sharedState, @NotNull Element localState) {
        List<Object> jdbcIntrospectorReset;
        if (localState == null) {
            DataSourceStorage.$$$reportNull$$$0(19);
        }
        Ref resetJdbcFlag = Ref.create((Object)false);
        List<LocalDataSource> newDataSources = DataSourceStorage.readDataSources(project, sharedState, localState, this.myDataSources, (Ref<Boolean>)resetJdbcFlag);
        this.getModelStorage().loadModels(newDataSources);
        this.applyNewDataSources(newDataSources);
        List<Object> list = jdbcIntrospectorReset = (Boolean)resetJdbcFlag.get() != false ? DataSourceStorage.resetJdbcIntrospector(newDataSources) : Collections.emptyList();
        if (!jdbcIntrospectorReset.isEmpty()) {
            Project anyProject = project != null ? project : DbImplUtilCore.getAnyProject();
            Executor executor = anyProject == null ? AsyncUtil.getEdtExecutor() : r -> DataSourceStorage.runWhenProjectIsInitialized(anyProject, r);
            executor.execute(() -> DataSourceStorage.notifyJdbcIntrospectorReset(anyProject, jdbcIntrospectorReset));
        }
    }

    private void applyNewDataSources(List<LocalDataSource> newDataSources) {
        HashSet<LocalDataSource> retainedExisting = new HashSet<LocalDataSource>(newDataSources);
        retainedExisting.retainAll(this.myDataSources);
        this.retainAll(retainedExisting);
        JBIterable.from(newDataSources).filter(ds -> !retainedExisting.contains(ds)).forEach(this::addDataSourceListener);
        this.myDataSources.clear();
        this.myDataSources.addAll(newDataSources);
        this.fireChangedWhenInitialized();
    }

    private void fireChangedWhenInitialized() {
        if (this.myInitialized) {
            this.fireChanged();
        } else {
            ApplicationManager.getApplication().invokeLater(this::fireChanged);
        }
    }

    private void fireChanged() {
        if (this.myMessageBus.isDisposed()) {
            return;
        }
        ((Listener)this.myMessageBus.syncPublisher(TOPIC)).dataSourceChanged(null);
        this.incModificationCount();
    }

    @NotNull
    private static List<LocalDataSource> readDataSources(@Nullable Project project, @Nullable Element sharedState, @NotNull Element localState, @NotNull List<LocalDataSource> existingDataSource, @NotNull Ref<Boolean> resetJdbcFlag) {
        ArrayList<LocalDataSource> newDataSources;
        boolean isGlobal;
        if (localState == null) {
            DataSourceStorage.$$$reportNull$$$0(20);
        }
        if (existingDataSource == null) {
            DataSourceStorage.$$$reportNull$$$0(21);
        }
        if (resetJdbcFlag == null) {
            DataSourceStorage.$$$reportNull$$$0(22);
        }
        boolean bl = isGlobal = project == null;
        if (sharedState != null) {
            newDataSources = new ArrayList();
            DataSourceStorage.readDataSources((HierarchicalStreamReader)new InternedJDomReader(sharedState), LocalDataSourceSerialization.SaveMode.CONFIG, project, isGlobal, (Function<String, LocalDataSource>)((Function)uuid -> null), (Consumer<LocalDataSource>)((Consumer)newDataSources::add));
        } else {
            newDataSources = new ArrayList<LocalDataSource>(existingDataSource);
        }
        DataSourceStorage.readLocalState(localState, project, isGlobal, newDataSources, (Consumer<LocalDataSource>)((Consumer)newDataSources::add), resetJdbcFlag);
        DataSourceStorage.mergeWithExisting(project, newDataSources, existingDataSource);
        ArrayList<LocalDataSource> arrayList = newDataSources;
        if (arrayList == null) {
            DataSourceStorage.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    private static @Unmodifiable Map<String, LocalDataSource> mergeWithExisting(@Nullable Project project, List<LocalDataSource> newDataSources, List<LocalDataSource> existingDataSources) {
        Map existing = ContainerUtil.map2Map(existingDataSources, ds -> Pair.create((Object)ds.getUniqueId(), (Object)ds));
        for (int i2 = 0; i2 < newDataSources.size(); ++i2) {
            LocalDataSource newDs = newDataSources.get(i2);
            LocalDataSource existingDs = (LocalDataSource)existing.get(newDs.getUniqueId());
            if (existingDs == null) continue;
            try {
                LocalDataSourceSerialization.INSTANCE.copyBySettingsTo(project, newDs, existingDs);
                newDataSources.set(i2, existingDs);
                continue;
            }
            catch (Throwable th) {
                LOG.error(th);
            }
        }
        return existing;
    }

    @NotNull
    public Promise<?> getLoadingPromise(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DataSourceStorage.$$$reportNull$$$0(24);
        }
        Promise<?> promise = this.getModelStorage().getLoadingPromise(dataSource);
        if (promise == null) {
            DataSourceStorage.$$$reportNull$$$0(25);
        }
        return promise;
    }

    public boolean isLoading(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DataSourceStorage.$$$reportNull$$$0(26);
        }
        return this.getModelStorage().isLoading(dataSource);
    }

    private static List<LocalDataSource> resetJdbcIntrospector(@NotNull Collection<LocalDataSource> newDataSources) {
        if (newDataSources == null) {
            DataSourceStorage.$$$reportNull$$$0(27);
        }
        ArrayList<LocalDataSource> jdbcFlagReset = new ArrayList<LocalDataSource>();
        for (LocalDataSource dataSource : newDataSources) {
            if (!dataSource.useJdbcIntrospector()) continue;
            dataSource.setUseJdbcIntrospector(false);
            jdbcFlagReset.add(dataSource);
        }
        return jdbcFlagReset;
    }

    private static void notifyJdbcIntrospectorReset(@Nullable Project project, @NotNull List<LocalDataSource> dataSources) {
        Application application;
        if (dataSources == null) {
            DataSourceStorage.$$$reportNull$$$0(28);
        }
        if ((application = ApplicationManager.getApplication()) == null || application.isUnitTestMode() || dataSources.isEmpty()) {
            return;
        }
        application.invokeLater(() -> PlatformIdeService.getInstance().notification("Database configuration", PlatformIdeService.NotificationType.WARNING, DatabaseBundle.message("notification.title.introspect.using.jdbc.metadata.option.disabled", new Object[0]), null, DatabaseBundle.message("notification.content.introspection.using.jdbc.metadata.disabled", new Object[0]) + "\n\t" + StringUtil.join((Collection)dataSources, AbstractDataSource::getName, (String)"\n\t"), project, "DataSourceStorage.jdbc.introspector.reset", PlatformIdeService.getInstance().createHyperlinkConsumer()));
    }

    void writeState(Project project, Element element) {
        if (project != null && project.isDefault()) {
            return;
        }
        this.writeStateInner(project, element);
    }

    @Nullable
    public static Path getStoragePath(@Nullable Project project) {
        if (project == null) {
            return Paths.get(PathManager.getOptionsPath(), APP_STORAGE_FILE);
        }
        if (project.isDisposed() || project.isDefault()) {
            return null;
        }
        if (ProjectKt.isDirectoryBased((Project)project)) {
            Path path = ProjectKt.getStateStore((Project)project).getDirectoryStorePath();
            return path == null ? null : path.resolve(APP_STORAGE_FILE);
        }
        String projectFilePath = project.getProjectFilePath();
        if (projectFilePath == null) {
            return null;
        }
        return Paths.get(FileUtilRt.getNameWithoutExtension((String)projectFilePath) + ".ids", new String[0]);
    }

    @Nullable
    public static @SystemIndependent String getStorageDir(@Nullable Project project) {
        IProjectStore projectStore;
        Path path = DataSourceStorage.getStoragePath(project);
        if (project != null && !project.isDisposed() && path != null && (projectStore = ProjectKt.getStateStore((Project)project)).getStorageScheme() == StorageScheme.DEFAULT) {
            return FileUtil.toSystemIndependentName((String)path.getParent().toString()) + "/.ideaDataSources";
        }
        return path == null ? null : FileUtil.toSystemIndependentName((String)path.getParent().toString()) + "/dataSources";
    }

    @TestOnly
    public Element getStateInner(@Nullable Project project) {
        Element element = new Element(COMPONENT_NAME);
        this.writeStateInner(project, element);
        return element;
    }

    private void writeStateInner(Project project, Element element) {
        boolean notEmpty;
        boolean bl = notEmpty = !this.myDataSources.isEmpty();
        if (notEmpty) {
            element.setAttribute("format", "xml");
            element.setAttribute("multifile-model", "true");
        }
        if (notEmpty) {
            JDomWriter serializer2 = new JDomWriter(element);
            for (LocalDataSource dataSource : this.myDataSources) {
                LocalDataSourceSerialization.serialize(project, dataSource, (HierarchicalStreamWriter)serializer2, LocalDataSourceSerialization.SaveMode.CONFIG);
            }
        }
    }

    private static void readDataSources(@NotNull HierarchicalStreamReader xmlReader, @NotNull LocalDataSourceSerialization.SaveMode mode, @Nullable Project project, boolean isGlobal, @NotNull Function<String, LocalDataSource> dataSourceLocator, @Nullable Consumer<LocalDataSource> newDataSourcesConsumer) {
        if (xmlReader == null) {
            DataSourceStorage.$$$reportNull$$$0(29);
        }
        if (mode == null) {
            DataSourceStorage.$$$reportNull$$$0(30);
        }
        if (dataSourceLocator == null) {
            DataSourceStorage.$$$reportNull$$$0(31);
        }
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            String source = xmlReader.getAttribute("source");
            if ("data-source".equals(xmlReader.getNodeName())) {
                LocalDataSource existingDataSource;
                String uuid = xmlReader.getAttribute("uuid");
                LocalDataSource localDataSource = existingDataSource = uuid == null ? null : (LocalDataSource)dataSourceLocator.fun((Object)uuid);
                if (existingDataSource != null || mode.includeConfig()) {
                    LocalDataSource dataSource;
                    if (existingDataSource != null) {
                        dataSource = existingDataSource;
                    } else if (source == null || "LOCAL".equals(source)) {
                        dataSource = new LocalDataSource();
                    } else {
                        LOG.warn("Unsupported source: " + source);
                        dataSource = null;
                    }
                    if (dataSource != null) {
                        LocalDataSourceSerialization.deserialize(project, dataSource, xmlReader, mode);
                        dataSource.setGlobal(isGlobal);
                        if (existingDataSource != dataSource && newDataSourcesConsumer != null) {
                            newDataSourcesConsumer.consume((Object)dataSource);
                        }
                    }
                }
            }
            xmlReader.moveUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public boolean writeToDisk(@NotNull Project project, @NotNull String storagePath, LocalDataSourceSerialization.SaveMode mode) {
        if (project == null) {
            DataSourceStorage.$$$reportNull$$$0(32);
        }
        if (storagePath == null) {
            DataSourceStorage.$$$reportNull$$$0(33);
        }
        File original = new File(PathUtil.toPresentableUrl((String)storagePath));
        if (this.myDataSources.isEmpty()) {
            FileUtil.delete((File)original);
            return true;
        }
        if (!original.exists()) {
            FileUtil.createParentDirs((File)original);
        }
        PrettyPrintWriter serializer2 = null;
        String errorMessage = null;
        try {
            SafeFileOutputStream safeStream;
            SafeFileOutputStream os = safeStream = new SafeFileOutputStream(original);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8));
            serializer2 = new PrettyPrintWriter((Writer)printWriter);
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            serializer2.startNode("component");
            serializer2.addAttribute("name", COMPONENT_NAME);
            for (LocalDataSource dataSource : this.myDataSources) {
                LocalDataSourceSerialization.serialize(project, dataSource, (HierarchicalStreamWriter)serializer2, mode);
            }
            serializer2.endNode();
            serializer2.close();
        }
        catch (XStreamException e) {
            errorMessage = e.getMessage();
        }
        finally {
            if (serializer2 != null) {
                try {
                    serializer2.close();
                }
                catch (Exception e) {
                    errorMessage = e.getMessage();
                }
            }
        }
        if (errorMessage != null) {
            LOG.warn(errorMessage);
            PlatformIdeService.getInstance().notification("Database configuration", PlatformIdeService.NotificationType.ERROR, null, null, DatabaseBundle.message("notification.content.failed.to.save.data.sources.br", errorMessage), project, "DataSourceStorage.save.failed");
            return false;
        }
        return true;
    }

    @TestOnly
    public void loadTestsStorage(@NotNull Project project, @NotNull String storagePath) {
        if (project == null) {
            DataSourceStorage.$$$reportNull$$$0(34);
        }
        if (storagePath == null) {
            DataSourceStorage.$$$reportNull$$$0(35);
        }
        DbImplUtilCore.invokeOnPooledThreadSync(() -> {
            List<LocalDataSource> dataSources = this.loadFromDisk(project, Paths.get(storagePath, new String[0]), LocalDataSourceSerialization.SaveMode.ALL, null);
            if (dataSources == null) {
                return;
            }
            for (LocalDataSource dataSource : dataSources) {
                this.addDataSourceInner(dataSource);
                DataSourceSnapshotManager.getInstance().apply(project, dataSource);
            }
            this.fireChanged();
        });
    }

    @Nullable
    private List<LocalDataSource> loadFromDisk(@Nullable Project project, @NotNull Path file, LocalDataSourceSerialization.SaveMode mode, @Nullable ErrorHandler errorHandler) {
        if (file == null) {
            DataSourceStorage.$$$reportNull$$$0(36);
        }
        if (!Files.exists(file, new LinkOption[0]) || Files.isDirectory(file, new LinkOption[0])) {
            return null;
        }
        boolean isGlobal = this.getParentStorage() == null;
        Function dataSourceLocator = uuid -> DataSourceStorage.getDataSourcesByIdInner(uuid, this.myDataSources);
        try {
            return DataSourceStorage.loadFromDisk(Files.newInputStream(file, new OpenOption[0]), mode, project, errorHandler, isGlobal, (Function<String, LocalDataSource>)dataSourceLocator);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (AssertionError | Exception e) {
            DataSourceStorage.processCorruption(project, file, (Throwable)e);
            return null;
        }
    }

    public static void processCorruption(@Nullable Project project, @NotNull Path file, Throwable e) {
        if (file == null) {
            DataSourceStorage.$$$reportNull$$$0(37);
        }
        String reason = ExceptionUtil.getThrowableText((Throwable)e);
        String message = e.getMessage();
        if (message != null && message.length() > 1024) {
            RuntimeException truncated = new RuntimeException(message.substring(0, 1024) + "...");
            truncated.setStackTrace(e.getStackTrace());
            e = truncated;
        }
        LOG.warn(e);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            DataSourceStorage.backupCorruptedVersion(project, file, reason);
        }
    }

    private static void backupCorruptedVersion(@Nullable Project project, @NotNull Path file, String reason) {
        if (file == null) {
            DataSourceStorage.$$$reportNull$$$0(38);
        }
        if (Files.exists(file, new LinkOption[0])) {
            try {
                String backupPrefix = FileUtilRt.getNameWithoutExtension((String)file.getFileName().toString()) + ".corrupted." + new SimpleDateFormat("yyyyMMdd-hhmmss").format(new Date(System.currentTimeMillis()));
                String backupName = backupPrefix + "." + FileUtilRt.getExtension((String)file.getFileName().toString());
                String backupReason = backupPrefix + ".reason.txt";
                File backup = file.getParent().resolve(backupName).toFile();
                FileUtil.rename((File)file.toFile(), (File)backup);
                FileUtil.writeToFile((File)file.getParent().resolve(backupReason).toFile(), (String)reason);
                String message = DatabaseBundle.message("notification.content.corrupted.backup.copy.created", file.toAbsolutePath().toString(), backup.getName());
                PlatformIdeService.getInstance().notification("Database configuration", PlatformIdeService.NotificationType.ERROR, DatabaseBundle.message("notification.title.failed.to.load.data.sources", new Object[0]), null, message, project, "DataSourceStorage.failed.to.load");
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    @TestOnly
    public static List<LocalDataSource> loadFromDisk(Project project, @NotNull InputStream stream, LocalDataSourceSerialization.SaveMode mode, ErrorHandler handler) {
        if (stream == null) {
            DataSourceStorage.$$$reportNull$$$0(39);
        }
        return DataSourceStorage.loadFromDisk(stream, mode, project, handler, false, (Function<String, LocalDataSource>)((Function)uuid -> null));
    }

    protected static List<LocalDataSource> loadFromDisk(@NotNull InputStream stream, LocalDataSourceSerialization.SaveMode mode, @Nullable Project project, @Nullable ErrorHandler errorHandler, boolean isGlobal, Function<String, LocalDataSource> dataSourceLocator) {
        StaxReader streamReader;
        if (stream == null) {
            DataSourceStorage.$$$reportNull$$$0(40);
        }
        try {
            streamReader = new StaxReader(new QNameMap(), (XMLStreamReader)StaxFactory.createXmlStreamReader((InputStream)stream, null));
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        return DataSourceStorage.loadDataSources((HierarchicalStreamReader)streamReader, mode, project, errorHandler, isGlobal, dataSourceLocator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<LocalDataSource> loadDataSources(HierarchicalStreamReader reader, LocalDataSourceSerialization.SaveMode mode, Project project, final ErrorHandler errorHandler, boolean isGlobal, Function<String, LocalDataSource> dataSourceLocator) {
        MyReader wrapper = new MyReader(reader){

            public void appendErrors(ErrorWriter errorWriter) {
                super.appendErrors(errorWriter);
                if (errorHandler != null && errorWriter instanceof ConversionException) {
                    errorHandler.addError(((ConversionException)errorWriter).getShortMessage(), null);
                }
            }
        };
        try {
            if ("component".equals(reader.getNodeName())) {
                ArrayList<LocalDataSource> newDataSources = new ArrayList<LocalDataSource>();
                DataSourceStorage.readDataSources((HierarchicalStreamReader)wrapper, mode, project, isGlobal, dataSourceLocator, (Consumer<LocalDataSource>)((Consumer)newDataSources::add));
                ArrayList<LocalDataSource> arrayList = newDataSources;
                return arrayList;
            }
            List<LocalDataSource> list = Collections.emptyList();
            return list;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public int getCount() {
        return this.myDataSources.size();
    }

    @TestOnly
    public void prune() {
        this.retainAll(Collections.emptySet());
    }

    private static void runWhenProjectIsInitialized(@NotNull Project project, @NotNull Runnable r) {
        if (project == null) {
            DataSourceStorage.$$$reportNull$$$0(41);
        }
        if (r == null) {
            DataSourceStorage.$$$reportNull$$$0(42);
        }
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)r::run));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 10, 11, 17, 23, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 17: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceStorage";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = STORAGE_ENTRY_NAME;
                break;
            }
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localState";
                break;
            }
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resetJdbcFlag";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingDataSource";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDataSources";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlReader";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceLocator";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storagePath";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceStorage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedPromise";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnDataSources";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourcesImpl";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentVersion";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "readDataSources";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadingPromise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProjectStorage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadFromStorage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doWhenInitialized";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 17: 
            case 23: 
            case 25: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addDataSourceInner";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addDataSourceListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeDataSourceInner";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "retainAll";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourcesByIdInner";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeDataSource";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readLocalState";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "readState";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readStateImpl";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "readDataSources";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLoadingPromise";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isLoading";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "resetJdbcIntrospector";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "notifyJdbcIntrospectorReset";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "writeToDisk";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "loadTestsStorage";
                break;
            }
            case 36: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "loadFromDisk";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "processCorruption";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "backupCorruptedVersion";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "runWhenProjectIsInitialized";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 10, 11, 17, 23, 25 -> new IllegalStateException(string);
        };
    }

    public static interface Listener
    extends EventListener {
        default public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                Listener.$$$reportNull$$$0(0);
            }
        }

        default public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                Listener.$$$reportNull$$$0(1);
            }
        }

        default public void dataSourceChanged(@Nullable LocalDataSource dataSource) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataSource";
            objectArray2[1] = "com/intellij/database/dataSource/DataSourceStorage$Listener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dataSourceAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dataSourceRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class MacroFilter
    extends PathMacroFilter {
        public boolean skipPathMacros(@NotNull Element element) {
            if (element == null) {
                MacroFilter.$$$reportNull$$$0(0);
            }
            return "component".equals(element.getName()) && ("DataSourceManagerImpl".equals(element.getAttributeValue("name")) || DataSourceStorage.COMPONENT_NAME.equals(element.getAttributeValue("name")));
        }

        public boolean skipPathMacros(@NotNull Attribute attribute) {
            if (attribute == null) {
                MacroFilter.$$$reportNull$$$0(1);
            }
            return super.skipPathMacros(attribute);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "attribute";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dataSource/DataSourceStorage$MacroFilter";
            objectArray[2] = "skipPathMacros";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyReader
    extends ReaderWrapper {
        MyReader(HierarchicalStreamReader reader) {
            super(reader);
        }

        public String getNodeName() {
            return DbUtil.intern2(super.getNodeName());
        }

        public String getValue() {
            return DbUtil.intern2(super.getValue());
        }

        public String getAttribute(String name2) {
            return DbUtil.intern2(super.getAttribute(name2));
        }

        public String getAttribute(int index) {
            return DbUtil.intern2(super.getAttribute(index));
        }
    }

    public static final class Prj
    extends DataSourceStorage {
        private final Project myProject;

        public Prj(Project project) {
            super((ComponentManager)project);
            this.myProject = project;
            this.loadFromStorage((ComponentManager)project, project);
        }

        @Override
        @Nullable
        protected DataSourceStorage getParentStorage() {
            return Prj.getStorage();
        }

        @Override
        public void doWhenInitialized(@NotNull Runnable runnable) {
            if (runnable == null) {
                Prj.$$$reportNull$$$0(0);
            }
            DataSourceStorage.runWhenProjectIsInitialized(this.myProject, () -> super.doWhenInitialized(runnable));
        }

        @Override
        protected DataSourceModelStorage getModelStorage() {
            return DataSourceModelStorage.getStorage(this.myProject);
        }

        @Override
        public void loadState(@Nullable Element sharedState, @NotNull Element localState) {
            if (localState == null) {
                Prj.$$$reportNull$$$0(1);
            }
            this.readState(this.myProject, sharedState, localState);
        }

        @Override
        public Element getSharedState() {
            Element element = new Element("DataSourceManagerImpl");
            this.writeState(this.myProject, element);
            return element;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localState";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/DataSourceStorage$Prj";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doWhenInitialized";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class App
    extends DataSourceStorage {
        public App() {
            super((ComponentManager)ApplicationManager.getApplication());
            this.loadFromStorage((ComponentManager)ApplicationManager.getApplication(), null);
        }

        @Override
        protected DataSourceModelStorage getModelStorage() {
            return DataSourceModelStorage.getStorage(null);
        }
    }
}

