/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.ui;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.url.template.MutableParametersHolder;
import com.intellij.database.dataSource.url.template.ParametersHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AuthWidgetBuilder {
    @Nullable
    public DatabaseAuthProvider.AuthWidget build(@Nullable Project var1, @NotNull DatabaseCredentials var2, @NotNull DatabaseConnectionConfig var3);

    public AuthWidgetBuilder addUserField();

    public AuthWidgetBuilder addUserField(@NotNull Supplier<@NlsContexts.Label String> var1);

    public AuthWidgetBuilder addPasswordField();

    public AuthWidgetBuilder addPasswordField(@NotNull Supplier<@NlsContexts.Label String> var1);

    public AuthWidgetBuilder addPasswordField(@NotNull Supplier<@NlsContexts.Label String> var1, @NotNull Serialiser<OneTimeString> var2, boolean var3, @Nullable UrlHandler<OneTimeString> var4);

    public AuthWidgetBuilder addTextField(@NotNull Supplier<@NlsContexts.Label String> var1, @NotNull Serialiser<String> var2, @Nullable UrlHandler<String> var3);

    public AuthWidgetBuilder addTextField(@NotNull Supplier<@NlsContexts.Label String> var1, @NotNull CompletionProvider var2, @NotNull Serialiser<String> var3, @Nullable UrlHandler<String> var4);

    public AuthWidgetBuilder addFileField(@NotNull Supplier<@NlsContexts.Label String> var1, @NotNull Supplier<@NlsContexts.Label String> var2, @NotNull Serialiser<String> var3, @Nullable UrlHandler<String> var4);

    public AuthWidgetBuilder addCheckBox(@NotNull Supplier<@NlsContexts.Label String> var1, @NotNull Serialiser<Boolean> var2, @Nullable UrlHandler<Boolean> var3);

    public AuthWidgetBuilder addHandler(String var1, @Nullable Serialiser<String> var2, @Nullable UrlHandler<String> var3);

    @NotNull
    public static Serialiser<Boolean> adapt(final @NotNull Serialiser<String> serialiser, final boolean def) {
        if (serialiser == null) {
            AuthWidgetBuilder.$$$reportNull$$$0(0);
        }
        return new Serialiser<Boolean>(){

            @Override
            public void save(Boolean v, @NotNull DatabaseConnectionConfig config, @Nullable DatabaseCredentials credentials) {
                if (config == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (v == null || v.equals(def)) {
                    return;
                }
                serialiser.save(v.toString(), config, credentials);
            }

            @Override
            public Boolean load(@NotNull DatabaseConnectionPoint point, @Nullable DatabaseCredentials credentials) {
                String v;
                if (point == null) {
                    1.$$$reportNull$$$0(1);
                }
                return (v = (String)serialiser.load(point, credentials)) == null ? def : Boolean.parseBoolean(v);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "config";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "point";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/ui/AuthWidgetBuilder$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "load";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static UrlHandler<Boolean> adapt(final @NotNull UrlHandler<String> handler, final boolean def) {
        if (handler == null) {
            AuthWidgetBuilder.$$$reportNull$$$0(1);
        }
        return new UrlHandler<Boolean>(){

            @Override
            public Boolean fromUrl(@NotNull ParametersHolder holder) {
                String p2;
                if (holder == null) {
                    2.$$$reportNull$$$0(0);
                }
                return (p2 = (String)handler.fromUrl(holder)) == null ? null : Boolean.valueOf(Boolean.parseBoolean(p2));
            }

            @Override
            public void toUrl(Boolean v, @NotNull MutableParametersHolder model) {
                if (model == null) {
                    2.$$$reportNull$$$0(1);
                }
                handler.toUrl(v == null || v.equals(def) ? "" : v.toString(), model);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "holder";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "model";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/ui/AuthWidgetBuilder$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fromUrl";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "toUrl";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static UrlHandler<OneTimeString> adapt(final @NotNull UrlHandler<String> handler, final OneTimeString def) {
        if (handler == null) {
            AuthWidgetBuilder.$$$reportNull$$$0(2);
        }
        return new UrlHandler<OneTimeString>(){

            @Override
            public OneTimeString fromUrl(@NotNull ParametersHolder holder) {
                String p2;
                if (holder == null) {
                    3.$$$reportNull$$$0(0);
                }
                return (p2 = (String)handler.fromUrl(holder)) == null ? null : new OneTimeString(p2);
            }

            @Override
            public void toUrl(OneTimeString v, @NotNull MutableParametersHolder model) {
                if (model == null) {
                    3.$$$reportNull$$$0(1);
                }
                handler.toUrl(v == null || v.equals((Object)def) ? "" : v.toString(), model);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "holder";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "model";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/ui/AuthWidgetBuilder$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fromUrl";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "toUrl";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static Serialiser<String> additionalPropertySerializer(final @NotNull String parameter) {
        if (parameter == null) {
            AuthWidgetBuilder.$$$reportNull$$$0(3);
        }
        return new Serialiser<String>(){

            @Override
            public void save(String v, @NotNull DatabaseConnectionConfig config, @Nullable DatabaseCredentials credentials) {
                if (config == null) {
                    4.$$$reportNull$$$0(0);
                }
                config.setAdditionalProperty(parameter, StringUtil.nullize((String)v));
            }

            @Override
            public String load(@NotNull DatabaseConnectionPoint point, @Nullable DatabaseCredentials credentials) {
                if (point == null) {
                    4.$$$reportNull$$$0(1);
                }
                return point.getAdditionalProperty(parameter);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "config";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "point";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/ui/AuthWidgetBuilder$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "load";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static UrlHandler<String> removeParameterHandler(final @NotNull String parameter) {
        if (parameter == null) {
            AuthWidgetBuilder.$$$reportNull$$$0(4);
        }
        return new UrlHandler<String>(){

            @Override
            public String fromUrl(@NotNull ParametersHolder holder) {
                if (holder == null) {
                    5.$$$reportNull$$$0(0);
                }
                return holder.getParameter(parameter);
            }

            @Override
            public void toUrl(String v, @NotNull MutableParametersHolder model) {
                if (model == null) {
                    5.$$$reportNull$$$0(1);
                }
                model.setParameter(parameter, "");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "holder";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "model";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/ui/AuthWidgetBuilder$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fromUrl";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "toUrl";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serialiser";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/ui/AuthWidgetBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "adapt";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "additionalPropertySerializer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParameterHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Serialiser<T> {
        public void save(T var1, @NotNull DatabaseConnectionConfig var2, @Nullable DatabaseCredentials var3);

        public T load(@NotNull DatabaseConnectionPoint var1, @Nullable DatabaseCredentials var2);
    }

    public static interface UrlHandler<T> {
        public T fromUrl(@NotNull ParametersHolder var1);

        public void toUrl(T var1, @NotNull MutableParametersHolder var2);
    }

    public static interface CompletionProvider {
        @NotNull
        public List<String> getItems(@NotNull DatabaseConnectionPoint var1, @NotNull Consumer<@NlsContexts.Tooltip String> var2);
    }
}

