/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.util.SmartPredicate;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterator;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TreePatternSerialization {
    private static final Logger LOG = Logger.getInstance(TreePatternSerialization.class);

    public static void serialize(@NotNull HierarchicalStreamWriter writer, @NotNull TreePattern pattern, boolean compact) {
        if (writer == null) {
            TreePatternSerialization.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            TreePatternSerialization.$$$reportNull$$$0(1);
        }
        if (pattern.root != null && pattern.root.groups.length != 0) {
            Map<TreePatternNode.PatternWrapper, Integer> enumerated = TreePatternSerialization.enumerateRequiredPatterns(pattern);
            if (compact) {
                TreePatternSerialization.serializeRootCompact(writer, pattern.root, enumerated);
            } else {
                TreePatternSerialization.serialize(writer, pattern.root, false, null, enumerated, true);
            }
        }
    }

    @NotNull
    private static Map<TreePatternNode.PatternWrapper, Integer> enumerateRequiredPatterns(@NotNull TreePattern pattern) {
        if (pattern == null) {
            TreePatternSerialization.$$$reportNull$$$0(2);
        }
        Object2IntOpenHashMap counters = new Object2IntOpenHashMap();
        TreePatternSerialization.countPatterns(pattern.root, (Object2IntMap<TreePatternNode.PatternWrapper>)counters);
        counters.values().removeIf(v -> v < 2);
        if (counters.isEmpty()) {
            Map<TreePatternNode.PatternWrapper, Integer> map = Collections.emptyMap();
            if (map == null) {
                TreePatternSerialization.$$$reportNull$$$0(3);
            }
            return map;
        }
        int i2 = 0;
        for (Object2IntMap.Entry entry : counters.object2IntEntrySet()) {
            entry.setValue(i2++);
        }
        Object2IntOpenHashMap object2IntOpenHashMap = counters;
        if (object2IntOpenHashMap == null) {
            TreePatternSerialization.$$$reportNull$$$0(4);
        }
        return object2IntOpenHashMap;
    }

    private static void countPatterns(TreePatternNode root, Object2IntMap<TreePatternNode.PatternWrapper> counters) {
        if (root.naming instanceof TreePatternNode.NegativeNaming) {
            SmartPredicate<TreePatternNode.PatternWrapper> predicate = ((TreePatternNode.NegativeNaming)root.naming).pattern;
            TreePatternSerialization.countPatterns(counters, predicate);
        }
        for (TreePatternNode.Group group : root.groups) {
            if (group.children == null) continue;
            for (TreePatternNode child : group.children) {
                TreePatternSerialization.countPatterns(child, counters);
            }
        }
    }

    private static void countPatterns(Object2IntMap<TreePatternNode.PatternWrapper> counters, SmartPredicate<TreePatternNode.PatternWrapper> predicate) {
        for (SmartPredicate<TreePatternNode.PatternWrapper> term : SmartPredicate.orTerms(predicate, false)) {
            for (TreePatternNode.PatternWrapper check : SmartPredicate.andTerms(term)) {
                counters.computeInt((Object)check, (p2, c2) -> c2 == null ? 1 : c2 + 1);
            }
        }
    }

    @Nullable
    public static TreePattern deserialize(@NotNull HierarchicalStreamReader reader) {
        TreePatternNode node;
        if (reader == null) {
            TreePatternSerialization.$$$reportNull$$$0(5);
        }
        return (node = TreePatternSerialization.deserializeNode(reader, true, true, new HashMap<String, SmartPredicate<TreePatternNode.PatternWrapper>>())) == null ? null : new TreePattern(node);
    }

    private static void serialize(@NotNull HierarchicalStreamWriter writer, @NotNull TreePatternNode node, boolean compact, @Nullable TreePatternNode.Group parentGroup, @NotNull Map<TreePatternNode.PatternWrapper, Integer> enumerated, boolean serializeEnumeration) {
        if (writer == null) {
            TreePatternSerialization.$$$reportNull$$$0(6);
        }
        if (node == null) {
            TreePatternSerialization.$$$reportNull$$$0(7);
        }
        if (enumerated == null) {
            TreePatternSerialization.$$$reportNull$$$0(8);
        }
        writer.startNode("node");
        if (compact) {
            if (parentGroup != null) {
                writer.addAttribute("kind", parentGroup.kind.code());
            }
            if (node.naming.names.length == 1) {
                TreePatternSerialization.serializeInner(writer, node.naming.names[0]);
            }
        }
        SmartPredicate<TreePatternNode.PatternWrapper> pattern = null;
        if (node.naming instanceof TreePatternNode.NegativeNaming) {
            writer.addAttribute("negative", "1");
            pattern = ((TreePatternNode.NegativeNaming)node.naming).pattern;
            if (TreePatternSerialization.serializePattern(writer, pattern, enumerated, true)) {
                pattern = null;
            }
        }
        if (serializeEnumeration) {
            TreePatternSerialization.serializeEnumeration(writer, enumerated);
        }
        if (pattern != null) {
            TreePatternSerialization.serializePattern(writer, pattern, enumerated, false);
        }
        if (!compact || node.naming.names.length > 1) {
            for (ObjectName name2 : node.naming.names) {
                TreePatternSerialization.serialize(writer, name2);
            }
        }
        if (compact) {
            TreePatternSerialization.serializeCompact(writer, node.groups, enumerated, false);
        } else {
            for (TreePatternNode.Group group : node.groups) {
                TreePatternSerialization.serialize(writer, group, enumerated);
            }
        }
        writer.endNode();
    }

    private static boolean serializePattern(@NotNull HierarchicalStreamWriter writer, @NotNull SmartPredicate<TreePatternNode.PatternWrapper> pattern, @NotNull Map<TreePatternNode.PatternWrapper, Integer> enumerated, boolean compactOnly) {
        JBIterator orIt;
        if (writer == null) {
            TreePatternSerialization.$$$reportNull$$$0(9);
        }
        if (pattern == null) {
            TreePatternSerialization.$$$reportNull$$$0(10);
        }
        if (enumerated == null) {
            TreePatternSerialization.$$$reportNull$$$0(11);
        }
        if (!(orIt = JBIterator.from(SmartPredicate.orTerms(pattern, false).iterator())).advance()) {
            return true;
        }
        if (!orIt.hasNext()) {
            return TreePatternSerialization.serializeChecks(writer, (SmartPredicate)orIt.current(), enumerated, true, compactOnly);
        }
        if (compactOnly) {
            return false;
        }
        writer.startNode("or");
        do {
            TreePatternSerialization.serializeChecks(writer, (SmartPredicate)orIt.current(), enumerated, false, false);
        } while (orIt.advance());
        writer.endNode();
        return true;
    }

    private static boolean serializeChecks(@NotNull HierarchicalStreamWriter writer, @NotNull SmartPredicate<TreePatternNode.PatternWrapper> term, @NotNull Map<TreePatternNode.PatternWrapper, Integer> enumerated, boolean compact, boolean compactOnly) {
        JBIterator cIt;
        if (writer == null) {
            TreePatternSerialization.$$$reportNull$$$0(12);
        }
        if (term == null) {
            TreePatternSerialization.$$$reportNull$$$0(13);
        }
        if (enumerated == null) {
            TreePatternSerialization.$$$reportNull$$$0(14);
        }
        if (!(cIt = JBIterator.from(SmartPredicate.andTerms(term).iterator())).advance()) {
            return true;
        }
        if (!cIt.hasNext()) {
            TreePatternSerialization.serializeCheck(writer, term, (TreePatternNode.PatternWrapper)cIt.current(), enumerated, compact);
            return true;
        }
        if (compactOnly) {
            return false;
        }
        writer.startNode("and");
        do {
            TreePatternSerialization.serializeCheck(writer, term, (TreePatternNode.PatternWrapper)cIt.current(), enumerated, false);
        } while (cIt.advance());
        writer.endNode();
        return true;
    }

    private static void serializeCheck(@NotNull HierarchicalStreamWriter writer, @NotNull SmartPredicate<TreePatternNode.PatternWrapper> term, @NotNull TreePatternNode.PatternWrapper check, @NotNull Map<TreePatternNode.PatternWrapper, Integer> enumerated, boolean compact) {
        Integer id;
        if (writer == null) {
            TreePatternSerialization.$$$reportNull$$$0(15);
        }
        if (term == null) {
            TreePatternSerialization.$$$reportNull$$$0(16);
        }
        if (check == null) {
            TreePatternSerialization.$$$reportNull$$$0(17);
        }
        if (enumerated == null) {
            TreePatternSerialization.$$$reportNull$$$0(18);
        }
        if (!compact) {
            writer.startNode("check");
        }
        if ((id = enumerated.get(check)) == null) {
            writer.addAttribute("condition", check.getText());
        } else {
            writer.addAttribute("condition-id", id.toString());
        }
        if (SmartPredicate.isNegative(term, check)) {
            writer.addAttribute("negate", "1");
        }
        if (!compact) {
            writer.endNode();
        }
    }

    private static void serializeEnumeration(@NotNull HierarchicalStreamWriter writer, @NotNull Map<TreePatternNode.PatternWrapper, Integer> enumerated) {
        if (writer == null) {
            TreePatternSerialization.$$$reportNull$$$0(19);
        }
        if (enumerated == null) {
            TreePatternSerialization.$$$reportNull$$$0(20);
        }
        for (Map.Entry<TreePatternNode.PatternWrapper, Integer> entry : enumerated.entrySet()) {
            writer.startNode("condition");
            writer.addAttribute("id", entry.getValue().toString());
            writer.addAttribute("value", entry.getKey().getText());
            writer.endNode();
        }
    }

    private static void serializeRootCompact(@NotNull HierarchicalStreamWriter writer, @NotNull TreePatternNode root, @NotNull Map<TreePatternNode.PatternWrapper, Integer> enumerated) {
        boolean compactRoot;
        if (writer == null) {
            TreePatternSerialization.$$$reportNull$$$0(21);
        }
        if (root == null) {
            TreePatternSerialization.$$$reportNull$$$0(22);
        }
        if (enumerated == null) {
            TreePatternSerialization.$$$reportNull$$$0(23);
        }
        boolean bl = compactRoot = root.groups.length == 0 || root.groups.length == 1 && root.groups[0].size() < 2;
        if (compactRoot) {
            TreePatternSerialization.serializeCompact(writer, root.groups, enumerated, true);
        } else {
            TreePatternSerialization.serialize(writer, root, true, null, enumerated, true);
        }
    }

    private static void serializeCompact(@NotNull HierarchicalStreamWriter writer, @NotNull TreePatternNode.Group[] groups, @NotNull Map<TreePatternNode.PatternWrapper, Integer> enumerated, boolean serializeEnumeration) {
        if (writer == null) {
            TreePatternSerialization.$$$reportNull$$$0(24);
        }
        if (enumerated == null) {
            TreePatternSerialization.$$$reportNull$$$0(25);
        }
        if (groups == null) {
            TreePatternSerialization.$$$reportNull$$$0(26);
        }
        for (TreePatternNode.Group group : groups) {
            TreePatternSerialization.serializeChildren(writer, group, true, true, enumerated, serializeEnumeration);
            TreePatternSerialization.serializeChildren(writer, group, false, true, enumerated, serializeEnumeration);
        }
    }

    private static void serializeChildren(@NotNull HierarchicalStreamWriter writer, TreePatternNode.Group group, boolean negative, boolean compact, @NotNull Map<TreePatternNode.PatternWrapper, Integer> enumerated, boolean serializeEnumeration) {
        if (writer == null) {
            TreePatternSerialization.$$$reportNull$$$0(27);
        }
        if (enumerated == null) {
            TreePatternSerialization.$$$reportNull$$$0(28);
        }
        if (group.children != null) {
            for (TreePatternNode child : group.children) {
                if (child.naming instanceof TreePatternNode.NegativeNaming != negative) continue;
                TreePatternSerialization.serialize(writer, child, compact, group, enumerated, serializeEnumeration);
            }
        }
    }

    @Nullable
    private static TreePatternNode deserializeNode(@NotNull HierarchicalStreamReader reader, boolean negNaming, boolean root, @NotNull Map<String, SmartPredicate<TreePatternNode.PatternWrapper>> enumerated) {
        ObjectKind kind;
        if (reader == null) {
            TreePatternSerialization.$$$reportNull$$$0(29);
        }
        if (enumerated == null) {
            TreePatternSerialization.$$$reportNull$$$0(30);
        }
        if (!"node".equals(reader.getNodeName())) {
            TreePatternNode.Group group;
            if (root && (group = TreePatternSerialization.deserializeGroup(reader, enumerated)) != null) {
                return TreePatternSerialization.newRootNode(group);
            }
            return null;
        }
        String rootCode = root ? TreePatternSerialization.getKind(reader) : null;
        boolean neg = TreePatternSerialization.isNegativeNode(reader);
        if (neg != negNaming && rootCode == null) {
            TreePatternSerialization.hardWarning("Unexpected naming type");
            return null;
        }
        SmartList names = new SmartList();
        ContainerUtil.addIfNotNull((Collection)names, (Object)TreePatternSerialization.deserializeName(reader));
        SmartPredicate<TreePatternNode.PatternWrapper> pattern = TreePatternSerialization.deserializeCheck(reader, enumerated);
        TreePatternUtils.NodeBuilder builder = new TreePatternUtils.NodeBuilder();
        LinkedHashMap<String, TreePatternUtils.GroupBuilder> inlineGroups = new LinkedHashMap<String, TreePatternUtils.GroupBuilder>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String tag = reader.getNodeName();
            if ("name".equals(tag)) {
                ObjectName objectName = TreePatternSerialization.deserializeName(reader);
                if (objectName == null) {
                    return null;
                }
                names.add(objectName);
            } else if ("group".equals(tag)) {
                TreePatternNode.Group group = TreePatternSerialization.deserializeGroup(reader, enumerated);
                if (group == null) {
                    return null;
                }
                builder.groups.add(group);
            } else if ("node".equals(tag)) {
                String string = TreePatternSerialization.getKind(reader);
                TreePatternUtils.GroupBuilder group = inlineGroups.computeIfAbsent(string, __ -> new TreePatternUtils.GroupBuilder());
                if (!TreePatternSerialization.deserializeGroupNode(reader, group, enumerated)) {
                    return null;
                }
            } else if ("condition".equals(tag)) {
                TreePatternSerialization.deserializeEnumeratedCondition(reader, enumerated);
            } else if ("and".equals(tag)) {
                pattern = TreePatternSerialization.deserializeAnd(reader, enumerated);
            } else if ("or".equals(tag)) {
                pattern = TreePatternSerialization.deserializeOr(reader, enumerated);
            }
            reader.moveUp();
        }
        for (Map.Entry entry : inlineGroups.entrySet()) {
            kind = TreePatternSerialization.findKind((String)entry.getKey());
            if (kind == null) {
                return null;
            }
            builder.groups.add(((TreePatternUtils.GroupBuilder)entry.getValue()).build(kind));
        }
        TreePatternNode.BaseNaming naming = TreePatternSerialization.instantiateNaming(neg, (List<ObjectName>)names, pattern);
        TreePatternNode treePatternNode = builder.build(naming);
        if (rootCode != null) {
            kind = TreePatternSerialization.findKind(rootCode);
            if (kind == null) {
                return null;
            }
            TreePatternUtils.GroupBuilder gb = new TreePatternUtils.GroupBuilder();
            gb.children.add(treePatternNode);
            return TreePatternSerialization.newRootNode(gb.build(kind));
        }
        return treePatternNode;
    }

    @Nullable
    private static SmartPredicate<TreePatternNode.PatternWrapper> deserializeOr(@NotNull HierarchicalStreamReader reader, @NotNull Map<String, SmartPredicate<TreePatternNode.PatternWrapper>> enumerated) {
        if (reader == null) {
            TreePatternSerialization.$$$reportNull$$$0(31);
        }
        if (enumerated == null) {
            TreePatternSerialization.$$$reportNull$$$0(32);
        }
        SmartPredicate<TreePatternNode.PatternWrapper> pattern = TreePatternSerialization.deserializeCheck(reader, enumerated);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("check".equals(reader.getNodeName())) {
                pattern = TreePatternSerialization.mergeOr(pattern, TreePatternSerialization.deserializeCheck(reader, enumerated));
            } else if ("and".equals(reader.getNodeName())) {
                pattern = TreePatternSerialization.mergeOr(pattern, TreePatternSerialization.deserializeAnd(reader, enumerated));
            }
            reader.moveUp();
        }
        return pattern;
    }

    @Nullable
    private static SmartPredicate<TreePatternNode.PatternWrapper> deserializeAnd(@NotNull HierarchicalStreamReader reader, @NotNull Map<String, SmartPredicate<TreePatternNode.PatternWrapper>> enumerated) {
        if (reader == null) {
            TreePatternSerialization.$$$reportNull$$$0(33);
        }
        if (enumerated == null) {
            TreePatternSerialization.$$$reportNull$$$0(34);
        }
        SmartPredicate<TreePatternNode.PatternWrapper> pattern = TreePatternSerialization.deserializeCheck(reader, enumerated);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("check".equals(reader.getNodeName())) {
                pattern = TreePatternSerialization.mergeAnd(pattern, TreePatternSerialization.deserializeCheck(reader, enumerated));
            }
            reader.moveUp();
        }
        return pattern;
    }

    @Nullable
    private static SmartPredicate<TreePatternNode.PatternWrapper> mergeAnd(SmartPredicate<TreePatternNode.PatternWrapper> pattern, SmartPredicate<TreePatternNode.PatternWrapper> c2) {
        if (c2 == null) {
            return pattern;
        }
        if (pattern == null) {
            return c2;
        }
        return pattern.intersect(c2);
    }

    @Nullable
    private static SmartPredicate<TreePatternNode.PatternWrapper> mergeOr(SmartPredicate<TreePatternNode.PatternWrapper> pattern, SmartPredicate<TreePatternNode.PatternWrapper> c2) {
        if (c2 == null) {
            return pattern;
        }
        if (pattern == null) {
            return c2;
        }
        return pattern.union(c2);
    }

    private static void deserializeEnumeratedCondition(@NotNull HierarchicalStreamReader reader, @NotNull Map<String, SmartPredicate<TreePatternNode.PatternWrapper>> enumerated) {
        if (reader == null) {
            TreePatternSerialization.$$$reportNull$$$0(35);
        }
        if (enumerated == null) {
            TreePatternSerialization.$$$reportNull$$$0(36);
        }
        String id = reader.getAttribute("id");
        String value = reader.getAttribute("value");
        if (id != null && value != null) {
            enumerated.put(id, SmartPredicate.create(TreePatternNode.PatternWrapper.create(value)));
        }
    }

    @Nullable
    private static SmartPredicate<TreePatternNode.PatternWrapper> deserializeCheck(@NotNull HierarchicalStreamReader reader, @NotNull Map<String, SmartPredicate<TreePatternNode.PatternWrapper>> enumerated) {
        if (reader == null) {
            TreePatternSerialization.$$$reportNull$$$0(37);
        }
        if (enumerated == null) {
            TreePatternSerialization.$$$reportNull$$$0(38);
        }
        String check = reader.getAttribute("condition");
        SmartPredicate<TreePatternNode.PatternWrapper> res = null;
        if (check != null) {
            res = SmartPredicate.create(TreePatternNode.PatternWrapper.create(check));
        } else {
            String checkId = reader.getAttribute("condition-id");
            if (checkId != null) {
                res = enumerated.get(checkId);
            }
        }
        if (res == null) {
            return null;
        }
        if ("1".equals(reader.getAttribute("negate"))) {
            return res.negate();
        }
        return res;
    }

    private static void hardWarning(String s) {
        Application a = ApplicationManager.getApplication();
        if (a == null || a.isUnitTestMode()) {
            LOG.error(s);
        } else {
            LOG.warn(s);
        }
    }

    @NotNull
    private static TreePatternNode newRootNode(TreePatternNode.Group group) {
        return new TreePatternNode(TreePatternNode.NegativeNaming.WILDCARD, (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{group}));
    }

    private static String getKind(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            TreePatternSerialization.$$$reportNull$$$0(39);
        }
        return reader.getAttribute("kind");
    }

    private static void serialize(@NotNull HierarchicalStreamWriter writer, @NotNull TreePatternNode.Group group, @NotNull Map<TreePatternNode.PatternWrapper, Integer> enumerated) {
        if (writer == null) {
            TreePatternSerialization.$$$reportNull$$$0(40);
        }
        if (group == null) {
            TreePatternSerialization.$$$reportNull$$$0(41);
        }
        if (enumerated == null) {
            TreePatternSerialization.$$$reportNull$$$0(42);
        }
        writer.startNode("group");
        writer.addAttribute("kind", group.kind.code());
        TreePatternSerialization.serializeChildren(writer, group, true, false, enumerated, false);
        TreePatternSerialization.serializeChildren(writer, group, false, false, enumerated, false);
        writer.endNode();
    }

    @Nullable
    private static TreePatternNode.Group deserializeGroup(@NotNull HierarchicalStreamReader reader, @NotNull Map<String, SmartPredicate<TreePatternNode.PatternWrapper>> enumerated) {
        String code;
        if (reader == null) {
            TreePatternSerialization.$$$reportNull$$$0(43);
        }
        if (enumerated == null) {
            TreePatternSerialization.$$$reportNull$$$0(44);
        }
        if ((code = TreePatternSerialization.getKind(reader)) == null) {
            return null;
        }
        ObjectKind kind = TreePatternSerialization.findKind(code);
        if (kind == null) {
            return null;
        }
        TreePatternUtils.GroupBuilder builder = new TreePatternUtils.GroupBuilder();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("node".equals(reader.getNodeName()) && !TreePatternSerialization.deserializeGroupNode(reader, builder, enumerated)) {
                return null;
            }
            reader.moveUp();
        }
        return builder.build(kind);
    }

    @Nullable
    private static ObjectKind findKind(String code) {
        ObjectKind kind = ObjectKind.getKind(code);
        if (kind == null && "data-source".equals(code)) {
            kind = ObjectKind.ROOT;
        }
        if (kind == null) {
            TreePatternSerialization.hardWarning("Unable to find kind: " + code);
            return null;
        }
        return kind;
    }

    private static boolean deserializeGroupNode(@NotNull HierarchicalStreamReader reader, TreePatternUtils.GroupBuilder builder, @NotNull Map<String, SmartPredicate<TreePatternNode.PatternWrapper>> enumerated) {
        boolean neg;
        TreePatternNode node;
        if (reader == null) {
            TreePatternSerialization.$$$reportNull$$$0(45);
        }
        if (enumerated == null) {
            TreePatternSerialization.$$$reportNull$$$0(46);
        }
        if ((node = TreePatternSerialization.deserializeNode(reader, neg = TreePatternSerialization.isNegativeNode(reader), false, enumerated)) == null) {
            return false;
        }
        builder.children.add(node);
        return true;
    }

    private static boolean isNegativeNode(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            TreePatternSerialization.$$$reportNull$$$0(47);
        }
        return "1".equals(reader.getAttribute("negative"));
    }

    private static void serialize(@NotNull HierarchicalStreamWriter writer, @NotNull ObjectName name2) {
        if (writer == null) {
            TreePatternSerialization.$$$reportNull$$$0(48);
        }
        if (name2 == null) {
            TreePatternSerialization.$$$reportNull$$$0(49);
        }
        writer.startNode("name");
        TreePatternSerialization.serializeInner(writer, name2);
        writer.endNode();
    }

    private static void serializeInner(@NotNull HierarchicalStreamWriter writer, @NotNull ObjectName name2) {
        if (writer == null) {
            TreePatternSerialization.$$$reportNull$$$0(50);
        }
        if (name2 == null) {
            TreePatternSerialization.$$$reportNull$$$0(51);
        }
        writer.addAttribute(name2.quoted ? "qname" : "name", name2.name);
    }

    @Nullable
    private static ObjectName deserializeName(HierarchicalStreamReader reader) {
        boolean quoted = "1".equals(reader.getAttribute("quoted"));
        String name2 = reader.getAttribute("name");
        if (name2 == null) {
            name2 = reader.getAttribute("qname");
            quoted = true;
        }
        if (name2 == null) {
            return null;
        }
        return new ObjectName(name2, quoted);
    }

    @NotNull
    private static TreePatternNode.BaseNaming instantiateNaming(boolean neg, List<ObjectName> names, SmartPredicate<TreePatternNode.PatternWrapper> pattern) {
        return neg ? new TreePatternNode.NegativeNaming(pattern == null ? SmartPredicate.all() : pattern, ObjectName.toArray(names)) : new TreePatternNode.PositiveNaming(ObjectName.toArray(names));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/TreePatternSerialization";
                break;
            }
            case 5: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 43: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: 
            case 11: 
            case 14: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 42: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumerated";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "term";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "check";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/TreePatternSerialization";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "enumerateRequiredPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "enumerateRequiredPatterns";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "serializePattern";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "serializeChecks";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "serializeCheck";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "serializeEnumeration";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "serializeRootCompact";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "serializeCompact";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "serializeChildren";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "deserializeNode";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "deserializeOr";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "deserializeAnd";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "deserializeEnumeratedCondition";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "deserializeCheck";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getKind";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "deserializeGroup";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "deserializeGroupNode";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isNegativeNode";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "serializeInner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

