/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.mistralai;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.internal.ChatRequestValidationUtils;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.mistralai.MistralAiChatModelName;
import dev.langchain4j.model.mistralai.internal.api.MistralAiChatCompletionRequest;
import dev.langchain4j.model.mistralai.internal.api.MistralAiChatCompletionResponse;
import dev.langchain4j.model.mistralai.internal.api.MistralAiResponseFormatType;
import dev.langchain4j.model.mistralai.internal.api.MistralAiToolChoiceName;
import dev.langchain4j.model.mistralai.internal.client.MistralAiClient;
import dev.langchain4j.model.mistralai.internal.mapper.MistralAiMapper;
import dev.langchain4j.model.mistralai.spi.MistralAiChatModelBuilderFactory;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class MistralAiChatModel
implements ChatModel {
    private final MistralAiClient client;
    private final String modelName;
    private final Double temperature;
    private final Double topP;
    private final Integer maxTokens;
    private final Boolean safePrompt;
    private final Integer randomSeed;
    private final ResponseFormat responseFormat;
    private final Integer maxRetries;
    private final Set<Capability> supportedCapabilities;

    public MistralAiChatModel(String baseUrl, String apiKey, String modelName, Double temperature, Double topP, Integer maxTokens, Boolean safePrompt, Integer randomSeed, ResponseFormat responseFormat, Duration timeout2, Boolean logRequests, Boolean logResponses, Integer maxRetries, Set<Capability> supportedCapabilities) {
        this.client = ((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)MistralAiClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://api.mistral.ai/v1"))).apiKey(apiKey)).timeout((Duration)Utils.getOrDefault((Object)timeout2, (Object)Duration.ofSeconds(60L)))).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false))).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false))).build();
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.temperature = temperature;
        this.topP = topP;
        this.maxTokens = maxTokens;
        this.safePrompt = safePrompt;
        this.randomSeed = randomSeed;
        this.responseFormat = responseFormat;
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)2);
        this.supportedCapabilities = (Set)Utils.getOrDefault(supportedCapabilities, Set.of());
    }

    public Set<Capability> supportedCapabilities() {
        return this.supportedCapabilities;
    }

    public ChatResponse chat(ChatRequest chatRequest) {
        Response<AiMessage> response;
        ChatRequestValidationUtils.validateMessages((List)chatRequest.messages());
        ChatRequestParameters parameters = chatRequest.parameters();
        ChatRequestValidationUtils.validateParameters((ChatRequestParameters)parameters);
        ResponseFormat responseFormat = parameters.responseFormat();
        List toolSpecifications = parameters.toolSpecifications();
        if (Utils.isNullOrEmpty((Collection)toolSpecifications)) {
            response = this.generate(chatRequest.messages(), responseFormat);
        } else if (parameters.toolChoice() == ToolChoice.REQUIRED) {
            if (toolSpecifications.size() != 1) {
                throw new UnsupportedFeatureException(String.format("%s.%s is currently supported only when there is a single tool", ToolChoice.class.getSimpleName(), ToolChoice.REQUIRED.name()));
            }
            response = this.generate((List<ChatMessage>)chatRequest.messages(), (ToolSpecification)toolSpecifications.get(0), responseFormat);
        } else {
            response = this.generate((List<ChatMessage>)chatRequest.messages(), toolSpecifications, responseFormat);
        }
        return ChatResponse.builder().aiMessage((AiMessage)response.content()).metadata(ChatResponseMetadata.builder().tokenUsage(response.tokenUsage()).finishReason(response.finishReason()).build()).build();
    }

    private Response<AiMessage> generate(List<ChatMessage> messages, ResponseFormat responseFormat) {
        return this.generate(messages, null, null, responseFormat);
    }

    private Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, ResponseFormat responseFormat) {
        return this.generate(messages, toolSpecifications, null, responseFormat);
    }

    private Response<AiMessage> generate(List<ChatMessage> messages, ToolSpecification toolSpecification, ResponseFormat responseFormat) {
        return this.generate(messages, Collections.singletonList(toolSpecification), toolSpecification, responseFormat);
    }

    private Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, ToolSpecification toolThatMustBeExecuted, ResponseFormat responseFormat) {
        ValidationUtils.ensureNotEmpty(messages, (String)"messages");
        MistralAiChatCompletionRequest.MistralAiChatCompletionRequestBuilder requestBuilder = MistralAiChatCompletionRequest.builder().model(this.modelName).messages(MistralAiMapper.toMistralAiMessages(messages)).temperature(this.temperature).maxTokens(this.maxTokens).topP(this.topP).randomSeed(this.randomSeed).safePrompt(this.safePrompt).responseFormat(MistralAiMapper.toMistralAiResponseFormat(responseFormat, this.responseFormat)).stream(false);
        if (!Utils.isNullOrEmpty(toolSpecifications)) {
            requestBuilder.tools(MistralAiMapper.toMistralAiTools(toolSpecifications));
            requestBuilder.toolChoice(MistralAiToolChoiceName.AUTO);
        } else if (toolThatMustBeExecuted != null) {
            requestBuilder.tools(MistralAiMapper.toMistralAiTools(Collections.singletonList(toolThatMustBeExecuted)));
            requestBuilder.toolChoice(MistralAiToolChoiceName.ANY);
        }
        MistralAiChatCompletionRequest request = requestBuilder.build();
        MistralAiChatCompletionResponse response = (MistralAiChatCompletionResponse)RetryUtils.withRetryMappingExceptions(() -> this.client.chatCompletion(request), (int)this.maxRetries);
        return Response.from((Object)MistralAiMapper.aiMessageFrom(response), (TokenUsage)MistralAiMapper.tokenUsageFrom(response.getUsage()), (FinishReason)MistralAiMapper.finishReasonFrom(response.getChoices().get(0).getFinishReason()));
    }

    public ModelProvider provider() {
        return ModelProvider.MISTRAL_AI;
    }

    public static MistralAiChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(MistralAiChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            MistralAiChatModelBuilderFactory factory2 = (MistralAiChatModelBuilderFactory)iterator.next();
            return (MistralAiChatModelBuilder)factory2.get();
        }
        return new MistralAiChatModelBuilder();
    }

    public static class MistralAiChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String modelName;
        private Double temperature;
        private Double topP;
        private Integer maxTokens;
        private Boolean safePrompt;
        private Integer randomSeed;
        private ResponseFormat responseFormat;
        private Duration timeout;
        private Boolean logRequests;
        private Boolean logResponses;
        private Integer maxRetries;
        private Set<Capability> supportedCapabilities;

        public MistralAiChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public MistralAiChatModelBuilder modelName(MistralAiChatModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        @Deprecated(forRemoval=true)
        public MistralAiChatModelBuilder responseFormat(String responseFormat) {
            this.responseFormat = MistralAiResponseFormatType.valueOf(responseFormat.toUpperCase()).toGenericResponseFormat();
            return this;
        }

        @Deprecated(forRemoval=true)
        public MistralAiChatModelBuilder responseFormat(MistralAiResponseFormatType responseFormat) {
            this.responseFormat = responseFormat.toGenericResponseFormat();
            return this;
        }

        public MistralAiChatModelBuilder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public MistralAiChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public MistralAiChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public MistralAiChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public MistralAiChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public MistralAiChatModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public MistralAiChatModelBuilder safePrompt(Boolean safePrompt) {
            this.safePrompt = safePrompt;
            return this;
        }

        public MistralAiChatModelBuilder randomSeed(Integer randomSeed) {
            this.randomSeed = randomSeed;
            return this;
        }

        public MistralAiChatModelBuilder timeout(Duration timeout2) {
            this.timeout = timeout2;
            return this;
        }

        public MistralAiChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public MistralAiChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public MistralAiChatModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public MistralAiChatModelBuilder supportedCapabilities(Capability ... supportedCapabilities) {
            this.supportedCapabilities = Arrays.stream(supportedCapabilities).collect(Collectors.toSet());
            return this;
        }

        public MistralAiChatModelBuilder supportedCapabilities(Set<Capability> supportedCapabilities) {
            this.supportedCapabilities = Set.copyOf(supportedCapabilities);
            return this;
        }

        public MistralAiChatModel build() {
            return new MistralAiChatModel(this.baseUrl, this.apiKey, this.modelName, this.temperature, this.topP, this.maxTokens, this.safePrompt, this.randomSeed, this.responseFormat, this.timeout, this.logRequests, this.logResponses, this.maxRetries, this.supportedCapabilities);
        }

        public String toString() {
            return "MistralAiChatModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey == null ? "" : "*****, modelName=" + this.modelName + ", temperature=" + this.temperature + ", topP=" + this.topP + ", maxTokens=" + this.maxTokens + ", safePrompt=" + this.safePrompt + ", randomSeed=" + this.randomSeed + ", responseFormat=" + String.valueOf(this.responseFormat) + ", timeout=" + String.valueOf(this.timeout) + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ", maxRetries=" + this.maxRetries + ", supportedCapabilities=" + String.valueOf(this.supportedCapabilities) + ")";
        }
    }
}

