/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.performanceTesting;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.PlaybackCommandCoroutineAdapter;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.jetbrains.python.Result;
import com.jetbrains.python.ResultKt;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.configuration.PyProjectSdkConfiguration;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001c\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0094@\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/intellij/python/performanceTesting/ConfigureVirtualEnvSdk;", "Lcom/intellij/openapi/ui/playback/commands/PlaybackCommandCoroutineAdapter;", "text", "", "Lorg/jetbrains/annotations/NonNls;", "line", "", "<init>", "(Ljava/lang/String;I)V", "doExecute", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "(Lcom/intellij/openapi/ui/playback/PlaybackContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.python.performanceTesting"})
public final class ConfigureVirtualEnvSdk
extends PlaybackCommandCoroutineAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%configureVirtualEnvSdk";
    @NotNull
    private static final Logger LOG;

    public ConfigureVirtualEnvSdk(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @Nullable
    protected Object doExecute(@NotNull PlaybackContext context, @NotNull Continuation<? super Unit> $completion) {
        Result result;
        Sdk sdk;
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Module module = (Module)ArraysKt.first((Object[])ProjectUtil.getModules((Project)project));
        PyDetectedSdk pyDetectedSdk = (PyDetectedSdk)CollectionsKt.firstOrNull((List)PySdkExtKt.detectAssociatedEnvironments((Module)module, (List)CollectionsKt.emptyList(), (UserDataHolder)((UserDataHolder)new UserDataHolderBase())));
        Sdk sdk2 = sdk = pyDetectedSdk != null && (result = PySdkExtKt.setupAssociated((PyDetectedSdk)pyDetectedSdk, (List)CollectionsKt.emptyList(), (String)BasePySdkExtKt.getBasePath((Module)module), (boolean)true)) != null ? (Sdk)ResultKt.orLogException((Result)result, (Logger)LOG) : null;
        if (sdk == null) {
            LOG.error("Cannot configure sdk for module " + module.getName());
            return Unit.INSTANCE;
        }
        ActionsKt.runInEdt$default(null, () -> ConfigureVirtualEnvSdk.doExecute$lambda$0(sdk, module), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit doExecute$lambda$0(Sdk $sdk, Module $module) {
        SdkConfigurationUtil.addSdk((Sdk)$sdk);
        Project project = $module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PyProjectSdkConfiguration.INSTANCE.setReadyToUseSdk(project, $module, $sdk);
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(ConfigureVirtualEnvSdk.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/python/performanceTesting/ConfigureVirtualEnvSdk$Companion;", "", "<init>", "()V", "PREFIX", "", "Lorg/jetbrains/annotations/NonNls;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.python.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

