/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptExpressionParser;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptFunctionParser;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptPsiTypeParser;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptStatementParser;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptXmlTokensParser;
import com.intellij.lang.javascript.parsing.JSXmlParser;
import com.intellij.psi.tree.IElementType;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0012\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016R\u001b\u0010\t\u001a\u00020\n8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00108VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0014\u001a\u00020\u00158VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000e\u001a\u0004\b\u0016\u0010\u0017R\u001f\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u000e\u001a\u0004\b\u001b\u0010\u001cR\u001b\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u000e\u001a\u0004\b \u0010!\u00a8\u0006'"}, d2={"Lcom/intellij/lang/javascript/ecmascript6/parsing/TypeScriptParser;", "Lcom/intellij/lang/ecmascript6/parsing/ES6Parser;", "dialect", "Lcom/intellij/lang/javascript/JSLanguageDialect;", "builder", "Lcom/intellij/lang/PsiBuilder;", "<init>", "(Lcom/intellij/lang/javascript/JSLanguageDialect;Lcom/intellij/lang/PsiBuilder;)V", "(Lcom/intellij/lang/PsiBuilder;)V", "expressionParser", "Lcom/intellij/lang/javascript/ecmascript6/parsing/TypeScriptExpressionParser;", "getExpressionParser", "()Lcom/intellij/lang/javascript/ecmascript6/parsing/TypeScriptExpressionParser;", "expressionParser$delegate", "Lkotlin/Lazy;", "statementParser", "Lcom/intellij/lang/javascript/ecmascript6/parsing/TypeScriptStatementParser;", "getStatementParser", "()Lcom/intellij/lang/javascript/ecmascript6/parsing/TypeScriptStatementParser;", "statementParser$delegate", "functionParser", "Lcom/intellij/lang/javascript/ecmascript6/parsing/TypeScriptFunctionParser;", "getFunctionParser", "()Lcom/intellij/lang/javascript/ecmascript6/parsing/TypeScriptFunctionParser;", "functionParser$delegate", "typeParser", "Lcom/intellij/lang/javascript/ecmascript6/parsing/TypeScriptPsiTypeParser;", "getTypeParser", "()Lcom/intellij/lang/javascript/ecmascript6/parsing/TypeScriptPsiTypeParser;", "typeParser$delegate", "xmlParser", "Lcom/intellij/lang/javascript/parsing/JSXmlParser;", "getXmlParser", "()Lcom/intellij/lang/javascript/parsing/JSXmlParser;", "xmlParser$delegate", "isIdentifierToken", "", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "intellij.javascript.parser"})
public class TypeScriptParser
extends ES6Parser {
    @NotNull
    private final Lazy expressionParser$delegate;
    @NotNull
    private final Lazy statementParser$delegate;
    @NotNull
    private final Lazy functionParser$delegate;
    @NotNull
    private final Lazy typeParser$delegate;
    @NotNull
    private final Lazy xmlParser$delegate;

    public TypeScriptParser(@NotNull JSLanguageDialect dialect, @NotNull PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super(dialect, builder);
        this.expressionParser$delegate = LazyKt.lazy(() -> TypeScriptParser.expressionParser_delegate$lambda$0(this));
        this.statementParser$delegate = LazyKt.lazy(() -> TypeScriptParser.statementParser_delegate$lambda$1(this));
        this.functionParser$delegate = LazyKt.lazy(() -> TypeScriptParser.functionParser_delegate$lambda$2(this));
        this.typeParser$delegate = LazyKt.lazy(() -> TypeScriptParser.typeParser_delegate$lambda$3(this));
        this.xmlParser$delegate = LazyKt.lazy(() -> TypeScriptParser.xmlParser_delegate$lambda$4(this));
    }

    public TypeScriptParser(@NotNull PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this(JavaScriptSupportLoader.TYPESCRIPT, builder);
    }

    @Override
    @NotNull
    public TypeScriptExpressionParser getExpressionParser() {
        Lazy lazy = this.expressionParser$delegate;
        return (TypeScriptExpressionParser)lazy.getValue();
    }

    @Override
    @NotNull
    public TypeScriptStatementParser getStatementParser() {
        Lazy lazy = this.statementParser$delegate;
        return (TypeScriptStatementParser)lazy.getValue();
    }

    @Override
    @NotNull
    public TypeScriptFunctionParser getFunctionParser() {
        Lazy lazy = this.functionParser$delegate;
        return (TypeScriptFunctionParser)lazy.getValue();
    }

    @NotNull
    public TypeScriptPsiTypeParser<?> getTypeParser() {
        Lazy lazy = this.typeParser$delegate;
        return (TypeScriptPsiTypeParser)lazy.getValue();
    }

    @Override
    @NotNull
    public JSXmlParser getXmlParser() {
        Lazy lazy = this.xmlParser$delegate;
        return (JSXmlParser)lazy.getValue();
    }

    @Override
    public boolean isIdentifierToken(@Nullable IElementType tokenType) {
        return JSKeywordSets.TS_IDENTIFIERS_TOKENS_SET.contains(tokenType);
    }

    private static final TypeScriptExpressionParser expressionParser_delegate$lambda$0(TypeScriptParser this$0) {
        return new TypeScriptExpressionParser(this$0);
    }

    private static final TypeScriptStatementParser statementParser_delegate$lambda$1(TypeScriptParser this$0) {
        return new TypeScriptStatementParser(this$0);
    }

    private static final TypeScriptFunctionParser functionParser_delegate$lambda$2(TypeScriptParser this$0) {
        return new TypeScriptFunctionParser(this$0);
    }

    private static final TypeScriptPsiTypeParser typeParser_delegate$lambda$3(TypeScriptParser this$0) {
        return new TypeScriptPsiTypeParser<ES6Parser>(this$0);
    }

    private static final TypeScriptXmlTokensParser xmlParser_delegate$lambda$4(TypeScriptParser this$0) {
        return new TypeScriptXmlTokensParser(this$0);
    }
}

