/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.resolve.JSComplexityAwareRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.registry.Registry;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class JSEvaluatorComplexityTracker {
    private static final ThreadLocal<JSEvaluatorComplexityTracker> ourComplexityTracker = ThreadLocal.withInitial(() -> new JSEvaluatorComplexityTracker());
    private final int myAllowedDepth;
    private int myCurrentDepth = 0;
    private int myMaxBranchDepth = 0;
    private Object myKeyForCachingPrevention = null;
    private final RecursionGuard<Object> myRecursionGuard = RecursionManager.createGuard((String)"js.evaluator.depth.tracker");
    private static boolean ourAssertOnPrevention = false;

    public JSEvaluatorComplexityTracker() {
        this.myAllowedDepth = Registry.intValue((String)"js.max.evaluation.depth");
    }

    @Nullable
    public <T> JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<T> runTask(int ownDepth, @NotNull Supplier<? extends @Nullable T> task) {
        if (task == null) {
            JSEvaluatorComplexityTracker.$$$reportNull$$$0(0);
        }
        if (this.myCurrentDepth + ownDepth > this.myAllowedDepth) {
            if (this.myKeyForCachingPrevention != null) {
                this.myRecursionGuard.prohibitResultCaching(this.myKeyForCachingPrevention);
            }
            JSEvaluationLogger.getInstance().cachingProhibited();
            return null;
        }
        Object key = new Object();
        boolean keyForCachingPreventionWasSet = false;
        if (this.myKeyForCachingPrevention == null && this.myCurrentDepth + ownDepth > 0) {
            this.myKeyForCachingPrevention = key;
            keyForCachingPreventionWasSet = true;
        }
        int depthBefore = this.myCurrentDepth;
        int maxBranchDepthBefore = this.myMaxBranchDepth;
        Object value = null;
        Throwable throwable = null;
        try {
            JSEvaluationLogger.getInstance().startComplexityTrackerTask(task, depthBefore, maxBranchDepthBefore);
            this.myCurrentDepth += ownDepth;
            this.myMaxBranchDepth = this.myCurrentDepth;
            value = keyForCachingPreventionWasSet ? this.myRecursionGuard.doPreventingRecursion(key, true, task::get) : task.get();
            JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<Object> jSComplexityAwareCachedValue = new JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<Object>(this.myMaxBranchDepth - depthBefore, value);
            return jSComplexityAwareCachedValue;
        }
        catch (Throwable t) {
            throwable = t;
            throw t;
        }
        finally {
            JSEvaluationLogger.getInstance().finishComplexityTrackerTask(task, value, this.myMaxBranchDepth, throwable);
            this.myCurrentDepth = depthBefore;
            this.myMaxBranchDepth = Math.max(this.myMaxBranchDepth, maxBranchDepthBefore);
            if (keyForCachingPreventionWasSet) {
                this.myKeyForCachingPrevention = null;
            }
        }
    }

    public int getAvailableDepth() {
        return this.myAllowedDepth - this.myCurrentDepth;
    }

    public void useDepth(int depth) {
        if (depth < 0 || this.myCurrentDepth + depth > this.myAllowedDepth) {
            throw new IllegalArgumentException("depth: " + depth);
        }
        this.myMaxBranchDepth = Math.max(this.myMaxBranchDepth, this.myCurrentDepth + depth);
    }

    @TestOnly
    public static void assertOnRecursionPrevention(@NotNull Disposable disposable) {
        if (disposable == null) {
            JSEvaluatorComplexityTracker.$$$reportNull$$$0(1);
        }
        ourAssertOnPrevention = true;
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                ourAssertOnPrevention = false;
            }
        });
    }

    @TestOnly
    public static boolean isAssertOnPrevention() {
        return ourAssertOnPrevention;
    }

    @NotNull
    public static JSEvaluatorComplexityTracker getDefaultInstance() {
        JSEvaluatorComplexityTracker jSEvaluatorComplexityTracker = ourComplexityTracker.get();
        if (jSEvaluatorComplexityTracker == null) {
            JSEvaluatorComplexityTracker.$$$reportNull$$$0(2);
        }
        return jSEvaluatorComplexityTracker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSEvaluatorComplexityTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluatorComplexityTracker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runTask";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "assertOnRecursionPrevention";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

