/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptLiteralKeyUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.types.OverloadStrictness;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitMemberForComputedPropertyImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitOverloadedAliasElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveStatus;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSSinkResolveStatus;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.TypeScriptImplicitMemberForComputedProperty;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.validation.UnusedImportsUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolveResultSink
extends ResultSink {
    private static final Logger LOG = Logger.getInstance(ResolveResultSink.class);
    private final String myName;
    private List<JSSinkResolveStatus> myResolveStatus;
    private final boolean myAcceptAllResults;
    private final boolean myIncomplete;
    @Nullable
    private Set<PsiElement> myCandidateResults;

    public ResolveResultSink(@Nullable PsiElement place, @NotNull String name) {
        if (name == null) {
            ResolveResultSink.$$$reportNull$$$0(0);
        }
        this(place, name, false);
    }

    public ResolveResultSink(@Nullable PsiElement place, @NotNull String name, boolean acceptAllResults) {
        if (name == null) {
            ResolveResultSink.$$$reportNull$$$0(1);
        }
        this(place, name, acceptAllResults, false);
    }

    public ResolveResultSink(@Nullable PsiElement place, @NotNull String name, boolean acceptAllResults, boolean incomplete) {
        if (name == null) {
            ResolveResultSink.$$$reportNull$$$0(2);
        }
        super(place);
        this.myName = name;
        this.myAcceptAllResults = acceptAllResults;
        this.myIncomplete = incomplete;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public PsiElement getResult() {
        PsiElement completeResult = this.getCompleteResult();
        if (completeResult != null) {
            return completeResult;
        }
        return (PsiElement)ContainerUtil.getFirstItem((List)this.myResults);
    }

    @Nullable
    public PsiElement getCompleteResult() {
        if (this.myResults == null) {
            return null;
        }
        LOG.assertTrue(this.myResults.size() == this.myResolveStatus.size(), (Object)(this.myResults.size() + " != " + this.myResolveStatus.size()));
        for (int i = 0; i < this.myResults.size(); ++i) {
            if (!this.myResolveStatus.get((int)i).myIsComplete) continue;
            return (PsiElement)this.myResults.get(i);
        }
        return null;
    }

    @Nullable
    public JSResolveResult getCandidateResult() {
        if (this.myResults == null) {
            return null;
        }
        LOG.assertTrue(this.myResults.size() == this.myResolveStatus.size(), (Object)(this.myResults.size() + " != " + this.myResolveStatus.size()));
        for (int i = 0; i < this.myResults.size(); ++i) {
            if (this.myResolveStatus.get((int)i).myIsComplete) continue;
            return new JSResolveResult((PsiElement)this.myResults.get(i), null, this.myResolveStatus.get(i).getResolveProblem());
        }
        return null;
    }

    @Override
    public List<PsiElement> getResults() {
        if (this.myResults == null) {
            return null;
        }
        LOG.assertTrue(this.myResults.size() == this.myResolveStatus.size(), (Object)(this.myResults.size() + " != " + this.myResolveStatus.size()));
        boolean hasCandidateResult = false;
        boolean hasCompleteResult = false;
        for (int i = 0; i < this.myResults.size(); ++i) {
            if (this.myResolveStatus.get((int)i).myIsComplete) {
                hasCompleteResult = true;
                continue;
            }
            hasCandidateResult = true;
        }
        List results = this.myResults;
        if (hasCompleteResult && hasCandidateResult) {
            results = new SmartList();
            for (int i = 0; i < this.myResults.size(); ++i) {
                if (!this.myResolveStatus.get((int)i).myIsComplete) continue;
                results.add((PsiElement)this.myResults.get(i));
            }
        }
        return results;
    }

    @Override
    public boolean accepts(PsiElement element2) {
        String name;
        if (!(!(element2 instanceof PsiNamedElement) || this.myName.equals(name = ResolveProcessor.getName(element2)) || name == null && ResolveResultSink.isAcceptableForComputedPropertyName(element2))) {
            return false;
        }
        if (element2 instanceof ES6ImportExportSpecifier && !this.myName.equals(((ES6ImportExportSpecifier)element2).getReferenceName())) {
            return false;
        }
        if (element2 instanceof ES6ExportDefaultAssignment && !this.myName.equals("default")) {
            return false;
        }
        return super.accepts(element2);
    }

    @Contract(value="null -> false")
    public static boolean isAcceptableForComputedPropertyName(@Nullable PsiElement element2) {
        if (!(element2 instanceof JSComputedPropertyNameOwner)) {
            return false;
        }
        ES6ComputedName computedPropertyName = ((JSComputedPropertyNameOwner)element2).getComputedPropertyName();
        return computedPropertyName != null && computedPropertyName.getExpressionAsPropertyName() == null;
    }

    private ThreeState isAccurateComputedNameMatch(@Nullable PsiElement element2) {
        if (!(element2 instanceof JSComputedPropertyNameOwner)) {
            return ThreeState.UNSURE;
        }
        ES6ComputedName computedPropertyName = ((JSComputedPropertyNameOwner)element2).getComputedPropertyName();
        if (computedPropertyName == null) {
            return ThreeState.UNSURE;
        }
        JSType type2 = TypeScriptLiteralKeyUtil.getTypeForComputedPropExpression(computedPropertyName);
        if (type2 instanceof JSStringLiteralTypeImpl) {
            String literal = ((JSStringLiteralTypeImpl)type2).getLiteral();
            if (this.myName.equals(literal)) {
                return ThreeState.YES;
            }
            return ThreeState.NO;
        }
        if (type2 instanceof JSNumberLiteralTypeImpl) {
            String string = ((JSNumberLiteralTypeImpl)type2).getValueAsString();
            if (this.myName.equals(string)) {
                return ThreeState.YES;
            }
            return ThreeState.NO;
        }
        return ThreeState.UNSURE;
    }

    @Override
    public boolean addResult(@Nullable PsiElement element2, @Nullable ResolveState state, @Nullable PsiElement placeTopParent) {
        JSFunction funcOfWhichElementIsParam;
        ReadWriteAccessDetector.Access expressionAccess;
        JSFunction fun;
        if (this.myAcceptAllResults) {
            this.doAddResult(element2, state, placeTopParent);
            return true;
        }
        List<PsiElement> results = super.getResults();
        int previousResultsSize = results != null ? results.size() : 0;
        boolean stopProcessing = true;
        PsiElement elementForPropertyProcessing = element2;
        if (element2 instanceof JSProperty) {
            elementForPropertyProcessing = ((JSProperty)element2).tryGetFunctionInitializer();
        }
        if (this.place != null && elementForPropertyProcessing instanceof JSFunction && ((fun = (JSFunction)elementForPropertyProcessing).isGetProperty() || fun.isSetProperty()) && (expressionAccess = JSReadWriteAccessDetector.ourInstance.getExpressionAccess(this.place)) == ReadWriteAccessDetector.Access.ReadWrite) {
            PsiElement psiElement;
            if (previousResultsSize == 0) {
                stopProcessing = false;
            }
            if (previousResultsSize == 1 && (psiElement = results.get(0)) instanceof JSFunction) {
                JSFunction prevFun = (JSFunction)psiElement;
                if (prevFun.isGetProperty() && fun.isGetProperty()) {
                    return true;
                }
                if (prevFun.isSetProperty() && fun.isSetProperty()) {
                    return true;
                }
            }
            if (previousResultsSize == 2) {
                return true;
            }
        }
        if (ResolveResultSink.isAcceptableForComputedPropertyName(element2)) {
            ThreeState match = this.isAccurateComputedNameMatch(element2);
            if (match == ThreeState.UNSURE) {
                if (DialectDetector.isTypeScript(element2)) {
                    this.doAddResult((PsiElement)new TypeScriptImplicitMemberForComputedPropertyImpl(this.myName, null, element2, true), state, placeTopParent);
                    return true;
                }
                stopProcessing = false;
            } else {
                if (match == ThreeState.NO) {
                    return true;
                }
                if (this.myResults != null) {
                    List toRemove = ContainerUtil.filter((Collection)this.myResults, r -> ResolveResultSink.isAcceptableForComputedPropertyName(r));
                    for (PsiElement item : toRemove) {
                        int index = this.myResults.indexOf(item);
                        this.myResults.remove(index);
                        this.myResolveStatus.remove(index);
                    }
                }
            }
        }
        if ((funcOfWhichElementIsParam = ResolveResultSink.getFunctionIfElementIsParam(element2)) != null) {
            PsiElement decoratorOverPlace;
            PsiElement psiElement = decoratorOverPlace = this.place != null ? PsiTreeUtil.getParentOfType((PsiElement)this.place, ES6Decorator.class, (boolean)true, (Class[])new Class[]{JSFunction.class}) : null;
            if (decoratorOverPlace != null) {
                JSFunction funcOfDecoratorOverPlace;
                JSFunction jSFunction = funcOfDecoratorOverPlace = decoratorOverPlace.getParent() instanceof JSAttributeList && decoratorOverPlace.getParent().getParent() instanceof JSFunction ? (JSFunction)decoratorOverPlace.getParent().getParent() : null;
                if (funcOfDecoratorOverPlace == funcOfWhichElementIsParam) {
                    return true;
                }
            }
        }
        if (element2 instanceof TypeScriptIndexSignature) {
            stopProcessing = false;
        }
        this.doAddResult(element2, state, placeTopParent);
        return !stopProcessing;
    }

    @Nullable
    private static JSFunction getFunctionIfElementIsParam(@Nullable PsiElement parameterCandidate) {
        PsiElement parent;
        if (parameterCandidate instanceof JSParameter && (parent = JSDestructuringUtil.getParentSkippingDestructuring((JSElement)parameterCandidate)) instanceof JSParameterList && parent.getParent() instanceof JSFunction) {
            return (JSFunction)parent.getParent();
        }
        return null;
    }

    private void doAddResult(@Nullable PsiElement element2, @Nullable ResolveState state, @Nullable PsiElement placeTopParent) {
        super.addResult(element2, state, placeTopParent);
        if (this.myResolveStatus == null) {
            this.myResolveStatus = new SmartList();
        }
        this.myResolveStatus.add(this.getResolveStatus(element2, state, placeTopParent));
    }

    @NotNull
    private JSSinkResolveStatus getResolveStatus(@Nullable PsiElement element2, @Nullable ResolveState state, PsiElement placeTopParent) {
        JSElement importElement;
        JSElement jSElement = importElement = state != null ? (JSElement)state.get(JSResolveResult.IMPORT_KEY) : null;
        if (this.isActionScript()) {
            return this.checkActionScriptQualifiedNameHasNecessaryImport(element2, importElement, placeTopParent);
        }
        return new JSSinkResolveStatus(importElement, true, null, state == null ? null : (JSTypeSubstitutor)state.get(JSResolveResult.GENERICS));
    }

    @NotNull
    private JSSinkResolveStatus checkActionScriptQualifiedNameHasNecessaryImport(PsiElement element2, @Nullable JSElement importElement, @Nullable PsiElement placeTopParent) {
        JSResolveResult.ProblemKind resolveProblem = null;
        if (importElement == null && this.isActionScript() && (element2 instanceof JSClass || element2 instanceof JSFunction || element2 instanceof JSVariable || element2 instanceof JSNamespaceDeclaration) && placeTopParent instanceof JSReferenceExpression && !(placeTopParent.getParent() instanceof JSImportStatement)) {
            String qName;
            if (placeTopParent.getParent() instanceof JSNewExpression && element2 instanceof JSFunction && ((JSFunction)element2).isConstructor()) {
                element2 = element2.getParent();
            }
            String string = qName = element2 instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)element2).getQualifiedName() : null;
            if (qName != null && qName.indexOf(46) != -1 && !JSResolveUtil.getPackageName(element2).equals(JSResolveUtil.getPackageNameFromPlace(this.place)) && !UnusedImportsUtil.isSomeNodeThatShouldNotHaveImportsWhenQualified((JSReferenceExpression)placeTopParent, element2)) {
                boolean noImportNoResolve;
                SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(this.myName, new ResolveResultSink(null, this.myName)){

                    @Override
                    public boolean execute(@NotNull PsiElement element2, @NotNull ResolveState state) {
                        if (element2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (state == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (element2 instanceof JSQualifiedNamedElement) {
                            if (!qName.equals(((JSQualifiedNamedElement)element2).getQualifiedName())) {
                                return true;
                            }
                        } else {
                            return true;
                        }
                        return super.execute(element2, state);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "element";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "state";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/lang/javascript/psi/resolve/ResolveResultSink$1";
                        objectArray[2] = "execute";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                processor.putUserData(ResolveProcessor.ASKING_FOR_QUALIFIED_IMPORT, qName);
                PsiNamedElement importOwner = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)placeTopParent, (Class[])new Class[]{JSFunction.class, JSFile.class, JSPackageStatement.class, JSClass.class});
                if (importOwner != null) {
                    PsiElement elt = PsiTreeUtil.getChildOfAnyType((PsiElement)importOwner, (Class[])new Class[]{PsiWhiteSpace.class});
                    if (elt == null) {
                        elt = importOwner.getFirstChild();
                    }
                    JSResolveUtil.treeWalkUp(processor, (PsiElement)importOwner, elt, this.place);
                }
                boolean bl = noImportNoResolve = processor.getResult() == null;
                if (noImportNoResolve) {
                    resolveProblem = JSResolveResult.ProblemKind.QUALIFIED_NAME_IS_NOT_IMPORTED;
                } else {
                    ResolveResult[] resultsAsResolveResults = ((ResolveResultSink)processor.getResultSink()).getResultsAsResolveResults();
                    if (resultsAsResolveResults.length != 0) {
                        importElement = ((JSResolveResult)resultsAsResolveResults[0]).getActionScriptImport();
                    }
                }
            }
        }
        return new JSSinkResolveStatus(importElement, true, resolveProblem, null);
    }

    public ResolveResult @NotNull [] getResultsAsResolveResults() {
        if (this.myResults == null || this.myResults.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ResolveResultSink.$$$reportNull$$$0(3);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        List<JSResolveResultForSymbolProcessor> results = this.getFilteredResults();
        ResolveResult[] array = new ResolveResult[results.size()];
        for (int i = 0; i < results.size(); ++i) {
            array[i] = results.get(i).getResolveResult();
        }
        if (array == null) {
            ResolveResultSink.$$$reportNull$$$0(4);
        }
        return array;
    }

    public static ResolveResult @Nullable [] resolveImportExportSpecifiers(@Nullable PsiElement element2) {
        ResolveResult[] newResults;
        if (element2 instanceof ES6ImportExportSpecifier) {
            ResolveResult[] results = ((ES6ImportExportSpecifier)element2).multiResolve(false);
            return results.length == 0 ? null : results;
        }
        if (element2 instanceof ES6ImportExportSpecifierAlias) {
            ResolveResult[] newResults2 = ResolveResultSink.getResultsForSpecifierAlias((ES6ImportExportSpecifierAlias)element2);
            if (newResults2 != null) {
                return newResults2;
            }
        } else if (element2 instanceof ES6ImportedBinding && (newResults = ResolveResultSink.getResultsForImportedBinding((ES6ImportedBinding)element2)) != null) {
            return newResults;
        }
        return null;
    }

    private static ResolveResult @Nullable [] getResultsForImportedBinding(@NotNull ES6ImportedBinding element2) {
        Collection<PsiElement> referencedElements;
        int size;
        if (element2 == null) {
            ResolveResultSink.$$$reportNull$$$0(5);
        }
        if ((size = (referencedElements = element2.findReferencedElements()).size()) == 0) {
            return null;
        }
        if (size == 1) {
            List<PsiElement> elements;
            String initializerReference;
            PsiElement psiElement = referencedElements.iterator().next();
            if (psiElement instanceof JSExportAssignment && (initializerReference = ((JSExportAssignment)psiElement).getInitializerReference()) != null && !(elements = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(initializerReference, psiElement)).isEmpty()) {
                return ResolveResultSink.convertBindingElements(element2, elements);
            }
        } else {
            List mappedElements = (List)StreamEx.of(referencedElements).map(el -> el instanceof ES6ExportDefaultAssignment ? ((ES6ExportDefaultAssignment)el).getStubSafeElement() : null).nonNull().collect(Collectors.toList());
            return mappedElements.size() == size ? ResolveResultSink.convertBindingElements(element2, mappedElements) : null;
        }
        return null;
    }

    private static ResolveResult @Nullable [] convertBindingElements(@NotNull ES6ImportedBinding element2, Collection<PsiElement> elements) {
        if (element2 == null) {
            ResolveResultSink.$$$reportNull$$$0(6);
        }
        if (elements.size() > 1 && ContainerUtil.and(elements, e -> e instanceof TypeScriptFunction)) {
            elements = ContainerUtil.filter(elements, e -> !((TypeScriptFunction)e).isOverloadImplementation());
        }
        return ResolveResultSink.createAliasElementsFromResult(element2, (ResolveResult[])elements.stream().map(e -> new JSResolveResult((PsiElement)e)).toArray(ResolveResult[]::new));
    }

    private static ResolveResult @Nullable [] getResultsForSpecifierAlias(@NotNull ES6ImportExportSpecifierAlias element2) {
        ResolveResult[] newResults;
        ES6ImportExportSpecifier specifier;
        if (element2 == null) {
            ResolveResultSink.$$$reportNull$$$0(7);
        }
        if ((specifier = element2.findSpecifierElement()) != null && (newResults = ResolveResultSink.createAliasElementsFromResult(element2, specifier.multiResolve(false))) != null) {
            return newResults;
        }
        return null;
    }

    private static ResolveResult @Nullable [] createAliasElementsFromResult(@NotNull JSNamedElement element2, ResolveResult @NotNull [] results) {
        String name;
        if (element2 == null) {
            ResolveResultSink.$$$reportNull$$$0(8);
        }
        if (results == null) {
            ResolveResultSink.$$$reportNull$$$0(9);
        }
        if ((name = element2.getName()) != null && results.length > 1) {
            return TypeScriptImplicitOverloadedAliasElement.wrapElements(results, name, element2);
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    private static List<PsiElement> mergeTypeScriptImplicitMembersIfNeeded(@Nullable List<PsiElement> elements) {
        JSRecordType jsRecordType;
        JSRecordType.IndexSignature indexer;
        if (elements == null || elements.isEmpty() || elements.size() == 1 && (!(elements.get(0) instanceof TypeScriptImplicitMemberForComputedProperty) || !((TypeScriptImplicitMemberForComputedProperty)elements.get(0)).isTemporary())) {
            return elements;
        }
        if (ContainerUtil.exists(elements, e -> !(e instanceof TypeScriptImplicitMemberForComputedProperty) || !((TypeScriptImplicitMemberForComputedProperty)e).isTemporary())) {
            return elements;
        }
        TypeScriptImplicitMemberForComputedProperty element2 = (TypeScriptImplicitMemberForComputedProperty)elements.get(0);
        String name = element2.getName();
        if (name == null) {
            return elements;
        }
        PsiElement explicitElement = element2.getExplicitElement();
        PsiElement parent = explicitElement.getParent();
        if (!(parent instanceof JSObjectLiteralExpression)) {
            return elements;
        }
        JSType type2 = JSResolveUtil.getExpressionJSType((JSExpression)parent);
        if (type2 instanceof JSRecordType && (indexer = (jsRecordType = (JSRecordType)type2).findIndexer(JSRecordType.IndexSignatureKind.STRING)) != null) {
            return ContainerUtil.createMaybeSingletonList((Object)new TypeScriptImplicitMemberForComputedPropertyImpl(name, indexer.getMemberType(), parent, false));
        }
        return elements;
    }

    @NotNull
    public List<JSResolveResultForSymbolProcessor> getFilteredResults() {
        int i;
        List<PsiElement> processorResults = ResolveResultSink.mergeTypeScriptImplicitMembersIfNeeded(super.getResults());
        if (processorResults == null || processorResults.isEmpty()) {
            List<JSResolveResultForSymbolProcessor> list = Collections.emptyList();
            if (list == null) {
                ResolveResultSink.$$$reportNull$$$0(10);
            }
            return list;
        }
        Object results = new SmartList();
        HashSet<Pair> completeResults = new HashSet<Pair>(processorResults.size());
        for (i = 0; i < processorResults.size(); ++i) {
            PsiElement processorResult = processorResults.get(i);
            JSSinkResolveStatus resolveStatus = this.myResolveStatus.get(i);
            if (!resolveStatus.myIsComplete || resolveStatus.getResolveProblem() != null || !completeResults.add(Pair.create((Object)processorResult, (Object)resolveStatus))) continue;
            ResolveResultSink.fillImportExportSpecifiers(processorResult, resolveStatus, this.getNestingLevelForResultElement(processorResult, i), (List<JSResolveResultForSymbolProcessor>)results);
        }
        if (results.isEmpty()) {
            for (i = 0; i < processorResults.size(); ++i) {
                JSSinkResolveStatus resolveStatus = this.myResolveStatus.get(i);
                if (resolveStatus.myIsComplete && resolveStatus.getResolveProblem() == null) continue;
                PsiElement element2 = processorResults.get(i);
                ResolveResultSink.fillImportExportSpecifiers(element2, resolveStatus, this.getNestingLevelForResultElement(element2, i), (List<JSResolveResultForSymbolProcessor>)results);
            }
        }
        if (this.isRuntimeOnlyPlace()) {
            results = TypeScriptPsiUtil.removeCompileTimeTypes((List<JSResolveResultForSymbolProcessor>)results);
        }
        if (TypeScriptPsiUtil.elementsPossiblyContainDuplicates(ContainerUtil.map((Collection)results, JSResolveResultForSymbolProcessor::getResolveResult))) {
            results = (List)TypeScriptPsiUtil.removeDuplicates(results, el -> el.resolveResult.getElement(), this.place);
        }
        if (this.myAcceptAllResults || this.myIncomplete || this.place == null || DialectDetector.isActionScript(this.place)) {
            Object object = results;
            if (object == null) {
                ResolveResultSink.$$$reportNull$$$0(11);
            }
            return object;
        }
        JSCallLikeExpression callExpression = TypeScriptSignatureChooser.getCallLikeExpression(this.place);
        if (callExpression != null) {
            results = ResolveResultSink.filterOverloads((List<JSResolveResultForSymbolProcessor>)results, callExpression);
        }
        Object object = results;
        if (object == null) {
            ResolveResultSink.$$$reportNull$$$0(12);
        }
        return object;
    }

    @NotNull
    private static List<JSResolveResultForSymbolProcessor> filterOverloads(@NotNull List<JSResolveResultForSymbolProcessor> results, @NotNull JSCallLikeExpression callExpression) {
        if (results == null) {
            ResolveResultSink.$$$reportNull$$$0(13);
        }
        if (callExpression == null) {
            ResolveResultSink.$$$reportNull$$$0(14);
        }
        return ResolveResultSink.filterOverloads(results, callExpression, (PsiElement)callExpression, OverloadStrictness.UNIQUE);
    }

    @NotNull
    public static List<JSResolveResultForSymbolProcessor> filterOverloads(@NotNull List<JSResolveResultForSymbolProcessor> results, @NotNull JSCallItem callItem, @NotNull PsiElement place, @NotNull OverloadStrictness overloadStrictness) {
        if (results == null) {
            ResolveResultSink.$$$reportNull$$$0(15);
        }
        if (callItem == null) {
            ResolveResultSink.$$$reportNull$$$0(16);
        }
        if (place == null) {
            ResolveResultSink.$$$reportNull$$$0(17);
        }
        if (overloadStrictness == null) {
            ResolveResultSink.$$$reportNull$$$0(18);
        }
        for (JSResolveResultForSymbolProcessor result2 : results) {
            if (result2.isCompleteMatch && result2.resolveResult.isValidResult()) continue;
            List<JSResolveResultForSymbolProcessor> list = results;
            if (list == null) {
                ResolveResultSink.$$$reportNull$$$0(19);
            }
            return list;
        }
        ArrayList<JSResolveResultForSymbolProcessor> sortedResults = new ArrayList<JSResolveResultForSymbolProcessor>(results);
        Collections.sort(sortedResults, Comparator.comparing(r -> r.getResolveResult().getElement(), JSResolveUtil.FILE_PATH_COMPARATOR));
        ArrayList<JSResolveResultForSymbolProcessor> filteredOverloads = (ArrayList<JSResolveResultForSymbolProcessor>)JSEvaluationRecursionGuard.compute(place, new JSEvaluateContext(place.getContainingFile(), false), () -> new JSTypeSignatureChooser(callItem).chooseOverload((List<JSResolveResultForSymbolProcessor>)sortedResults, overloadStrictness));
        ArrayList<JSResolveResultForSymbolProcessor> arrayList = filteredOverloads != null ? filteredOverloads : sortedResults;
        if (arrayList == null) {
            ResolveResultSink.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    private boolean isRuntimeOnlyPlace() {
        boolean isStrictTypeContext = this.place instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)this.place);
        return !isStrictTypeContext && TypeScriptPsiUtil.isPlaceRuntimeOnly(this.place, false);
    }

    private static void fillImportExportSpecifiers(@NotNull PsiElement element2, @NotNull JSSinkResolveStatus sinkResolveStatus, int nestingLevel, @NotNull List<JSResolveResultForSymbolProcessor> outResults) {
        List<JSResolveResultForSymbolProcessor> resolvedImports;
        if (element2 == null) {
            ResolveResultSink.$$$reportNull$$$0(21);
        }
        if (sinkResolveStatus == null) {
            ResolveResultSink.$$$reportNull$$$0(22);
        }
        if (outResults == null) {
            ResolveResultSink.$$$reportNull$$$0(23);
        }
        if ((resolvedImports = ResolveResultSink.resolveImportExportSpecifier(element2, sinkResolveStatus.getResolveProblem(), sinkResolveStatus.getTypeSubstitutor(), nestingLevel)) != null) {
            outResults.addAll(resolvedImports);
        } else {
            JSResolveResult first = new JSResolveResult(element2, sinkResolveStatus.myResolveStatus);
            outResults.add(new JSResolveResultForSymbolProcessor(first, sinkResolveStatus.myIsComplete, nestingLevel));
        }
    }

    @Nullable
    public static List<JSResolveResultForSymbolProcessor> resolveImportExportSpecifier(@NotNull PsiElement element2, @Nullable JSResolveResult.ProblemKind resolveProblem, @Nullable JSTypeSubstitutor typeSubstitutor, int nestingLevel) {
        Object[] resolvedImports;
        if (element2 == null) {
            ResolveResultSink.$$$reportNull$$$0(24);
        }
        if ((resolvedImports = ResolveResultSink.resolveImportExportSpecifiers(element2)) != null && resolvedImports.length > 0 && resolvedImports[0].isValidResult()) {
            JSElement importElement = element2 instanceof JSElement ? (JSElement)element2 : null;
            return ContainerUtil.map((Object[])resolvedImports, r -> {
                JSResolveResult first = new JSResolveResult(r.getElement(), new JSResolveStatus(importElement, resolveProblem, typeSubstitutor));
                return new JSResolveResultForSymbolProcessor(first, true, nestingLevel);
            });
        }
        return null;
    }

    @Override
    public void addCandidateResult(PsiElement element2, boolean isCompleteMatch, JSResolveResult.ProblemKind problemKind) {
        if (this.myCandidateResults == null) {
            this.myCandidateResults = new HashSet<PsiElement>();
        }
        if (!this.myCandidateResults.add(element2)) {
            return;
        }
        super.addResult(element2, null, null);
        if (this.myResolveStatus == null) {
            this.myResolveStatus = new SmartList();
        }
        this.myResolveStatus.add(new JSSinkResolveStatus(null, isCompleteMatch, problemKind, null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 10, 11, 12, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/ResolveResultSink";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callItem";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overloadStrictness";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sinkResolveStatus";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/ResolveResultSink";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultsAsResolveResults";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredResults";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOverloads";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 20: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResultsForImportedBinding";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertBindingElements";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResultsForSpecifierAlias";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAliasElementsFromResult";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "filterOverloads";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fillImportExportSpecifiers";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "resolveImportExportSpecifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 10, 11, 12, 19, 20 -> new IllegalStateException(string);
        };
    }

    public static final class JSResolveResultForSymbolProcessor {
        private final ResolveResult resolveResult;
        final boolean isCompleteMatch;
        final int nestingLevel;

        public JSResolveResultForSymbolProcessor(@NotNull ResolveResult baseResult) {
            if (baseResult == null) {
                JSResolveResultForSymbolProcessor.$$$reportNull$$$0(0);
            }
            this(baseResult, true, 0);
        }

        public JSResolveResultForSymbolProcessor(ResolveResult resolveResult, boolean isCompleteMatch, int nestingLevel) {
            this.resolveResult = resolveResult;
            this.isCompleteMatch = isCompleteMatch;
            this.nestingLevel = nestingLevel;
        }

        @NotNull
        public ResolveResult getResolveResult() {
            ResolveResult resolveResult = this.resolveResult;
            if (resolveResult == null) {
                JSResolveResultForSymbolProcessor.$$$reportNull$$$0(1);
            }
            return resolveResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseResult";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/ResolveResultSink$JSResolveResultForSymbolProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/ResolveResultSink$JSResolveResultForSymbolProcessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResolveResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

