/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.rename;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.lang.javascript.refactoring.JSGetterSetterRenameUtil;
import com.intellij.lang.javascript.refactoring.ui.JSRenameOptionData;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JSMemberRenameProcessor
extends JSDefaultRenameProcessor {
    JSMemberRenameProcessor() {
    }

    @Override
    public boolean canProcessElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSMemberRenameProcessor.$$$reportNull$$$0(0);
        }
        if (!super.canProcessElement(element2)) {
            return false;
        }
        if (!JSClassUtils.isPossibleHierarchyMember(element2)) {
            return false;
        }
        if (DialectDetector.isActionScript(element2)) {
            return false;
        }
        return JSUtils.getMemberContainingClass(element2) != null;
    }

    @Override
    public void prepareRenaming(@NotNull PsiElement element2, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope2) {
        if (element2 == null) {
            JSMemberRenameProcessor.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            JSMemberRenameProcessor.$$$reportNull$$$0(2);
        }
        if (allRenames == null) {
            JSMemberRenameProcessor.$$$reportNull$$$0(3);
        }
        if (scope2 == null) {
            JSMemberRenameProcessor.$$$reportNull$$$0(4);
        }
        super.prepareRenaming(element2, newName, allRenames, scope2);
        if (!JSClassUtils.isPossibleHierarchyMember(element2)) {
            return;
        }
        JSClass jsClass = JSUtils.getMemberContainingClass(element2);
        if (jsClass == null) {
            return;
        }
        JSMemberRenameProcessor.iterateMembersDown(element2, newName, allRenames);
        Map<PsiElement, String> elementsToRename = JSGetterSetterRenameUtil.getRelatedElementsInClass(element2, jsClass, newName);
        allRenames.putAll(elementsToRename);
        for (Map.Entry<PsiElement, String> entry : elementsToRename.entrySet()) {
            JSMemberRenameProcessor.iterateMembersDown(entry.getKey(), entry.getValue(), allRenames);
        }
    }

    private static void iterateMembersDown(@NotNull PsiElement element2, String newName, @NotNull Map<PsiElement, String> allRenames) {
        JSAttributeListOwner jsMember;
        if (element2 == null) {
            JSMemberRenameProcessor.$$$reportNull$$$0(5);
        }
        if (allRenames == null) {
            JSMemberRenameProcessor.$$$reportNull$$$0(6);
        }
        if (!JSInheritanceUtil.canBeSuperMember(jsMember = (JSAttributeListOwner)element2) || !(element2 instanceof JSPsiElementBase)) {
            return;
        }
        JSInheritanceUtil.iterateMembersDown((JSPsiElementBase)element2, (Processor<? super JSPsiElementBase>)((Processor)member -> {
            JSMemberRenameProcessor.addMemberWithOverload(member, newName, allRenames);
            return true;
        }));
    }

    private static void addMemberWithOverload(JSPsiElementBase el, String newName, Map<PsiElement, String> allRenames) {
        allRenames.put((PsiElement)el, newName);
        if (el instanceof TypeScriptFunction) {
            for (TypeScriptFunction function : TypeScriptPsiUtil.getAllOverloadsWithImplementation((TypeScriptFunction)el)) {
                allRenames.put(function, newName);
            }
        }
    }

    @Override
    public void substituteElementToRename(@NotNull PsiElement element2, @NotNull Editor editor, @NotNull Pass<? super PsiElement> renameCallback) {
        Pair<JSPsiElementBase, JSClass> memberJSClassPair;
        if (element2 == null) {
            JSMemberRenameProcessor.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            JSMemberRenameProcessor.$$$reportNull$$$0(8);
        }
        if (renameCallback == null) {
            JSMemberRenameProcessor.$$$reportNull$$$0(9);
        }
        if ((memberJSClassPair = JSMemberRenameProcessor.getSuperMember(element2)) == null) {
            this.processSubstituted(element2, editor, (Consumer<? super PsiElement>)renameCallback);
            return;
        }
        JSPsiElementBase parentMember = (JSPsiElementBase)memberJSClassPair.first;
        JSPsiElementBase currentMember = (JSPsiElementBase)element2;
        String title = JSMemberRenameProcessor.getMemberTitle(parentMember);
        List<JSRenameOptionData> options = List.of(new JSRenameOptionData((PsiElement)parentMember, JavaScriptBundle.message("js.rename.base.member", title)), new JSRenameOptionData((PsiElement)currentMember, JavaScriptBundle.message("js.rename.base.member", title)));
        this.substituteWithPopup(editor, renameCallback, JSMemberRenameProcessor.getDialogTitle(parentMember, (JSClass)memberJSClassPair.second), null, options);
    }

    @Override
    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element2, @Nullable Editor editor) {
        Pair<JSPsiElementBase, JSClass> memberJSClassPair;
        if (element2 == null) {
            JSMemberRenameProcessor.$$$reportNull$$$0(10);
        }
        if ((memberJSClassPair = JSMemberRenameProcessor.getSuperMember(element2)) == null) {
            return super.substituteElementToRename(element2, editor);
        }
        JSPsiElementBase parentMember = (JSPsiElementBase)memberJSClassPair.first;
        JSClass parentClass = (JSClass)memberJSClassPair.second;
        String memberTitle = JSMemberRenameProcessor.getMemberTitle(parentMember);
        List<JSRenameOptionData> options = List.of(new JSRenameOptionData((PsiElement)parentMember, JavaScriptBundle.message("js.rename.base.member", memberTitle)), new JSRenameOptionData(element2, JavaScriptBundle.message("js.rename.current.member", memberTitle)));
        return this.substituteWithPopup(editor, null, JSMemberRenameProcessor.getDialogTitle(parentMember, parentClass), JavaScriptBundle.message("rename.prompt.do.you.want.to.rename.base.method", "rename", 1), options);
    }

    @Nullable
    private static Pair<JSPsiElementBase, JSClass> getSuperMember(PsiElement element2) {
        if (!JSClassUtils.isPossibleHierarchyMember(element2)) {
            return null;
        }
        JSAttributeListOwner jsMember = (JSAttributeListOwner)element2;
        JSClass jsClass = JSUtils.getMemberContainingClass(element2);
        if (!JSInheritanceUtil.canHaveSuperMember(jsMember) || jsClass == null) {
            return null;
        }
        Collection<JSPsiElementBase> members = JSInheritanceUtil.findTopMembers((JSQualifiedNamedElement)((Object)jsMember));
        if (members.size() > 1) {
            return null;
        }
        JSPsiElementBase parentMember = (JSPsiElementBase)ContainerUtil.getFirstItem(members);
        JSClass parentClass = JSUtils.getMemberContainingClass((PsiElement)parentMember);
        if (parentMember == null || parentClass == null) {
            return null;
        }
        return Pair.create((Object)parentMember, (Object)parentClass);
    }

    @NlsContexts.DialogTitle
    @NotNull
    private static String getDialogTitle(JSPsiElementBase parentMember, JSClass parentClass) {
        String memberName = JSMemberRenameProcessor.getMemberTitle(parentMember);
        String verb = parentClass.isInterface() ? JavaScriptBundle.message("js.rename.member.title.implements", new Object[0]) : JavaScriptBundle.message("js.rename.member.title.overrides", new Object[0]);
        String string = JavaScriptBundle.message("js.rename.member.title", parentMember.getName(), verb, memberName, SymbolPresentationUtil.getSymbolPresentableText((PsiElement)parentClass));
        if (string == null) {
            JSMemberRenameProcessor.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nls
    @NotNull
    private static String getMemberTitle(JSPsiElementBase parentMember) {
        String string = parentMember instanceof JSField ? JavaScriptBundle.message("javascript.language.term.field", new Object[0]) : JavaScriptBundle.message("javascript.language.term.method", new Object[0]);
        if (string == null) {
            JSMemberRenameProcessor.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renameCallback";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/rename/JSMemberRenameProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/rename/JSMemberRenameProcessor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialogTitle";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "iterateMembersDown";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12 -> new IllegalStateException(string);
        };
    }
}

