/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.codeFixes;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.intellij.lang.javascript.service.JSLanguageServiceFileCommandCache;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceAnnotationResult;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServiceExtension;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptLanguageServiceFix;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptLanguageServiceFixSet;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetCodeFixes;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetCodeFixesRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptCodeActionInfo;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptGetCodeFixesResponse;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0001!B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u001c\u001a\u00020\u0014H\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFixSet;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "myFixProvider", "Lcom/intellij/lang/javascript/service/JSLanguageServiceFileCommandCache;", "myVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "myResult", "Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceAnnotationResult;", "limitedRanges", "", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/javascript/service/JSLanguageServiceFileCommandCache;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceAnnotationResult;Ljava/util/List;)V", "fixes", "Lcom/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFix;", "getFixes", "()Ljava/util/List;", "refresh", "", "index", "", "calcAndUpdateState", "psiFile", "Lcom/intellij/psi/PsiFile;", "command", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptGetCodeFixes;", "setLoadingState", "updateState", "response", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptGetCodeFixesResponse;", "createCommand", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nTypeScriptLanguageServiceFixSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptLanguageServiceFixSet.kt\ncom/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFixSet\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n1740#2,3:154\n1869#2,2:157\n1869#2,2:159\n1869#2,2:161\n*S KotlinDebug\n*F\n+ 1 TypeScriptLanguageServiceFixSet.kt\ncom/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFixSet\n*L\n35#1:154,3\n49#1:157,2\n57#1:159,2\n75#1:161,2\n*E\n"})
public final class TypeScriptLanguageServiceFixSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final JSLanguageServiceFileCommandCache myFixProvider;
    @NotNull
    private final VirtualFile myVirtualFile;
    @NotNull
    private final TypeScriptLanguageServiceAnnotationResult myResult;
    @NotNull
    private final List<TypeScriptLanguageServiceFix> fixes;
    private static final int MAX_QUICK_FIXES = 5;

    public TypeScriptLanguageServiceFixSet(@NotNull Project myProject, @NotNull JSLanguageServiceFileCommandCache myFixProvider, @NotNull VirtualFile myVirtualFile, @NotNull TypeScriptLanguageServiceAnnotationResult myResult, @Nullable List<TextRange> limitedRanges) {
        boolean bl;
        List fixes;
        block4: {
            Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
            Intrinsics.checkNotNullParameter((Object)myFixProvider, (String)"myFixProvider");
            Intrinsics.checkNotNullParameter((Object)myVirtualFile, (String)"myVirtualFile");
            Intrinsics.checkNotNullParameter((Object)myResult, (String)"myResult");
            this.myProject = myProject;
            this.myFixProvider = myFixProvider;
            this.myVirtualFile = myVirtualFile;
            this.myResult = myResult;
            fixes = new ArrayList(5);
            Iterable $this$all$iv = TypeScriptServiceExtension.EP_NAME.getExtensionList();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    TypeScriptServiceExtension extension = (TypeScriptServiceExtension)element$iv;
                    boolean bl2 = false;
                    if (extension.shouldReformatAfterFix(this.myResult)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        boolean shouldReformatAfterFix = bl;
        for (int index = 0; index < 5; ++index) {
            fixes.add(new TypeScriptLanguageServiceFix(() -> TypeScriptLanguageServiceFixSet._init_$lambda$1(this, index), index, limitedRanges, shouldReformatAfterFix));
        }
        this.fixes = fixes;
    }

    @NotNull
    public final List<TypeScriptLanguageServiceFix> getFixes() {
        return this.fixes;
    }

    private final void refresh(int index) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myProject.isDisposed()) {
            return;
        }
        if (!this.myVirtualFile.isValid()) {
            Iterable $this$forEach$iv = this.fixes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TypeScriptLanguageServiceFix it = (TypeScriptLanguageServiceFix)element$iv;
                boolean bl = false;
                it.update(null);
            }
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(this.myVirtualFile);
        if (psiFile == null) {
            Iterable $this$forEach$iv = this.fixes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TypeScriptLanguageServiceFix it = (TypeScriptLanguageServiceFix)element$iv;
                boolean bl = false;
                it.update(null);
            }
            return;
        }
        TypeScriptGetCodeFixes command = this.createCommand();
        TypeScriptGetCodeFixesResponse response2 = (TypeScriptGetCodeFixesResponse)this.myFixProvider.getCachedValue(psiFile, command);
        if (response2 != null) {
            this.updateState(response2);
            return;
        }
        this.calcAndUpdateState(psiFile, command, index);
    }

    private final void calcAndUpdateState(PsiFile psiFile, TypeScriptGetCodeFixes command, int index) {
        if (index == 0) {
            Iterable $this$forEach$iv = this.fixes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TypeScriptLanguageServiceFix it = (TypeScriptLanguageServiceFix)element$iv;
                boolean bl = false;
                it.update(null);
            }
        }
        Gson gson = JSLanguageServiceUtil.getGson(this.myFixProvider.getService());
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"getGson(...)");
        Gson gson2 = gson;
        TypeScriptGetCodeFixesResponse result2 = null;
        if (ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
            if (index == 0 && (result2 = (TypeScriptGetCodeFixesResponse)this.myFixProvider.getCachedValue(psiFile, command)) == null) {
                this.setLoadingState();
                return;
            }
        } else {
            if (index == 0) {
                this.setLoadingState();
            }
            result2 = (TypeScriptGetCodeFixesResponse)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TypeScriptGetCodeFixesResponse>, Object>(this, psiFile, command, gson2, null){
                int label;
                final /* synthetic */ TypeScriptLanguageServiceFixSet this$0;
                final /* synthetic */ PsiFile $psiFile;
                final /* synthetic */ TypeScriptGetCodeFixes $command;
                final /* synthetic */ Gson $gson;
                {
                    this.this$0 = $receiver;
                    this.$psiFile = $psiFile;
                    this.$command = $command;
                    this.$gson = $gson;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = TimeoutKt.withTimeoutOrNull((long)JSLanguageServiceUtil.getShortTimeout(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TypeScriptGetCodeFixesResponse>, Object>(this.this$0, this.$psiFile, this.$command, this.$gson, null){
                                int label;
                                final /* synthetic */ TypeScriptLanguageServiceFixSet this$0;
                                final /* synthetic */ PsiFile $psiFile;
                                final /* synthetic */ TypeScriptGetCodeFixes $command;
                                final /* synthetic */ Gson $gson;
                                {
                                    this.this$0 = $receiver;
                                    this.$psiFile = $psiFile;
                                    this.$command = $command;
                                    this.$gson = $gson;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = TypeScriptLanguageServiceFixSet.access$getMyFixProvider$p(this.this$0).calculateWithCache(this.$psiFile, this.$command, arg_0 -> calcAndUpdateState.1.invokeSuspend$lambda$0(this.$gson, arg_0), (Continuation)this);
                                            if (object2 != object) return object2;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return object2;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super TypeScriptGetCodeFixesResponse> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }

                                private static final TypeScriptGetCodeFixesResponse invokeSuspend$lambda$0(Gson $gson, JSLanguageServiceAnswer it) {
                                    return !it.isEmpty() ? (TypeScriptGetCodeFixesResponse)$gson.fromJson((JsonElement)it.getElement(), TypeScriptGetCodeFixesResponse.class) : null;
                                }
                            }), (Continuation)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super TypeScriptGetCodeFixesResponse> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
        if (result2 != null) {
            this.updateState(result2);
        }
    }

    private final void setLoadingState() {
        int n = ((Collection)this.fixes).size();
        for (int i = 0; i < n; ++i) {
            TypeScriptLanguageServiceFix fix = this.fixes.get(i);
            fix.update(i == 0 ? TypeScriptLanguageServiceFix.LOADING : null);
        }
    }

    private final void updateState(TypeScriptGetCodeFixesResponse response2) {
        TypeScriptCodeActionInfo[] body;
        TypeScriptCodeActionInfo[] typeScriptCodeActionInfoArray = body = response2.body;
        if (body == null) {
            typeScriptCodeActionInfoArray = new TypeScriptCodeActionInfo[]{};
        }
        TypeScriptCodeActionInfo[] actions = typeScriptCodeActionInfoArray;
        int n = ((Collection)this.fixes).size();
        for (int i = 0; i < n; ++i) {
            TypeScriptLanguageServiceFix fix = this.fixes.get(i);
            if (actions.length > i) {
                TypeScriptCodeActionInfo action = actions[i];
                fix.update(new TypeScriptLanguageServiceFix.State(action));
                continue;
            }
            fix.update(null);
        }
    }

    private final TypeScriptGetCodeFixes createCommand() {
        TypeScriptGetCodeFixesRequestArgs args = new TypeScriptGetCodeFixesRequestArgs();
        args.file = LocalFilePath.Companion.create(TypeScriptCompilerConfigUtil.normalizeNameAndPath(this.myVirtualFile));
        args.startOffset = this.myResult.getColumn() + 1;
        args.startLine = this.myResult.getLine() + 1;
        args.endOffset = this.myResult.getEndColumn() + 1;
        args.endLine = this.myResult.getEndLine() + 1;
        int[] nArray = new int[]{this.myResult.getErrorCode()};
        args.errorCodes = nArray;
        return new TypeScriptGetCodeFixes(args);
    }

    private static final void _init_$lambda$1(TypeScriptLanguageServiceFixSet this$0, int $index) {
        this$0.refresh($index);
    }

    public static final /* synthetic */ JSLanguageServiceFileCommandCache access$getMyFixProvider$p(TypeScriptLanguageServiceFixSet $this) {
        return $this.myFixProvider;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFixSet$Companion;", "", "<init>", "()V", "MAX_QUICK_FIXES", "", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

