/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.BeforeAfter;
import com.intellij.util.Consumer;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.FlameData;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.StackLineData;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8CpuViewCallback;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.ChartPanel;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.FlameColors;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public abstract class V8CpuFlameChart
extends ChartPanel {
    public final int STACK_ELEMENT_HEIGHT;
    private final V8LogCachingReader myReader;
    private final java.util.function.Consumer<? super String> myNotificator;
    private JBScrollPane myParentScroll;
    private FlameData myFlameData;
    private Map<Long, JBColor> myColors;
    private boolean myIsLoading;
    private boolean myHaveData;
    private volatile long myDetailsPosition;
    private volatile int myDetailsIdx;
    private boolean myNearDetailsPosition;
    private final Object myLock;
    private long mySelectionFrom;
    private long mySelectionTo;
    private final Convertor<Long, Integer> myCoordConvertor;
    private final int myMinTextWidth;
    private Map<Long, String> myStrings;
    private Integer mySelectedInChartRow;
    private java.util.function.Consumer<Boolean> myUIUpdate;

    public V8CpuFlameChart(int left, int rightMargin, int top, V8LogCachingReader reader, java.util.function.Consumer<? super String> notificator, Long leftTs, Long rightTs, @NotNull V8CpuViewCallback viewCallback) {
        if (viewCallback == null) {
            V8CpuFlameChart.$$$reportNull$$$0(0);
        }
        super(left, rightMargin, top, reader.getMaxStackSize(), leftTs == null ? 0L : leftTs, rightTs == null ? reader.getLastTick() : rightTs.longValue());
        this.myDrawLabels = false;
        this.setFont(this.getFont().deriveFont(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL)));
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        this.STACK_ELEMENT_HEIGHT = metrics.getHeight();
        this.myLock = new Object();
        this.mySelectionFrom = 0L;
        this.mySelectionTo = reader.getLastTick();
        this.myNotificator = notificator;
        this.myMinTextWidth = metrics.stringWidth("test");
        this.myHaveData = false;
        this.myIsLoading = false;
        this.myReader = reader;
        this.myDetailsPosition = 0L;
        this.myDetailsIdx = 0;
        this.myCoordConvertor = ts -> this.pixelsFromReal((long)ts);
        MouseAdapter adapter = this.createMouseAdapter();
        this.addMouseListener(adapter);
        this.addMouseMotionListener(adapter);
    }

    @NotNull
    private MouseAdapter createMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (V8CpuFlameChart.this.myNearDetailsPosition) {
                    int x = e.getX();
                    if (x < V8CpuFlameChart.this.myLeft || x > V8CpuFlameChart.this.getWidth() - V8CpuFlameChart.this.myRightMargin) {
                        return;
                    }
                    long was = V8CpuFlameChart.this.myDetailsPosition;
                    V8CpuFlameChart.this.myDetailsPosition = V8CpuFlameChart.this.realFromPixels(x);
                    if (was != V8CpuFlameChart.this.myDetailsPosition) {
                        V8CpuFlameChart.this.calculateNewSelectedRow(e.getY(), V8CpuFlameChart.this.myDetailsPosition);
                        V8CpuFlameChart.this.detailsChanged();
                        V8CpuFlameChart.this.revalidate();
                        V8CpuFlameChart.this.repaint();
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int x = e.getX();
                int detailsPixels = V8CpuFlameChart.this.pixelsFromReal(V8CpuFlameChart.this.myDetailsPosition);
                V8CpuFlameChart.this.myNearDetailsPosition = V8CpuFlameChart.this.aroundBound(x, detailsPixels);
                if (V8CpuFlameChart.this.myNearDetailsPosition) {
                    V8CpuFlameChart.this.setCursor(new Cursor(10));
                } else {
                    V8CpuFlameChart.this.setCursor(Cursor.getDefaultCursor());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int x = e.getX();
                V8CpuFlameChart.this.myDetailsPosition = V8CpuFlameChart.this.realFromPixels(x);
                V8CpuFlameChart.this.calculateNewSelectedRow(e.getY(), V8CpuFlameChart.this.myDetailsPosition);
                V8CpuFlameChart.this.detailsChanged();
                V8CpuFlameChart.this.revalidate();
                V8CpuFlameChart.this.repaint();
            }
        };
    }

    private void calculateNewSelectedRowForStringId(long ts, long stringId) {
        if (this.myFlameData == null) {
            this.mySelectedInChartRow = null;
            return;
        }
        for (int i = 0; i < this.myFlameData.getStackLineData().size(); ++i) {
            TreeMap<Long, StackLineData> map = this.myFlameData.getStackLineData().get(i);
            Map.Entry<Long, StackLineData> entry = map.floorEntry(ts);
            if (entry == null || entry.getKey() + entry.getValue().getDuration() < ts || entry.getValue().getStringId() != stringId) continue;
            this.mySelectedInChartRow = i;
            break;
        }
    }

    private void calculateNewSelectedRow(int y, long ts) {
        int max;
        if (this.myFlameData == null) {
            this.mySelectedInChartRow = null;
            return;
        }
        int idx = (int)Math.floor((double)(this.getWholeHeight() - y) / (double)this.STACK_ELEMENT_HEIGHT);
        int n = idx = idx >= (max = this.myFlameData.getStackLineData().size()) ? max - 1 : idx;
        while (idx >= 0 && idx < max) {
            TreeMap<Long, StackLineData> map = this.myFlameData.getStackLineData().get(idx);
            Map.Entry<Long, StackLineData> entry = map.floorEntry(ts);
            if (entry != null && entry.getKey() + entry.getValue().getDuration() >= ts) {
                this.mySelectedInChartRow = idx;
                return;
            }
            --idx;
        }
        this.mySelectedInChartRow = null;
    }

    public void setParentScroll(JBScrollPane parentScroll) {
        this.myParentScroll = parentScroll;
        this.myParentScroll.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                V8CpuFlameChart.this.repaint();
            }
        });
    }

    private int getWholeHeight() {
        if (this.myParentScroll != null) {
            if (this.myFlameData == null) {
                return this.myParentScroll.getHeight();
            }
            return Math.max(this.myParentScroll.getHeight(), this.myFlameData.getStackLineData().size() * this.STACK_ELEMENT_HEIGHT + this.myTop);
        }
        return this.myFlameData == null ? this.myTop + this.STACK_ELEMENT_HEIGHT : this.myFlameData.getStackLineData().size() * this.STACK_ELEMENT_HEIGHT + this.myTop;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.myLeft + this.myRightMargin + 10, this.getWholeHeight());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return new Dimension(size.width, this.getWholeHeight());
    }

    public Integer getSelectedInChartRow() {
        return this.mySelectedInChartRow;
    }

    @NotNull
    public Pair<Long, Integer> getDetailsPosition() {
        Pair pair = Pair.create((Object)this.myDetailsPosition, (Object)this.myDetailsIdx);
        if (pair == null) {
            V8CpuFlameChart.$$$reportNull$$$0(1);
        }
        return pair;
    }

    private int findDetailsIdx() {
        if (this.myFlameData == null) {
            return 0;
        }
        List<Long> times = this.myFlameData.getTimes();
        int firstTickOffset = this.myFlameData.getFirstTickOffset();
        int idx = Collections.binarySearch(times, this.myDetailsPosition);
        if (idx >= 0) {
            return firstTickOffset + idx;
        }
        int position = -idx - 1;
        return firstTickOffset + position - 1;
    }

    protected void detailsChanged() {
        this.myDetailsIdx = this.findDetailsIdx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateData() {
        long to;
        long from;
        Object object = this.myLock;
        synchronized (object) {
            from = this.mySelectionFrom;
            to = this.mySelectionTo;
        }
        long minInterval = this.getWidth() == 0 ? 1000L : this.realFromPixels(this.myMinTextWidth) - this.realFromPixels(this.myLeft);
        try {
            FlameData flameData = this.myReader.getStack(from, to);
            HashMap<Long, JBColor> colors = new HashMap<Long, JBColor>();
            HashMap<Long, String> strings = new HashMap<Long, String>();
            if (flameData != null) {
                List<TreeMap<Long, StackLineData>> data = flameData.getStackLineData();
                for (TreeMap<Long, StackLineData> map : data) {
                    for (StackLineData lineData : map.values()) {
                        long code = lineData.getStringId();
                        if (!colors.containsKey(code)) {
                            colors.put(code, FlameColors.getColor(code, this.myReader.getCodeScopeByStringId(code)));
                        }
                        if (lineData.getDuration() < minInterval) continue;
                        V8CpuLogCall call = V8CpuLogCall.create(this.myReader.getStringById(lineData.getStringId()), lineData.getStringId());
                        strings.put(lineData.getStringId(), call.getShort());
                    }
                }
            }
            this.myUIUpdate = this.createUIUpdate(from, to, flameData, colors, strings);
        }
        catch (IOException e) {
            this.myNotificator.accept("Can not get data for flame chart: " + e.getMessage());
            this.myUIUpdate = t -> {};
        }
    }

    public java.util.function.Consumer<Boolean> getUIUpdate() {
        return this.myUIUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selection(long from, long to) throws IOException {
        assert (from >= 0L);
        assert (to >= 0L);
        this.myIsLoading = true;
        Object object = this.myLock;
        synchronized (object) {
            this.mySelectionFrom = from;
            this.mySelectionTo = to;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeforeAfter<Long> getSelection() {
        Object object = this.myLock;
        synchronized (object) {
            return new BeforeAfter((Object)this.mySelectionFrom, (Object)this.mySelectionTo);
        }
    }

    public boolean isEmpty() {
        return this.myFlameData == null;
    }

    private java.util.function.Consumer<Boolean> createUIUpdate(long from, long to, FlameData flameData, Map<Long, JBColor> colors, Map<Long, String> strings) {
        return reloadingIsEmpty -> {
            this.myRealLeft = from;
            this.myRealRight = to;
            boolean bl = this.myIsLoading = reloadingIsEmpty == false;
            if (flameData != null) {
                this.myHaveData = true;
                this.myFlameData = flameData;
                this.myColors = colors;
                this.myStrings = strings;
                if (this.myDetailsPosition <= this.myRealLeft || this.myDetailsPosition >= this.myRealRight) {
                    this.myDetailsPosition = (this.myRealLeft + this.myRealRight) / 2L;
                    this.calculateNewSelectedRow(0, this.myDetailsPosition);
                    this.detailsChanged();
                }
                this.myParentScroll.revalidate();
                this.myParentScroll.repaint();
            } else {
                this.myFlameData = null;
                this.myHaveData = false;
            }
            this.revalidate();
            this.repaint();
        };
    }

    @Override
    protected void drawTsGrid(Graphics2D g) {
        if (this.myHaveData) {
            super.drawTsGrid(g);
        }
    }

    @Override
    protected void drawChart(Graphics2D graphics2D, int left, int top, int width, int height, int gridGap) {
        V8Utils.safeDraw(graphics2D, (Consumer<? super Graphics2D>)((Consumer)graphics -> {
            int wholeHeight = this.getWholeHeight();
            Rectangle visibleRect = this.getVisibleRect();
            if (this.myIsLoading) {
                this.displayMessageInCenter((Graphics2D)graphics, CommonBundle.getLoadingTreeNodeText(), left, width);
            } else if (this.myHaveData) {
                Rectangle clip = graphics.getClipBounds();
                Drawer drawer = new Drawer(this.myCoordConvertor, wholeHeight, (Graphics2D)graphics, this.myColors, this.myStrings, this.getBackground(), clip.y, clip.height, this.myMinTextWidth, left + width, this.STACK_ELEMENT_HEIGHT, visibleRect.y + this.myTop, this.myDetailsPosition, this.mySelectedInChartRow);
                drawer.draw(this.myFlameData.getStackLineData());
            } else {
                this.displayMessageInCenter((Graphics2D)graphics, "Too many data points. Select smaller interval.", left, width);
            }
            graphics.setStroke(new BasicStroke(1.0f));
            graphics.setColor(Color.gray);
            int height1 = Math.min(wholeHeight, visibleRect.height - top - 1);
            if (this.myHaveData) {
                int details = this.pixelsFromReal(this.myDetailsPosition);
                V8CpuFlameChart.drawDetailsLine(graphics, visibleRect, height1, details, top);
            }
        }));
    }

    public static void drawDetailsLine(Graphics2D graphics, Rectangle visibleRect, int height, int details, int top) {
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.setColor(Color.black);
        graphics.drawLine(details, visibleRect.y, details, visibleRect.y + visibleRect.height);
    }

    private void displayMessageInCenter(Graphics2D graphics, String text, int left, int width) {
        Rectangle visibleRect = this.getVisibleRect();
        graphics.setColor(Color.gray);
        int stringWidth = graphics.getFontMetrics().stringWidth(text);
        graphics.drawString(text, left + (width - stringWidth) / 2, visibleRect.height / 2);
    }

    public void setDetailsPosition(Long real, long stringId) {
        this.myDetailsPosition = real;
        this.mySelectedInChartRow = null;
        this.detailsChanged();
        if (stringId >= 0L) {
            this.calculateNewSelectedRowForStringId(real, stringId);
        }
        this.revalidate();
        this.repaint();
    }

    public void setSelectedCells(int detailsCount, int[] rows) {
        Integer n = this.mySelectedInChartRow = rows == null || rows.length == 0 ? null : Integer.valueOf(detailsCount - rows[0] - 1);
        if (this.mySelectedInChartRow != null && this.myParentScroll != null) {
            int wholeHeight = this.getWholeHeight();
            int upper = wholeHeight - (this.mySelectedInChartRow + 1) * this.STACK_ELEMENT_HEIGHT;
            this.scrollRectToVisible(new Rectangle(0, upper, this.getWidth(), this.STACK_ELEMENT_HEIGHT));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewCallback";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/cpu/v8log/ui/V8CpuFlameChart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/ui/V8CpuFlameChart";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetailsPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class Drawer {
        private final Convertor<Long, Integer> myToCoordConvertor;
        private final int myWholeHeight;
        private final Graphics2D myGraphics;
        private final Map<Long, JBColor> myColors;
        private final Map<Long, String> myStrings;
        private final Color myBackground;
        private final int myWidth;
        private final int myMinWidth;
        private final int STACK_ELEMENT_HEIGHT;
        private final int myTop;
        private final long myDetailsPosition;
        private final Integer mySelectedRow;
        private final int myHighestIdx;
        private final int myLowestIdx;
        private final FontMetrics myMetrics;
        private int x1;
        private int x2;
        private int y1;
        private int y2;
        private int myIdx;
        private Long myTs;
        private StackLineData myLineData;

        Drawer(Convertor<Long, Integer> toCoordConvertor, int wholeHeight, Graphics2D graphics2D, Map<Long, JBColor> colors, Map<Long, String> strings, Color background, int clipYCoord, int clipHeight, int minTextWidth, int width, int stack_element_height, int top, long detailsPosition, Integer selectedRow) {
            this.myToCoordConvertor = toCoordConvertor;
            this.myWholeHeight = wholeHeight;
            this.myGraphics = graphics2D;
            this.myColors = colors;
            this.myStrings = strings;
            this.myBackground = background;
            this.myWidth = width;
            this.STACK_ELEMENT_HEIGHT = stack_element_height;
            this.myTop = top;
            this.myDetailsPosition = detailsPosition;
            this.mySelectedRow = selectedRow;
            this.myHighestIdx = (int)Math.ceil(((double)this.myWholeHeight - (double)clipYCoord) / (double)this.STACK_ELEMENT_HEIGHT) - 1;
            this.myLowestIdx = Math.max(0, (int)(Math.floor(((double)this.myWholeHeight - (double)clipYCoord - (double)clipHeight) / (double)this.STACK_ELEMENT_HEIGHT) - 1.0));
            this.myMinWidth = minTextWidth;
            graphics2D.setFont(graphics2D.getFont().deriveFont(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL)));
            this.myMetrics = this.myGraphics.getFontMetrics();
        }

        private int lowY(int idx) {
            return this.myWholeHeight - (idx + 1) * this.STACK_ELEMENT_HEIGHT;
        }

        private int highY(int idx) {
            return this.myWholeHeight - idx * this.STACK_ELEMENT_HEIGHT;
        }

        private void iterateData(List<TreeMap<Long, StackLineData>> data, java.util.function.Consumer<StackLineData> consumer) {
            this.myIdx = this.myLowestIdx;
            while (this.myIdx <= Math.min(this.myHighestIdx, data.size() - 1)) {
                TreeMap<Long, StackLineData> map = data.get(this.myIdx);
                for (Map.Entry<Long, StackLineData> entry : map.entrySet()) {
                    this.myTs = entry.getKey();
                    this.myLineData = entry.getValue();
                    this.x1 = (Integer)this.myToCoordConvertor.convert((Object)this.myTs);
                    this.x2 = (Integer)this.myToCoordConvertor.convert((Object)(this.myTs + this.myLineData.getDuration()));
                    this.y1 = this.lowY(this.myIdx);
                    this.y2 = this.highY(this.myIdx);
                    if (this.y1 < this.myTop && this.y2 < this.myTop) continue;
                    if (this.y1 < this.myTop) {
                        this.y1 = this.myTop;
                    }
                    consumer.accept(this.myLineData);
                }
                ++this.myIdx;
            }
        }

        public void draw(List<TreeMap<Long, StackLineData>> data) {
            this.iterateData(data, lineData -> {
                Color color = (Color)this.myColors.get(lineData.getStringId());
                this.myGraphics.setColor(color);
                int width1 = this.x2 - this.x1;
                this.myGraphics.fillRect(this.x1, this.y1, width1, this.y2 - this.y1);
            });
            this.myGraphics.setColor(this.myBackground);
            this.myGraphics.setStroke(new BasicStroke(1.0f));
            BorderDrawer[] last = new BorderDrawer[1];
            this.iterateData(data, data1 -> {
                BorderDrawer drawer = new BorderDrawer(this.x1, this.x2, this.y1, this.y2);
                if (this.myTs <= this.myDetailsPosition && this.myTs + this.myLineData.getDuration() >= this.myDetailsPosition && this.mySelectedRow != null && this.mySelectedRow == this.myIdx) {
                    last[0] = drawer;
                } else {
                    drawer.draw(this.myGraphics);
                }
            });
            if (last[0] != null) {
                this.myGraphics.setColor(Color.black);
                this.myGraphics.setStroke(new BasicStroke(1.5f));
                last[0].draw(this.myGraphics);
            }
            this.iterateData(data, lineData -> {
                String text;
                if (this.y2 - this.y1 < this.STACK_ELEMENT_HEIGHT) {
                    return;
                }
                int correctedX = Math.max(0, this.x1);
                int correctedWidth = Math.min(this.x2, this.myWidth) - correctedX;
                if (correctedWidth >= this.myMinWidth && (text = this.myStrings.get(lineData.getStringId())) != null) {
                    this.myGraphics.setColor(Color.black);
                    String str = Drawer.cutString(text, correctedWidth - 4, this.myMetrics);
                    this.myGraphics.drawString(str, correctedX + 2, this.y2 - this.myMetrics.getDescent());
                }
            });
        }

        private static String cutString(String text, int max, FontMetrics fm) {
            StringBuilder sb = new StringBuilder();
            int width = 0;
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                int cw = fm.charWidth(c);
                if (width + cw > max) {
                    return sb.toString();
                }
                sb.append(c);
                width += cw;
            }
            return sb.toString();
        }

        private record BorderDrawer(int x1, int x2, int y1, int y2) {
            public void draw(Graphics2D graphics) {
                int width = this.x2 - this.x1;
                if (width > 2) {
                    graphics.drawLine(this.x1, this.y1, this.x1, this.y2);
                    graphics.drawLine(this.x2, this.y1, this.x2, this.y2);
                }
                graphics.drawLine(this.x1, this.y1, this.x2, this.y1);
                graphics.drawLine(this.x1, this.y2, this.x2, this.y2);
            }
        }
    }
}

