/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.interact.tools;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.core.plot.builder.interact.tools.FigureModel;
import org.jetbrains.letsPlot.core.plot.builder.interact.tools.FigureToolsController;
import org.jetbrains.letsPlot.core.plot.builder.interact.tools.ToggleTool;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0006H\u0014J\u001e\u0010\u000f\u001a\u00020\u00072\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011H\u0014R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/interact/tools/DefaultFigureToolsController;", "Lorg/jetbrains/letsPlot/core/plot/builder/interact/tools/FigureToolsController;", "figure", "Lorg/jetbrains/letsPlot/core/plot/builder/interact/tools/FigureModel;", "errorMessageHandler", "Lkotlin/Function1;", "", "", "(Lorg/jetbrains/letsPlot/core/plot/builder/interact/tools/FigureModel;Lkotlin/jvm/functions/Function1;)V", "activateFigureTool", "tool", "Lorg/jetbrains/letsPlot/core/plot/builder/interact/tools/ToggleTool;", "deactivateFigureTool", "showFigureError", "msg", "updateFigureView", "specOverride", "", "", "plot-builder"})
public final class DefaultFigureToolsController
extends FigureToolsController {
    @NotNull
    private final FigureModel figure;
    @NotNull
    private final Function1<String, Unit> errorMessageHandler;

    public DefaultFigureToolsController(@NotNull FigureModel figure, @NotNull Function1<? super String, Unit> errorMessageHandler) {
        Intrinsics.checkNotNullParameter((Object)figure, (String)"figure");
        Intrinsics.checkNotNullParameter(errorMessageHandler, (String)"errorMessageHandler");
        this.figure = figure;
        this.errorMessageHandler = errorMessageHandler;
    }

    @Override
    protected void activateFigureTool(@NotNull ToggleTool tool) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        if (!tool.getActive()) {
            this.figure.activateInteractions(tool.getName(), tool.getInteractionSpecList());
        }
    }

    @Override
    protected void deactivateFigureTool(@NotNull ToggleTool tool) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        if (tool.getActive()) {
            this.figure.deactivateInteractions(tool.getName());
        }
    }

    @Override
    protected void updateFigureView(@Nullable Map<String, ? extends Object> specOverride) {
        this.figure.updateView(specOverride);
    }

    @Override
    protected void showFigureError(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.errorMessageHandler.invoke((Object)msg);
    }
}

