//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// The Core Image class that defines a vector object.
    ///
    /// A `CIVector` can store one or more `CGFloat` in one object. They can store a group of float values
    /// for a variety of different uses such as coordinate points, direction vectors, geometric rectangles,
    /// transform matrices, convolution weights, or just a list a parameter values.
    ///
    /// You use `CIVector` objects in conjunction with other Core Image classes, such as ``CIFilter-class``
    /// and ``CIKernel``.  Many of the built-in Core Image filters have one or more `CIVector` inputs that
    /// you can set to affect the filter's behavior.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/civector?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CIVector;
);

unsafe impl Send for CIVector {}

unsafe impl Sync for CIVector {}

extern_conformance!(
    unsafe impl NSCoding for CIVector {}
);

extern_conformance!(
    unsafe impl NSCopying for CIVector {}
);

unsafe impl CopyingHelper for CIVector {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for CIVector {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CIVector {}
);

impl CIVector {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        /// Create a Core Image vector object that is initialized with the specified values.
        /// - Parameters:
        /// - values: The pointer `CGFloat` values to initialize the vector with.
        /// - count: The number of `CGFloats` specified by the `values` parameter.
        /// - Returns:
        /// An autoreleased ``CIVector`` object of length `count`.
        ///
        /// # Safety
        ///
        /// `values` must be a valid pointer.
        #[unsafe(method(vectorWithValues:count:))]
        #[unsafe(method_family = none)]
        pub unsafe fn vectorWithValues_count(
            values: NonNull<CGFloat>,
            count: usize,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Create a Core Image vector object that is initialized with one value.
        /// - Parameters:
        /// - x: The value for the first position in the vector.
        /// - Returns:
        /// An autoreleased ``CIVector`` object of length 1.
        #[unsafe(method(vectorWithX:))]
        #[unsafe(method_family = none)]
        pub unsafe fn vectorWithX(x: CGFloat) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Create a Core Image vector object that is initialized with two values.
        /// - Parameters:
        /// - x: The value for the first position in the vector.
        /// - y: The value for the second position in the vector.
        /// - Returns:
        /// An autoreleased ``CIVector`` object of length 2.
        #[unsafe(method(vectorWithX:Y:))]
        #[unsafe(method_family = none)]
        pub unsafe fn vectorWithX_Y(x: CGFloat, y: CGFloat) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Create a Core Image vector object that is initialized with three values.
        /// - Parameters:
        /// - x: The value for the first position in the vector.
        /// - y: The value for the second position in the vector.
        /// - z: The value for the third position in the vector.
        /// - Returns:
        /// An autoreleased ``CIVector`` object of length 3.
        #[unsafe(method(vectorWithX:Y:Z:))]
        #[unsafe(method_family = none)]
        pub unsafe fn vectorWithX_Y_Z(x: CGFloat, y: CGFloat, z: CGFloat) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Create a Core Image vector object that is initialized with four values.
        /// - Parameters:
        /// - x: The value for the first position in the vector.
        /// - y: The value for the second position in the vector.
        /// - z: The value for the third position in the vector.
        /// - w: The value for the forth position in the vector.
        /// - Returns:
        /// An autoreleased ``CIVector`` object of length 4.
        #[unsafe(method(vectorWithX:Y:Z:W:))]
        #[unsafe(method_family = none)]
        pub unsafe fn vectorWithX_Y_Z_W(
            x: CGFloat,
            y: CGFloat,
            z: CGFloat,
            w: CGFloat,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Create a Core Image vector object that is initialized with two values provided by a `CGPoint` structure.
        ///
        /// The `CGRect` structure’s `y` and `y` values
        /// are stored in the vector’s two values.
        /// - Parameters:
        /// - p: The `CGPoint` structure.
        /// - Returns:
        /// An autoreleased ``CIVector`` object of length 2.
        #[unsafe(method(vectorWithCGPoint:))]
        #[unsafe(method_family = none)]
        pub unsafe fn vectorWithCGPoint(p: CGPoint) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Create a Core Image vector object that is initialized with four values provided by a `CGRect` structure.
        ///
        /// The `CGRect` structure’s `x`, `y`, `height` and `width` values
        /// are stored in the vector’s four values.
        /// - Parameters:
        /// - r: The `CGRect` structure.
        /// - Returns:
        /// An autoreleased ``CIVector`` object of length 4.
        #[unsafe(method(vectorWithCGRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn vectorWithCGRect(r: CGRect) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Create a Core Image vector object that is initialized with six values provided by a `CGAffineTransform` structure.
        ///
        /// The `CGAffineTransform` structure’s `a`, `b`, `c`, `d`, `tx` and `ty` values
        /// are stored in the vector’s six values.
        /// - Parameters:
        /// - t: The `CGAffineTransform` structure.
        /// - Returns:
        /// An autoreleased ``CIVector`` object of length 6.
        #[unsafe(method(vectorWithCGAffineTransform:))]
        #[unsafe(method_family = none)]
        pub unsafe fn vectorWithCGAffineTransform(t: CGAffineTransform) -> Retained<Self>;

        /// Create a Core Image vector object with values provided in a string representation.
        /// - Parameters:
        /// - representation: A string that is in one of the formats returned by the `stringRepresentation` method.
        /// - Returns:
        /// An autoreleased ``CIVector`` object.
        #[unsafe(method(vectorWithString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn vectorWithString(representation: &NSString) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Initialize a Core Image vector object with the specified the values.
        /// - Parameters:
        /// - values: A pointer `CGFloat` values for vector.
        /// - count: The number of `CGFloats` specified by the `values` parameter.
        /// - Returns:
        /// An initialized ``CIVector`` object of length `count`.
        ///
        /// # Safety
        ///
        /// `values` must be a valid pointer.
        #[unsafe(method(initWithValues:count:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithValues_count(
            this: Allocated<Self>,
            values: NonNull<CGFloat>,
            count: usize,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Initialize a Core Image vector object with one value.
        /// - Parameters:
        /// - x: The value for the first position in the vector.
        /// - Returns:
        /// An initialized ``CIVector`` object of length 1.
        #[unsafe(method(initWithX:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithX(this: Allocated<Self>, x: CGFloat) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Initialize a Core Image vector object with two values.
        /// - Parameters:
        /// - x: The value for the first position in the vector.
        /// - y: The value for the second position in the vector.
        /// - Returns:
        /// An initialized ``CIVector`` object of length 2.
        #[unsafe(method(initWithX:Y:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithX_Y(this: Allocated<Self>, x: CGFloat, y: CGFloat) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Initialize a Core Image vector object with three values.
        /// - Parameters:
        /// - x: The value for the first position in the vector.
        /// - y: The value for the second position in the vector.
        /// - z: The value for the third position in the vector.
        /// - Returns:
        /// An initialized ``CIVector`` object of length 3.
        #[unsafe(method(initWithX:Y:Z:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithX_Y_Z(
            this: Allocated<Self>,
            x: CGFloat,
            y: CGFloat,
            z: CGFloat,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Initialize a Core Image vector object with four values.
        /// - Parameters:
        /// - x: The value for the first position in the vector.
        /// - y: The value for the second position in the vector.
        /// - z: The value for the third position in the vector.
        /// - w: The value for the forth position in the vector.
        /// - Returns:
        /// An initialized ``CIVector`` object of length 4.
        #[unsafe(method(initWithX:Y:Z:W:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithX_Y_Z_W(
            this: Allocated<Self>,
            x: CGFloat,
            y: CGFloat,
            z: CGFloat,
            w: CGFloat,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Initialize a Core Image vector object with two values provided by a `CGPoint` structure.
        ///
        /// The `CGRect` structure’s `y` and `y` values
        /// are stored in the vector’s two values.
        /// - Parameters:
        /// - p: The `CGPoint` structure.
        /// - Returns:
        /// An initialized ``CIVector`` object of length 2.
        #[unsafe(method(initWithCGPoint:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCGPoint(this: Allocated<Self>, p: CGPoint) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Initialize a Core Image vector object with four values provided by a `CGRect` structure.
        ///
        /// The `CGRect` structure’s `x`, `y`, `height` and `width` values
        /// are stored in the vector’s four values.
        /// - Parameters:
        /// - r: The `CGRect` structure.
        /// - Returns:
        /// An initialized ``CIVector`` object of length 4.
        #[unsafe(method(initWithCGRect:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCGRect(this: Allocated<Self>, r: CGRect) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Initialize a Core Image vector object with six values provided by a `CGAffineTransform` structure.
        ///
        /// The `CGAffineTransform` structure’s `a`, `b`, `c`, `c`, `tx` and `ty` values
        /// are stored in the vector’s six values.
        /// - Parameters:
        /// - t: The `CGAffineTransform` structure.
        /// - Returns:
        /// An initialized ``CIVector`` object of length 6.
        #[unsafe(method(initWithCGAffineTransform:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCGAffineTransform(
            this: Allocated<Self>,
            t: CGAffineTransform,
        ) -> Retained<Self>;

        /// Initialize a Core Image vector object with values provided in a string representation.
        /// - Parameters:
        /// - representation: A string that is in one of the formats returned by the `stringRepresentation` method.
        /// - Returns:
        /// An initialized ``CIVector`` object.
        #[unsafe(method(initWithString:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithString(
            this: Allocated<Self>,
            representation: &NSString,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Returns a value from a specific position in the vector.
        ///
        /// The numbering of elements in a vector begins with zero.
        /// - Parameters:
        /// - index: The position in the vector of the value that you want to retrieve.
        /// - Returns:
        /// The value retrieved from the vector or `0` if the position is undefined.
        #[unsafe(method(valueAtIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn valueAtIndex(&self, index: usize) -> CGFloat;

        /// The number of items in the vector.
        #[unsafe(method(count))]
        #[unsafe(method_family = none)]
        pub unsafe fn count(&self) -> usize;

        #[cfg(feature = "objc2-core-foundation")]
        /// The value located in the first position in the vector.
        #[unsafe(method(X))]
        #[unsafe(method_family = none)]
        pub unsafe fn X(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// The value located in the second position in the vector.
        #[unsafe(method(Y))]
        #[unsafe(method_family = none)]
        pub unsafe fn Y(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// The value located in the third position in the vector.
        #[unsafe(method(Z))]
        #[unsafe(method_family = none)]
        pub unsafe fn Z(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// The value located in the forth position in the vector.
        #[unsafe(method(W))]
        #[unsafe(method_family = none)]
        pub unsafe fn W(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Returns the values in the vector as a `CGPoint` structure.
        /// - Returns:
        /// Reading this property returns a `CGPoint` structure
        /// from the `X` and `Y` values from the vector.
        #[unsafe(method(CGPointValue))]
        #[unsafe(method_family = none)]
        pub unsafe fn CGPointValue(&self) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        /// Returns the values in the vector as a `CGRect` structure.
        /// - Returns:
        /// Reading this property creates a `CGRect` structure
        /// whose origin is the `X`, `Y`, `Z` and `W` values from the vector.
        #[unsafe(method(CGRectValue))]
        #[unsafe(method_family = none)]
        pub unsafe fn CGRectValue(&self) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        /// Returns the values in the vector as a `CGAffineTransformValue` structure.
        /// - Returns:
        /// Reading this property creates a `CGAffineTransformValue` structure
        /// from the first six values in the vector.
        #[unsafe(method(CGAffineTransformValue))]
        #[unsafe(method_family = none)]
        pub unsafe fn CGAffineTransformValue(&self) -> CGAffineTransform;

        /// Returns a formatted string with all the values of a `CIVector`.
        ///
        /// Some example string representations of vectors:
        ///
        /// `CIVector`                               | `stringRepresentation`
        /// ---------------------------------------- | --------------
        /// `[CIVector vectorWithX:1.0 Y:0.5 Z:0.3]` | `"[1.0 0.5 0.3]"`
        /// `[CIVector vectorWithX:10.0 Y:23.0]`     | `"[10.0 23.0]"`
        ///
        /// To create a ``CIVector`` object from a string representation, use the ``vectorWithString:`` method.
        #[unsafe(method(stringRepresentation))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringRepresentation(&self) -> Retained<NSString>;
    );
}

/// Methods declared on superclass `NSObject`.
impl CIVector {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
