//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;

use crate::*;

/// **************    Read/Write Options    ***************
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsdatareadingoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSDataReadingOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSDataReadingOptions: NSUInteger {
        #[doc(alias = "NSDataReadingMappedIfSafe")]
        const MappedIfSafe = 1<<0;
        #[doc(alias = "NSDataReadingUncached")]
        const Uncached = 1<<1;
        #[doc(alias = "NSDataReadingMappedAlways")]
        const MappedAlways = 1<<3;
        #[doc(alias = "NSDataReadingMapped")]
#[deprecated]
        const Mapped = NSDataReadingOptions::MappedIfSafe.0;
#[deprecated]
        const NSMappedRead = NSDataReadingOptions::Mapped.0;
#[deprecated]
        const NSUncachedRead = NSDataReadingOptions::Uncached.0;
    }
}

unsafe impl Encode for NSDataReadingOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSDataReadingOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsdatawritingoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSDataWritingOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSDataWritingOptions: NSUInteger {
        #[doc(alias = "NSDataWritingAtomic")]
        const Atomic = 1<<0;
        #[doc(alias = "NSDataWritingWithoutOverwriting")]
        const WithoutOverwriting = 1<<1;
        #[doc(alias = "NSDataWritingFileProtectionNone")]
        const FileProtectionNone = 0x10000000;
        #[doc(alias = "NSDataWritingFileProtectionComplete")]
        const FileProtectionComplete = 0x20000000;
        #[doc(alias = "NSDataWritingFileProtectionCompleteUnlessOpen")]
        const FileProtectionCompleteUnlessOpen = 0x30000000;
        #[doc(alias = "NSDataWritingFileProtectionCompleteUntilFirstUserAuthentication")]
        const FileProtectionCompleteUntilFirstUserAuthentication = 0x40000000;
        #[doc(alias = "NSDataWritingFileProtectionCompleteWhenUserInactive")]
        const FileProtectionCompleteWhenUserInactive = 0x50000000;
        #[doc(alias = "NSDataWritingFileProtectionMask")]
        const FileProtectionMask = 0xf0000000;
#[deprecated]
        const NSAtomicWrite = NSDataWritingOptions::Atomic.0;
    }
}

unsafe impl Encode for NSDataWritingOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSDataWritingOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// **************    Data Search Options    ***************
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsdatasearchoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSDataSearchOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSDataSearchOptions: NSUInteger {
        #[doc(alias = "NSDataSearchBackwards")]
        const Backwards = 1<<0;
        #[doc(alias = "NSDataSearchAnchored")]
        const Anchored = 1<<1;
    }
}

unsafe impl Encode for NSDataSearchOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSDataSearchOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// **************        Base 64 Options    ***************
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsdatabase64encodingoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSDataBase64EncodingOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSDataBase64EncodingOptions: NSUInteger {
        #[doc(alias = "NSDataBase64Encoding64CharacterLineLength")]
        const Encoding64CharacterLineLength = 1<<0;
        #[doc(alias = "NSDataBase64Encoding76CharacterLineLength")]
        const Encoding76CharacterLineLength = 1<<1;
        #[doc(alias = "NSDataBase64EncodingEndLineWithCarriageReturn")]
        const EncodingEndLineWithCarriageReturn = 1<<4;
        #[doc(alias = "NSDataBase64EncodingEndLineWithLineFeed")]
        const EncodingEndLineWithLineFeed = 1<<5;
    }
}

unsafe impl Encode for NSDataBase64EncodingOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSDataBase64EncodingOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsdatabase64decodingoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSDataBase64DecodingOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSDataBase64DecodingOptions: NSUInteger {
        #[doc(alias = "NSDataBase64DecodingIgnoreUnknownCharacters")]
        const IgnoreUnknownCharacters = 1<<0;
    }
}

unsafe impl Encode for NSDataBase64DecodingOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSDataBase64DecodingOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// **************    Immutable Data        ***************
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsdata?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(PartialEq, Eq, Hash)]
    pub struct NSData;
);

#[cfg(feature = "objc2-core-foundation")]
impl AsRef<NSData> for CFData {
    #[inline]
    fn as_ref(&self) -> &NSData {
        unsafe { &*((self as *const Self).cast()) }
    }
}

#[cfg(feature = "objc2-core-foundation")]
impl AsRef<CFData> for NSData {
    #[inline]
    fn as_ref(&self) -> &CFData {
        unsafe { &*((self as *const Self).cast()) }
    }
}

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCoding for NSData {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCopying for NSData {}
);

#[cfg(feature = "NSObject")]
unsafe impl CopyingHelper for NSData {
    type Result = Self;
}

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSMutableCopying for NSData {}
);

#[cfg(feature = "NSObject")]
unsafe impl MutableCopyingHelper for NSData {
    type Result = NSMutableData;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSData {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSSecureCoding for NSData {}
);

impl NSData {
    extern_methods!(
        #[unsafe(method(length))]
        #[unsafe(method_family = none)]
        pub fn length(&self) -> NSUInteger;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSData {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSData {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

/// NSExtendedData.
impl NSData {
    extern_methods!(
        #[cfg(feature = "NSString")]
        #[unsafe(method(description))]
        #[unsafe(method_family = none)]
        pub fn description(&self) -> Retained<NSString>;

        /// # Safety
        ///
        /// `buffer` must be a valid pointer.
        #[unsafe(method(getBytes:length:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getBytes_length(&self, buffer: NonNull<c_void>, length: NSUInteger);

        #[cfg(feature = "NSRange")]
        /// # Safety
        ///
        /// `buffer` must be a valid pointer.
        #[unsafe(method(getBytes:range:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getBytes_range(&self, buffer: NonNull<c_void>, range: NSRange);

        #[unsafe(method(isEqualToData:))]
        #[unsafe(method_family = none)]
        pub fn isEqualToData(&self, other: &NSData) -> bool;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(subdataWithRange:))]
        #[unsafe(method_family = none)]
        pub fn subdataWithRange(&self, range: NSRange) -> Retained<NSData>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(writeToFile:atomically:))]
        #[unsafe(method_family = none)]
        pub fn writeToFile_atomically(&self, path: &NSString, use_auxiliary_file: bool) -> bool;

        #[cfg(feature = "NSURL")]
        #[unsafe(method(writeToURL:atomically:))]
        #[unsafe(method_family = none)]
        pub fn writeToURL_atomically(&self, url: &NSURL, atomically: bool) -> bool;

        #[cfg(all(feature = "NSError", feature = "NSString"))]
        #[unsafe(method(writeToFile:options:error:_))]
        #[unsafe(method_family = none)]
        pub fn writeToFile_options_error(
            &self,
            path: &NSString,
            write_options_mask: NSDataWritingOptions,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(writeToURL:options:error:_))]
        #[unsafe(method_family = none)]
        pub fn writeToURL_options_error(
            &self,
            url: &NSURL,
            write_options_mask: NSDataWritingOptions,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(rangeOfData:options:range:))]
        #[unsafe(method_family = none)]
        pub fn rangeOfData_options_range(
            &self,
            data_to_find: &NSData,
            mask: NSDataSearchOptions,
            search_range: NSRange,
        ) -> NSRange;

        #[cfg(all(feature = "NSRange", feature = "block2"))]
        #[unsafe(method(enumerateByteRangesUsingBlock:))]
        #[unsafe(method_family = none)]
        pub fn enumerateByteRangesUsingBlock(
            &self,
            block: &block2::DynBlock<dyn Fn(NonNull<c_void>, NSRange, NonNull<Bool>) + '_>,
        );
    );
}

/// NSDataCreation.
impl NSData {
    extern_methods!(
        #[unsafe(method(data))]
        #[unsafe(method_family = none)]
        pub fn data() -> Retained<Self>;

        /// # Safety
        ///
        /// `bytes` must be a valid pointer or null.
        #[unsafe(method(dataWithBytes:length:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataWithBytes_length(
            bytes: *const c_void,
            length: NSUInteger,
        ) -> Retained<Self>;

        /// # Safety
        ///
        /// `bytes` must be a valid pointer.
        #[unsafe(method(dataWithBytesNoCopy:length:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataWithBytesNoCopy_length(
            bytes: NonNull<c_void>,
            length: NSUInteger,
        ) -> Retained<Self>;

        /// # Safety
        ///
        /// `bytes` must be a valid pointer.
        #[unsafe(method(dataWithBytesNoCopy:length:freeWhenDone:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataWithBytesNoCopy_length_freeWhenDone(
            bytes: NonNull<c_void>,
            length: NSUInteger,
            b: bool,
        ) -> Retained<Self>;

        #[cfg(all(feature = "NSError", feature = "NSString"))]
        #[unsafe(method(dataWithContentsOfFile:options:error:_))]
        #[unsafe(method_family = none)]
        pub fn dataWithContentsOfFile_options_error(
            path: &NSString,
            read_options_mask: NSDataReadingOptions,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(dataWithContentsOfURL:options:error:_))]
        #[unsafe(method_family = none)]
        pub fn dataWithContentsOfURL_options_error(
            url: &NSURL,
            read_options_mask: NSDataReadingOptions,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(dataWithContentsOfFile:))]
        #[unsafe(method_family = none)]
        pub fn dataWithContentsOfFile(path: &NSString) -> Option<Retained<Self>>;

        #[cfg(feature = "NSURL")]
        #[unsafe(method(dataWithContentsOfURL:))]
        #[unsafe(method_family = none)]
        pub fn dataWithContentsOfURL(url: &NSURL) -> Option<Retained<Self>>;

        /// # Safety
        ///
        /// `bytes` must be a valid pointer or null.
        #[unsafe(method(initWithBytes:length:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithBytes_length(
            this: Allocated<Self>,
            bytes: *const c_void,
            length: NSUInteger,
        ) -> Retained<Self>;

        /// # Safety
        ///
        /// `bytes` must be a valid pointer.
        #[unsafe(method(initWithBytesNoCopy:length:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithBytesNoCopy_length(
            this: Allocated<Self>,
            bytes: NonNull<c_void>,
            length: NSUInteger,
        ) -> Retained<Self>;

        /// # Safety
        ///
        /// `bytes` must be a valid pointer.
        #[unsafe(method(initWithBytesNoCopy:length:freeWhenDone:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithBytesNoCopy_length_freeWhenDone(
            this: Allocated<Self>,
            bytes: NonNull<c_void>,
            length: NSUInteger,
            b: bool,
        ) -> Retained<Self>;

        #[cfg(feature = "block2")]
        /// # Safety
        ///
        /// `bytes` must be a valid pointer.
        #[unsafe(method(initWithBytesNoCopy:length:deallocator:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithBytesNoCopy_length_deallocator(
            this: Allocated<Self>,
            bytes: NonNull<c_void>,
            length: NSUInteger,
            deallocator: Option<&block2::DynBlock<dyn Fn(NonNull<c_void>, NSUInteger)>>,
        ) -> Retained<Self>;

        #[cfg(all(feature = "NSError", feature = "NSString"))]
        #[unsafe(method(initWithContentsOfFile:options:error:_))]
        #[unsafe(method_family = init)]
        pub fn initWithContentsOfFile_options_error(
            this: Allocated<Self>,
            path: &NSString,
            read_options_mask: NSDataReadingOptions,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(initWithContentsOfURL:options:error:_))]
        #[unsafe(method_family = init)]
        pub fn initWithContentsOfURL_options_error(
            this: Allocated<Self>,
            url: &NSURL,
            read_options_mask: NSDataReadingOptions,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(initWithContentsOfFile:))]
        #[unsafe(method_family = init)]
        pub fn initWithContentsOfFile(
            this: Allocated<Self>,
            path: &NSString,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSURL")]
        #[unsafe(method(initWithContentsOfURL:))]
        #[unsafe(method_family = init)]
        pub fn initWithContentsOfURL(this: Allocated<Self>, url: &NSURL) -> Option<Retained<Self>>;

        #[unsafe(method(initWithData:))]
        #[unsafe(method_family = init)]
        pub fn initWithData(this: Allocated<Self>, data: &NSData) -> Retained<Self>;

        #[unsafe(method(dataWithData:))]
        #[unsafe(method_family = none)]
        pub fn dataWithData(data: &NSData) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSData`.
///
/// NSDataCreation.
impl NSMutableData {
    extern_methods!(
        #[unsafe(method(data))]
        #[unsafe(method_family = none)]
        pub fn data() -> Retained<Self>;

        /// # Safety
        ///
        /// `bytes` must be a valid pointer or null.
        #[unsafe(method(dataWithBytes:length:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataWithBytes_length(
            bytes: *const c_void,
            length: NSUInteger,
        ) -> Retained<Self>;

        /// # Safety
        ///
        /// `bytes` must be a valid pointer.
        #[unsafe(method(dataWithBytesNoCopy:length:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataWithBytesNoCopy_length(
            bytes: NonNull<c_void>,
            length: NSUInteger,
        ) -> Retained<Self>;

        /// # Safety
        ///
        /// `bytes` must be a valid pointer.
        #[unsafe(method(dataWithBytesNoCopy:length:freeWhenDone:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataWithBytesNoCopy_length_freeWhenDone(
            bytes: NonNull<c_void>,
            length: NSUInteger,
            b: bool,
        ) -> Retained<Self>;

        #[cfg(all(feature = "NSError", feature = "NSString"))]
        #[unsafe(method(dataWithContentsOfFile:options:error:_))]
        #[unsafe(method_family = none)]
        pub fn dataWithContentsOfFile_options_error(
            path: &NSString,
            read_options_mask: NSDataReadingOptions,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(dataWithContentsOfURL:options:error:_))]
        #[unsafe(method_family = none)]
        pub fn dataWithContentsOfURL_options_error(
            url: &NSURL,
            read_options_mask: NSDataReadingOptions,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(dataWithContentsOfFile:))]
        #[unsafe(method_family = none)]
        pub fn dataWithContentsOfFile(path: &NSString) -> Option<Retained<Self>>;

        #[cfg(feature = "NSURL")]
        #[unsafe(method(dataWithContentsOfURL:))]
        #[unsafe(method_family = none)]
        pub fn dataWithContentsOfURL(url: &NSURL) -> Option<Retained<Self>>;

        /// # Safety
        ///
        /// `bytes` must be a valid pointer or null.
        #[unsafe(method(initWithBytes:length:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithBytes_length(
            this: Allocated<Self>,
            bytes: *const c_void,
            length: NSUInteger,
        ) -> Retained<Self>;

        /// # Safety
        ///
        /// `bytes` must be a valid pointer.
        #[unsafe(method(initWithBytesNoCopy:length:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithBytesNoCopy_length(
            this: Allocated<Self>,
            bytes: NonNull<c_void>,
            length: NSUInteger,
        ) -> Retained<Self>;

        /// # Safety
        ///
        /// `bytes` must be a valid pointer.
        #[unsafe(method(initWithBytesNoCopy:length:freeWhenDone:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithBytesNoCopy_length_freeWhenDone(
            this: Allocated<Self>,
            bytes: NonNull<c_void>,
            length: NSUInteger,
            b: bool,
        ) -> Retained<Self>;

        #[cfg(feature = "block2")]
        /// # Safety
        ///
        /// `bytes` must be a valid pointer.
        #[unsafe(method(initWithBytesNoCopy:length:deallocator:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithBytesNoCopy_length_deallocator(
            this: Allocated<Self>,
            bytes: NonNull<c_void>,
            length: NSUInteger,
            deallocator: Option<&block2::DynBlock<dyn Fn(NonNull<c_void>, NSUInteger)>>,
        ) -> Retained<Self>;

        #[cfg(all(feature = "NSError", feature = "NSString"))]
        #[unsafe(method(initWithContentsOfFile:options:error:_))]
        #[unsafe(method_family = init)]
        pub fn initWithContentsOfFile_options_error(
            this: Allocated<Self>,
            path: &NSString,
            read_options_mask: NSDataReadingOptions,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(initWithContentsOfURL:options:error:_))]
        #[unsafe(method_family = init)]
        pub fn initWithContentsOfURL_options_error(
            this: Allocated<Self>,
            url: &NSURL,
            read_options_mask: NSDataReadingOptions,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(initWithContentsOfFile:))]
        #[unsafe(method_family = init)]
        pub fn initWithContentsOfFile(
            this: Allocated<Self>,
            path: &NSString,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSURL")]
        #[unsafe(method(initWithContentsOfURL:))]
        #[unsafe(method_family = init)]
        pub fn initWithContentsOfURL(this: Allocated<Self>, url: &NSURL) -> Option<Retained<Self>>;

        #[unsafe(method(initWithData:))]
        #[unsafe(method_family = init)]
        pub fn initWithData(this: Allocated<Self>, data: &NSData) -> Retained<Self>;

        #[unsafe(method(dataWithData:))]
        #[unsafe(method_family = none)]
        pub fn dataWithData(data: &NSData) -> Retained<Self>;
    );
}

/// NSDataBase64Encoding.
impl NSData {
    extern_methods!(
        #[cfg(feature = "NSString")]
        #[unsafe(method(initWithBase64EncodedString:options:))]
        #[unsafe(method_family = init)]
        pub fn initWithBase64EncodedString_options(
            this: Allocated<Self>,
            base64_string: &NSString,
            options: NSDataBase64DecodingOptions,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(base64EncodedStringWithOptions:))]
        #[unsafe(method_family = none)]
        pub fn base64EncodedStringWithOptions(
            &self,
            options: NSDataBase64EncodingOptions,
        ) -> Retained<NSString>;

        #[unsafe(method(initWithBase64EncodedData:options:))]
        #[unsafe(method_family = init)]
        pub fn initWithBase64EncodedData_options(
            this: Allocated<Self>,
            base64_data: &NSData,
            options: NSDataBase64DecodingOptions,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(base64EncodedDataWithOptions:))]
        #[unsafe(method_family = none)]
        pub fn base64EncodedDataWithOptions(
            &self,
            options: NSDataBase64EncodingOptions,
        ) -> Retained<NSData>;
    );
}

/// Methods declared on superclass `NSData`.
///
/// NSDataBase64Encoding.
impl NSMutableData {
    extern_methods!(
        #[cfg(feature = "NSString")]
        #[unsafe(method(initWithBase64EncodedString:options:))]
        #[unsafe(method_family = init)]
        pub fn initWithBase64EncodedString_options(
            this: Allocated<Self>,
            base64_string: &NSString,
            options: NSDataBase64DecodingOptions,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(initWithBase64EncodedData:options:))]
        #[unsafe(method_family = init)]
        pub fn initWithBase64EncodedData_options(
            this: Allocated<Self>,
            base64_data: &NSData,
            options: NSDataBase64DecodingOptions,
        ) -> Option<Retained<Self>>;
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsdatacompressionalgorithm?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSDataCompressionAlgorithm(pub NSInteger);
impl NSDataCompressionAlgorithm {
    #[doc(alias = "NSDataCompressionAlgorithmLZFSE")]
    pub const LZFSE: Self = Self(0);
    #[doc(alias = "NSDataCompressionAlgorithmLZ4")]
    pub const LZ4: Self = Self(1);
    #[doc(alias = "NSDataCompressionAlgorithmLZMA")]
    pub const LZMA: Self = Self(2);
    #[doc(alias = "NSDataCompressionAlgorithmZlib")]
    pub const Zlib: Self = Self(3);
}

unsafe impl Encode for NSDataCompressionAlgorithm {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSDataCompressionAlgorithm {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// NSDataCompression.
impl NSData {
    extern_methods!(
        #[cfg(feature = "NSError")]
        #[unsafe(method(decompressedDataUsingAlgorithm:error:_))]
        #[unsafe(method_family = none)]
        pub fn decompressedDataUsingAlgorithm_error(
            &self,
            algorithm: NSDataCompressionAlgorithm,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(feature = "NSError")]
        #[unsafe(method(compressedDataUsingAlgorithm:error:_))]
        #[unsafe(method_family = none)]
        pub fn compressedDataUsingAlgorithm_error(
            &self,
            algorithm: NSDataCompressionAlgorithm,
        ) -> Result<Retained<Self>, Retained<NSError>>;
    );
}

/// NSDeprecated.
impl NSData {
    extern_methods!(
        /// # Safety
        ///
        /// `buffer` must be a valid pointer.
        #[deprecated = "This method is unsafe because it could potentially cause buffer overruns. Use -getBytes:length: instead."]
        #[unsafe(method(getBytes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getBytes(&self, buffer: NonNull<c_void>);

        #[cfg(feature = "NSString")]
        #[deprecated = "Use +dataWithContentsOfURL:options:error: and NSDataReadingMappedIfSafe or NSDataReadingMappedAlways instead."]
        #[unsafe(method(dataWithContentsOfMappedFile:))]
        #[unsafe(method_family = none)]
        pub fn dataWithContentsOfMappedFile(path: &NSString) -> Option<Retained<AnyObject>>;

        #[cfg(feature = "NSString")]
        #[deprecated = "Use -initWithContentsOfURL:options:error: and NSDataReadingMappedIfSafe or NSDataReadingMappedAlways instead."]
        #[unsafe(method(initWithContentsOfMappedFile:))]
        #[unsafe(method_family = init)]
        pub fn initWithContentsOfMappedFile(
            this: Allocated<Self>,
            path: &NSString,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSString")]
        #[deprecated = "Use initWithBase64EncodedString:options: instead"]
        #[unsafe(method(initWithBase64Encoding:))]
        #[unsafe(method_family = init)]
        pub fn initWithBase64Encoding(
            this: Allocated<Self>,
            base64_string: &NSString,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSString")]
        #[deprecated = "Use base64EncodedStringWithOptions: instead"]
        #[unsafe(method(base64Encoding))]
        #[unsafe(method_family = none)]
        pub fn base64Encoding(&self) -> Retained<NSString>;
    );
}

/// Methods declared on superclass `NSData`.
///
/// NSDeprecated.
impl NSMutableData {
    extern_methods!(
        #[cfg(feature = "NSString")]
        #[deprecated = "Use -initWithContentsOfURL:options:error: and NSDataReadingMappedIfSafe or NSDataReadingMappedAlways instead."]
        #[unsafe(method(initWithContentsOfMappedFile:))]
        #[unsafe(method_family = init)]
        pub fn initWithContentsOfMappedFile(
            this: Allocated<Self>,
            path: &NSString,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSString")]
        #[deprecated = "Use initWithBase64EncodedString:options: instead"]
        #[unsafe(method(initWithBase64Encoding:))]
        #[unsafe(method_family = init)]
        pub fn initWithBase64Encoding(
            this: Allocated<Self>,
            base64_string: &NSString,
        ) -> Option<Retained<Self>>;
    );
}

extern_class!(
    /// **************    Mutable Data        ***************
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsmutabledata?language=objc)
    #[unsafe(super(NSData, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSMutableData;
);

#[cfg(feature = "objc2-core-foundation")]
impl AsRef<NSMutableData> for CFMutableData {
    #[inline]
    fn as_ref(&self) -> &NSMutableData {
        unsafe { &*((self as *const Self).cast()) }
    }
}

#[cfg(feature = "objc2-core-foundation")]
impl AsRef<CFMutableData> for NSMutableData {
    #[inline]
    fn as_ref(&self) -> &CFMutableData {
        unsafe { &*((self as *const Self).cast()) }
    }
}

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCoding for NSMutableData {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCopying for NSMutableData {}
);

#[cfg(feature = "NSObject")]
unsafe impl CopyingHelper for NSMutableData {
    type Result = NSData;
}

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSMutableCopying for NSMutableData {}
);

#[cfg(feature = "NSObject")]
unsafe impl MutableCopyingHelper for NSMutableData {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSMutableData {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSSecureCoding for NSMutableData {}
);

impl NSMutableData {
    extern_methods!(
        /// Setter for [`length`][Self::length].
        #[unsafe(method(setLength:))]
        #[unsafe(method_family = none)]
        pub fn setLength(&self, length: NSUInteger);
    );
}

/// Methods declared on superclass `NSObject`.
impl NSMutableData {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSMutableData {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

/// NSExtendedMutableData.
impl NSMutableData {
    extern_methods!(
        /// # Safety
        ///
        /// `bytes` must be a valid pointer.
        #[unsafe(method(appendBytes:length:))]
        #[unsafe(method_family = none)]
        pub unsafe fn appendBytes_length(&self, bytes: NonNull<c_void>, length: NSUInteger);

        #[unsafe(method(appendData:))]
        #[unsafe(method_family = none)]
        pub fn appendData(&self, other: &NSData);

        #[unsafe(method(increaseLengthBy:))]
        #[unsafe(method_family = none)]
        pub fn increaseLengthBy(&self, extra_length: NSUInteger);

        #[cfg(feature = "NSRange")]
        /// # Safety
        ///
        /// `bytes` must be a valid pointer.
        #[unsafe(method(replaceBytesInRange:withBytes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn replaceBytesInRange_withBytes(&self, range: NSRange, bytes: NonNull<c_void>);

        #[cfg(feature = "NSRange")]
        #[unsafe(method(resetBytesInRange:))]
        #[unsafe(method_family = none)]
        pub fn resetBytesInRange(&self, range: NSRange);

        #[unsafe(method(setData:))]
        #[unsafe(method_family = none)]
        pub fn setData(&self, data: &NSData);

        #[cfg(feature = "NSRange")]
        /// # Safety
        ///
        /// `replacement_bytes` must be a valid pointer or null.
        #[unsafe(method(replaceBytesInRange:withBytes:length:))]
        #[unsafe(method_family = none)]
        pub unsafe fn replaceBytesInRange_withBytes_length(
            &self,
            range: NSRange,
            replacement_bytes: *const c_void,
            replacement_length: NSUInteger,
        );
    );
}

/// NSMutableDataCreation.
impl NSMutableData {
    extern_methods!(
        #[unsafe(method(dataWithCapacity:))]
        #[unsafe(method_family = none)]
        pub fn dataWithCapacity(a_num_items: NSUInteger) -> Option<Retained<Self>>;

        #[unsafe(method(dataWithLength:))]
        #[unsafe(method_family = none)]
        pub fn dataWithLength(length: NSUInteger) -> Option<Retained<Self>>;

        #[unsafe(method(initWithCapacity:))]
        #[unsafe(method_family = init)]
        pub fn initWithCapacity(
            this: Allocated<Self>,
            capacity: NSUInteger,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(initWithLength:))]
        #[unsafe(method_family = init)]
        pub fn initWithLength(this: Allocated<Self>, length: NSUInteger) -> Option<Retained<Self>>;
    );
}

/// NSMutableDataCompression.
impl NSMutableData {
    extern_methods!(
        #[cfg(feature = "NSError")]
        #[unsafe(method(decompressUsingAlgorithm:error:_))]
        #[unsafe(method_family = none)]
        pub fn decompressUsingAlgorithm_error(
            &self,
            algorithm: NSDataCompressionAlgorithm,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(feature = "NSError")]
        #[unsafe(method(compressUsingAlgorithm:error:_))]
        #[unsafe(method_family = none)]
        pub fn compressUsingAlgorithm_error(
            &self,
            algorithm: NSDataCompressionAlgorithm,
        ) -> Result<(), Retained<NSError>>;
    );
}

extern_class!(
    /// **************        Purgeable Data    ***************
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nspurgeabledata?language=objc)
    #[unsafe(super(NSMutableData, NSData, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSPurgeableData;
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCoding for NSPurgeableData {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSDiscardableContent for NSPurgeableData {}
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSPurgeableData {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSSecureCoding for NSPurgeableData {}
);

impl NSPurgeableData {
    extern_methods!();
}

/// Methods declared on superclass `NSObject`.
impl NSPurgeableData {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSPurgeableData {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}
