//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiglasseffectstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIGlassEffectStyle(pub NSInteger);
impl UIGlassEffectStyle {
    /// Standard glass effect style.
    #[doc(alias = "UIGlassEffectStyleRegular")]
    pub const Regular: Self = Self(0);
    /// Clear glass effect style.
    #[doc(alias = "UIGlassEffectStyleClear")]
    pub const Clear: Self = Self(1);
}

unsafe impl Encode for UIGlassEffectStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIGlassEffectStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// A visual effect that renders a glass material.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiglasseffect?language=objc)
    #[unsafe(super(UIVisualEffect, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "UIVisualEffect")]
    pub struct UIGlassEffect;
);

#[cfg(feature = "UIVisualEffect")]
extern_conformance!(
    unsafe impl NSCoding for UIGlassEffect {}
);

#[cfg(feature = "UIVisualEffect")]
extern_conformance!(
    unsafe impl NSCopying for UIGlassEffect {}
);

#[cfg(feature = "UIVisualEffect")]
unsafe impl CopyingHelper for UIGlassEffect {
    type Result = Self;
}

#[cfg(feature = "UIVisualEffect")]
extern_conformance!(
    unsafe impl NSObjectProtocol for UIGlassEffect {}
);

#[cfg(feature = "UIVisualEffect")]
extern_conformance!(
    unsafe impl NSSecureCoding for UIGlassEffect {}
);

#[cfg(feature = "UIVisualEffect")]
impl UIGlassEffect {
    extern_methods!(
        /// Enables interactive behavior for the glass effect.
        #[unsafe(method(isInteractive))]
        #[unsafe(method_family = none)]
        pub fn isInteractive(&self) -> bool;

        /// Setter for [`isInteractive`][Self::isInteractive].
        #[unsafe(method(setInteractive:))]
        #[unsafe(method_family = none)]
        pub fn setInteractive(&self, interactive: bool);

        #[cfg(feature = "UIColor")]
        /// A tint color applied to the glass.
        #[unsafe(method(tintColor))]
        #[unsafe(method_family = none)]
        pub fn tintColor(&self) -> Option<Retained<UIColor>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`tintColor`][Self::tintColor].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setTintColor:))]
        #[unsafe(method_family = none)]
        pub fn setTintColor(&self, tint_color: Option<&UIColor>);

        /// Creates a glass effect with the specified style.
        #[unsafe(method(effectWithStyle:))]
        #[unsafe(method_family = none)]
        pub fn effectWithStyle(
            style: UIGlassEffectStyle,
            mtm: MainThreadMarker,
        ) -> Retained<UIGlassEffect>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "UIVisualEffect")]
impl UIGlassEffect {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// A `UIGlassContainerEffect` renders multiple glass elements into a combined effect.
    ///
    /// When using `UIGlassContainerEffect` with a `UIVisualEffectView` you can
    /// add individual glass elements to the visual effect view's contentView by nesting `UIVisualEffectView`'s
    /// configured with `UIGlassEffect`. In that configuration, the glass container will render all glass elements
    /// in one combined view, behind the visual effect view's `contentView`.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiglasscontainereffect?language=objc)
    #[unsafe(super(UIVisualEffect, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "UIVisualEffect")]
    pub struct UIGlassContainerEffect;
);

#[cfg(feature = "UIVisualEffect")]
extern_conformance!(
    unsafe impl NSCoding for UIGlassContainerEffect {}
);

#[cfg(feature = "UIVisualEffect")]
extern_conformance!(
    unsafe impl NSCopying for UIGlassContainerEffect {}
);

#[cfg(feature = "UIVisualEffect")]
unsafe impl CopyingHelper for UIGlassContainerEffect {
    type Result = Self;
}

#[cfg(feature = "UIVisualEffect")]
extern_conformance!(
    unsafe impl NSObjectProtocol for UIGlassContainerEffect {}
);

#[cfg(feature = "UIVisualEffect")]
extern_conformance!(
    unsafe impl NSSecureCoding for UIGlassContainerEffect {}
);

#[cfg(feature = "UIVisualEffect")]
impl UIGlassContainerEffect {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        /// The spacing specifies the distance between elements at which they begin to merge.
        #[unsafe(method(spacing))]
        #[unsafe(method_family = none)]
        pub fn spacing(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`spacing`][Self::spacing].
        #[unsafe(method(setSpacing:))]
        #[unsafe(method_family = none)]
        pub fn setSpacing(&self, spacing: CGFloat);
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "UIVisualEffect")]
impl UIGlassContainerEffect {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
