//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

extern_class!(
    /// The command system to build or rebuild.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenusystem?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIMenuSystem;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UIMenuSystem {}
);

impl UIMenuSystem {
    extern_methods!(
        /// The main menu system. This is identical to `UIMainMenuSystem.sharedSystem`.
        #[unsafe(method(mainSystem))]
        #[unsafe(method_family = none)]
        pub fn mainSystem(mtm: MainThreadMarker) -> Retained<UIMenuSystem>;

        /// The context menu system. This is identical to `UIContextMenuSystem.sharedSystem`.
        #[unsafe(method(contextSystem))]
        #[unsafe(method_family = none)]
        pub fn contextSystem(mtm: MainThreadMarker) -> Retained<UIMenuSystem>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        /// Trigger a rebuild of this system at a suitable time.
        #[unsafe(method(setNeedsRebuild))]
        #[unsafe(method_family = none)]
        pub fn setNeedsRebuild(&self);

        /// Trigger a revalidate of this system at a suitable time.
        #[unsafe(method(setNeedsRevalidate))]
        #[unsafe(method_family = none)]
        pub fn setNeedsRevalidate(&self);
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenusystemelementgrouppreference?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIMenuSystemElementGroupPreference(pub NSInteger);
impl UIMenuSystemElementGroupPreference {
    /// The default preference. The element group is automatically included based on the platform and other system behaviors.
    #[doc(alias = "UIMenuSystemElementGroupPreferenceAutomatic")]
    pub const Automatic: Self = Self(0);
    /// Prefer that the element group is removed.
    #[doc(alias = "UIMenuSystemElementGroupPreferenceRemoved")]
    pub const Removed: Self = Self(1);
    /// Prefer that the element group is included.
    #[doc(alias = "UIMenuSystemElementGroupPreferenceIncluded")]
    pub const Included: Self = Self(2);
}

unsafe impl Encode for UIMenuSystemElementGroupPreference {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIMenuSystemElementGroupPreference {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl Send for UIMenuSystemElementGroupPreference {}

unsafe impl Sync for UIMenuSystemElementGroupPreference {}

/// Represents a preference for the structure of Find elements in the main menu.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenusystemfindelementgroupconfigurationstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIMenuSystemFindElementGroupConfigurationStyle(pub NSInteger);
impl UIMenuSystemFindElementGroupConfigurationStyle {
    /// The default preference. Find elements are automatically included based on the platform and other system behaviors.
    #[doc(alias = "UIMenuSystemFindElementGroupConfigurationStyleAutomatic")]
    pub const Automatic: Self = Self(0);
    /// Prefer a minimal set of find elements, only consisting of elements to search content in the app.
    #[doc(alias = "UIMenuSystemFindElementGroupConfigurationStyleSearch")]
    pub const Search: Self = Self(1);
    /// Prefer a set of elements for finding within a non-editable text area
    #[doc(alias = "UIMenuSystemFindElementGroupConfigurationStyleNonEditableText")]
    pub const NonEditableText: Self = Self(2);
    /// Prefer a full set of elements for finding and replacing text, such as Find, Find and Replace, Find Navigation, and so on.
    #[doc(alias = "UIMenuSystemFindElementGroupConfigurationStyleEditableText")]
    pub const EditableText: Self = Self(3);
}

unsafe impl Encode for UIMenuSystemFindElementGroupConfigurationStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIMenuSystemFindElementGroupConfigurationStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl Send for UIMenuSystemFindElementGroupConfigurationStyle {}

unsafe impl Sync for UIMenuSystemFindElementGroupConfigurationStyle {}

extern_class!(
    /// Represents a configuration for find elements, should they be present.
    /// You don't create one of these directly. A configuration is provided as part of a `UIMainMenuSystemConfiguration`.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenusystemfindelementgroupconfiguration?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIMenuSystemFindElementGroupConfiguration;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UIMenuSystemFindElementGroupConfiguration {}
);

impl UIMenuSystemFindElementGroupConfiguration {
    extern_methods!(
        /// Specifies a preference for the style of Find elements in the main menu.
        #[unsafe(method(style))]
        #[unsafe(method_family = none)]
        pub fn style(&self) -> UIMenuSystemFindElementGroupConfigurationStyle;

        /// Setter for [`style`][Self::style].
        #[unsafe(method(setStyle:))]
        #[unsafe(method_family = none)]
        pub fn setStyle(&self, style: UIMenuSystemFindElementGroupConfigurationStyle);

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
