/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.util.graph;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import macromedia.asc.util.graph.Edge;
import macromedia.asc.util.graph.Graph;
import macromedia.asc.util.graph.Vertex;

public final class DependencyGraph<T>
extends Graph<String, Object> {
    private Map<String, T> map = new HashMap<String, T>();
    private Map<String, Vertex<String>> vertices = new HashMap<String, Vertex<String>>();

    public void put(String key, T value) {
        this.map.put(key, value);
    }

    public T get(String key) {
        return this.map.get(key);
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public int size() {
        return this.map.size();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public boolean containsVertex(String key) {
        return this.vertices.containsKey(key);
    }

    @Override
    public void addVertex(Vertex<String> v) {
        super.addVertex(v);
        this.vertices.put(v.getWeight(), v);
    }

    public void addDependency(String name, String dep) {
        Vertex<String> tail = null;
        Vertex<String> head = null;
        head = this.vertices.get(name);
        if (head == null) {
            head = new Vertex<String>(name);
            this.addVertex(head);
        }
        if ((tail = this.vertices.get(dep)) == null) {
            tail = new Vertex<String>(dep);
            this.addVertex(tail);
        }
        this.addEdge(new Edge<Object>(tail, head, null));
    }
}

