//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

extern "C" {
    /// This constant can be used with any sizing related
    /// `NSSplitViewController`properties to get the default system behavior.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nssplitviewcontrollerautomaticdimension?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static NSSplitViewControllerAutomaticDimension: CGFloat;
}

extern_class!(
    /// NSSplitViewController is a container view controller that manages side-by-side (horizontal or vertical) children view controllers.
    /// Views are lazily loaded. For instance, adding a collapsed SplitViewItem will not load the associated ViewController's view until it is uncollapsed.
    /// The NSSplitViewController is set as the delegate of its managed NSSplitView. Any overrides of NSSplitViewDelegate methods must call super.
    /// Only the
    /// `-vertical,``-autosaveName,`and divider properties should be manipulated on the managed NSSplitView. Changing other properties (such as delegate, manipulating subviews, holding priorities) will cause an exception to be thrown.
    /// Autolayout must be used with NSSplitViewController to properly control the layout of the child views and the animations of collapses and reveals. e.g., Constraints can be used to setup whether a window should grow/shrink or stay the same size when showing and hiding a sidebar.
    /// NSViewController's methods
    /// `-addChildViewController:,``-insertViewController:atIndex:,`and
    /// `-removeChildViewControllerAtIndex:`can all be used as convience methods to add children; default SplitViewItems will be appropriately created or destroyed.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nssplitviewcontroller?language=objc)
    #[unsafe(super(NSViewController, NSResponder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "NSResponder", feature = "NSViewController"))]
    pub struct NSSplitViewController;
);

#[cfg(all(feature = "NSResponder", feature = "NSViewController"))]
extern_conformance!(
    unsafe impl NSCoding for NSSplitViewController {}
);

#[cfg(all(
    feature = "NSKeyValueBinding",
    feature = "NSResponder",
    feature = "NSViewController"
))]
extern_conformance!(
    unsafe impl NSEditor for NSSplitViewController {}
);

#[cfg(all(feature = "NSResponder", feature = "NSViewController"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSSplitViewController {}
);

#[cfg(all(
    feature = "NSResponder",
    feature = "NSStoryboardSegue",
    feature = "NSViewController"
))]
extern_conformance!(
    unsafe impl NSSeguePerforming for NSSplitViewController {}
);

#[cfg(all(
    feature = "NSResponder",
    feature = "NSSplitView",
    feature = "NSViewController"
))]
extern_conformance!(
    unsafe impl NSSplitViewDelegate for NSSplitViewController {}
);

#[cfg(all(
    feature = "NSResponder",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSViewController"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSSplitViewController {}
);

#[cfg(all(
    feature = "NSResponder",
    feature = "NSUserInterfaceValidation",
    feature = "NSViewController"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceValidations for NSSplitViewController {}
);

#[cfg(all(feature = "NSResponder", feature = "NSViewController"))]
impl NSSplitViewController {
    extern_methods!(
        #[cfg(all(feature = "NSSplitView", feature = "NSView"))]
        /// The split view managed by the SplitViewController. This can be used to customize view properties such as the dividerStyle, vertical, and autosaveName. It is not guaranteed to be the same view as the receivers 'view' property. The default created splitView is vertical with a dividerStyle of
        /// `NSSplitViewDividerStyleThin.`To provide a custom NSSplitView, set the splitView property anytime before self.viewLoaded is YES.
        #[unsafe(method(splitView))]
        #[unsafe(method_family = none)]
        pub unsafe fn splitView(&self) -> Retained<NSSplitView>;

        #[cfg(all(feature = "NSSplitView", feature = "NSView"))]
        /// Setter for [`splitView`][Self::splitView].
        #[unsafe(method(setSplitView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSplitView(&self, split_view: &NSSplitView);

        #[cfg(feature = "NSSplitViewItem")]
        /// The array of SplitViewItems that correspond to the current child view controllers. After a child view controller is added to the receiving splitViewController, a NSSplitViewItem with the default values will be created for it. Once the child is removed, its corresponding splitViewItem will be removed from the splitViewItems array. Setting this will call through to
        /// `-insertSplitViewItem:atIndex`and
        /// `-removeSplitViewItem:`for items that are new or need removal.
        #[unsafe(method(splitViewItems))]
        #[unsafe(method_family = none)]
        pub unsafe fn splitViewItems(&self) -> Retained<NSArray<NSSplitViewItem>>;

        #[cfg(feature = "NSSplitViewItem")]
        /// Setter for [`splitViewItems`][Self::splitViewItems].
        #[unsafe(method(setSplitViewItems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSplitViewItems(&self, split_view_items: &NSArray<NSSplitViewItem>);

        #[cfg(feature = "NSSplitViewItem")]
        /// Adds a SplitViewItem to the end of the SplitViewController. If the receiver's view is loaded and the SplitViewItem is not collapsed, the SplitViewItem's viewController's view will be loaded and added to the splitView. This calls through to -insertSplitViewItem:atIndex:.
        ///
        /// Parameter `splitViewItem`: The SplitViewItem to add. It must have a viewController set by the time it is added or an exception will be thrown. An exception will also be thrown if splitViewItem is nil.
        #[unsafe(method(addSplitViewItem:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addSplitViewItem(&self, split_view_item: &NSSplitViewItem);

        #[cfg(feature = "NSSplitViewItem")]
        /// Adds a SplitViewItem to a given index in the SplitViewController. If the receiver's view is loaded and the SplitViewItem is not collapsed, the SplitViewItem's viewController's view will be loaded and added to the
        /// `splitView.`Subclasses must call through
        /// `-insertSplitViewItem:atIndex:`to add a SplitViewItem.
        ///
        /// Parameter `splitViewItem`: The SplitViewItem to add. It must have a
        /// `viewController`set by the time it is added or an exception will be thrown. An exception will also be thrown if splitViewItem is nil.
        ///
        /// Parameter `index`: The index to add the SplitViewItem at. Will throw an exception if
        /// `index`<
        /// 0 or
        /// `index`>
        /// `splitViewItems.count`
        #[unsafe(method(insertSplitViewItem:atIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn insertSplitViewItem_atIndex(
            &self,
            split_view_item: &NSSplitViewItem,
            index: NSInteger,
        );

        #[cfg(feature = "NSSplitViewItem")]
        /// Removes a SplitViewItem from the receiver. The layout of the
        /// `splitView`will be adjusted for its removal. Subclasses must call through
        /// `-removeSplitViewItem:`to remove a SplitViewItem.
        ///
        /// Parameter `splitViewItem`: The SplitViewItem to remove. An exception will be thrown if
        /// `splitViewItem`is not in the SplitViewController or if it is nil.
        #[unsafe(method(removeSplitViewItem:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeSplitViewItem(&self, split_view_item: &NSSplitViewItem);

        #[cfg(feature = "NSSplitViewItem")]
        /// Returns the corresponding SplitViewItem for a given child ViewController.
        ///
        /// Parameter `viewController`: The ViewController to look up.
        ///
        /// Returns: The corresponding SplitViewItem. Returns nil if
        /// `viewController`is not a child of the SplitViewController.
        #[unsafe(method(splitViewItemForViewController:))]
        #[unsafe(method_family = none)]
        pub unsafe fn splitViewItemForViewController(
            &self,
            view_controller: &NSViewController,
        ) -> Option<Retained<NSSplitViewItem>>;

        #[cfg(feature = "objc2-core-foundation")]
        /// The minimum thickness in the primary axis of split view (width for "vertical", height otherwise) before sidebar items will automatically collapse. If reshown in fullscreen, they will overlay over the other split items.
        /// Auto-collapsed sidebars will automatically uncollapse if the thickness is increased back to or past the minimum thickness.
        /// Defaults to
        /// `NSSplitViewControllerAutomaticDimension,`which will use the effective minimum sizes of the split view item views as described by constraints in the window to determine the minimum size for inline sidebars. Once constraints establishing the minimum size can't be satisfied for all non-collapsed split panes, all sidebars will auto-collapse. When fullscreen, if a sidebar tries to uncollapse in this state, it will overlay.
        #[unsafe(method(minimumThicknessForInlineSidebars))]
        #[unsafe(method_family = none)]
        pub unsafe fn minimumThicknessForInlineSidebars(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`minimumThicknessForInlineSidebars`][Self::minimumThicknessForInlineSidebars].
        #[unsafe(method(setMinimumThicknessForInlineSidebars:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMinimumThicknessForInlineSidebars(
            &self,
            minimum_thickness_for_inline_sidebars: CGFloat,
        );

        #[cfg(feature = "NSUserInterfaceValidation")]
        /// Validates items with an action of `toggleSidebar:` to reflect the status of the sidebar item contained within the receiver.
        #[unsafe(method(validateUserInterfaceItem:))]
        #[unsafe(method_family = none)]
        pub unsafe fn validateUserInterfaceItem(
            &self,
            item: &ProtocolObject<dyn NSValidatedUserInterfaceItem>,
        ) -> bool;

        #[unsafe(method(viewDidLoad))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewDidLoad(&self);

        #[cfg(all(feature = "NSSplitView", feature = "NSView"))]
        #[unsafe(method(splitView:canCollapseSubview:))]
        #[unsafe(method_family = none)]
        pub unsafe fn splitView_canCollapseSubview(
            &self,
            split_view: &NSSplitView,
            subview: &NSView,
        ) -> bool;

        #[cfg(all(feature = "NSSplitView", feature = "NSView"))]
        #[deprecated = "NSSplitView no longer supports collapsing sections via double-click. This delegate method is never called, and NSSplitViewController's implementation always returns NO."]
        #[unsafe(method(splitView:shouldCollapseSubview:forDoubleClickOnDividerAtIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn splitView_shouldCollapseSubview_forDoubleClickOnDividerAtIndex(
            &self,
            split_view: &NSSplitView,
            subview: &NSView,
            divider_index: NSInteger,
        ) -> bool;

        #[cfg(all(feature = "NSSplitView", feature = "NSView"))]
        #[unsafe(method(splitView:shouldHideDividerAtIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn splitView_shouldHideDividerAtIndex(
            &self,
            split_view: &NSSplitView,
            divider_index: NSInteger,
        ) -> bool;

        #[cfg(all(feature = "NSSplitView", feature = "NSView"))]
        #[unsafe(method(splitView:effectiveRect:forDrawnRect:ofDividerAtIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn splitView_effectiveRect_forDrawnRect_ofDividerAtIndex(
            &self,
            split_view: &NSSplitView,
            proposed_effective_rect: NSRect,
            drawn_rect: NSRect,
            divider_index: NSInteger,
        ) -> NSRect;

        #[cfg(all(feature = "NSSplitView", feature = "NSView"))]
        #[unsafe(method(splitView:additionalEffectiveRectOfDividerAtIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn splitView_additionalEffectiveRectOfDividerAtIndex(
            &self,
            split_view: &NSSplitView,
            divider_index: NSInteger,
        ) -> NSRect;
    );
}

/// Methods declared on superclass `NSViewController`.
#[cfg(all(feature = "NSResponder", feature = "NSViewController"))]
impl NSSplitViewController {
    extern_methods!(
        #[cfg(feature = "NSNib")]
        #[unsafe(method(initWithNibName:bundle:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithNibName_bundle(
            this: Allocated<Self>,
            nib_name_or_nil: Option<&NSNibName>,
            nib_bundle_or_nil: Option<&NSBundle>,
        ) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(all(feature = "NSResponder", feature = "NSViewController"))]
impl NSSplitViewController {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "NSResponder", feature = "NSViewController"))]
impl NSSplitViewController {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// NSSplitViewControllerToggleSidebarAction.
#[cfg(all(feature = "NSResponder", feature = "NSViewController"))]
impl NSSplitViewController {
    extern_methods!(
        /// Animatedly collapses or uncollapses the first sidebar split view item in the receiver. Does nothing if the receiver does not contain any sidebars.
        #[unsafe(method(toggleSidebar:))]
        #[unsafe(method_family = none)]
        pub unsafe fn toggleSidebar(&self, sender: Option<&AnyObject>);

        /// Animatedly collapses or uncollapses the first inspector split view item in the receiver. Does nothing if the receiver does not contain any inspectors.
        #[unsafe(method(toggleInspector:))]
        #[unsafe(method_family = none)]
        pub unsafe fn toggleInspector(&self, sender: Option<&AnyObject>);
    );
}
