// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The range of possible hash key values for the shard, which is a set of ordered contiguous positive integers.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct HashKeyRange {
    /// <p>The starting hash key of the hash key range.</p>
    pub starting_hash_key: ::std::string::String,
    /// <p>The ending hash key of the hash key range.</p>
    pub ending_hash_key: ::std::string::String,
}
impl HashKeyRange {
    /// <p>The starting hash key of the hash key range.</p>
    pub fn starting_hash_key(&self) -> &str {
        use std::ops::Deref;
        self.starting_hash_key.deref()
    }
    /// <p>The ending hash key of the hash key range.</p>
    pub fn ending_hash_key(&self) -> &str {
        use std::ops::Deref;
        self.ending_hash_key.deref()
    }
}
impl HashKeyRange {
    /// Creates a new builder-style object to manufacture [`HashKeyRange`](crate::types::HashKeyRange).
    pub fn builder() -> crate::types::builders::HashKeyRangeBuilder {
        crate::types::builders::HashKeyRangeBuilder::default()
    }
}

/// A builder for [`HashKeyRange`](crate::types::HashKeyRange).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct HashKeyRangeBuilder {
    pub(crate) starting_hash_key: ::std::option::Option<::std::string::String>,
    pub(crate) ending_hash_key: ::std::option::Option<::std::string::String>,
}
impl HashKeyRangeBuilder {
    /// <p>The starting hash key of the hash key range.</p>
    /// This field is required.
    pub fn starting_hash_key(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.starting_hash_key = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The starting hash key of the hash key range.</p>
    pub fn set_starting_hash_key(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.starting_hash_key = input;
        self
    }
    /// <p>The starting hash key of the hash key range.</p>
    pub fn get_starting_hash_key(&self) -> &::std::option::Option<::std::string::String> {
        &self.starting_hash_key
    }
    /// <p>The ending hash key of the hash key range.</p>
    /// This field is required.
    pub fn ending_hash_key(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.ending_hash_key = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ending hash key of the hash key range.</p>
    pub fn set_ending_hash_key(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.ending_hash_key = input;
        self
    }
    /// <p>The ending hash key of the hash key range.</p>
    pub fn get_ending_hash_key(&self) -> &::std::option::Option<::std::string::String> {
        &self.ending_hash_key
    }
    /// Consumes the builder and constructs a [`HashKeyRange`](crate::types::HashKeyRange).
    /// This method will fail if any of the following fields are not set:
    /// - [`starting_hash_key`](crate::types::builders::HashKeyRangeBuilder::starting_hash_key)
    /// - [`ending_hash_key`](crate::types::builders::HashKeyRangeBuilder::ending_hash_key)
    pub fn build(self) -> ::std::result::Result<crate::types::HashKeyRange, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::HashKeyRange {
            starting_hash_key: self.starting_hash_key.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "starting_hash_key",
                    "starting_hash_key was not specified but it is required when building HashKeyRange",
                )
            })?,
            ending_hash_key: self.ending_hash_key.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "ending_hash_key",
                    "ending_hash_key was not specified but it is required when building HashKeyRange",
                )
            })?,
        })
    }
}
