/*
 * Decompiled with CFR 0.152.
 */
package sun.security.validator;

import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import sun.security.util.Debug;
import sun.security.validator.ValidatorException;
import sun.security.x509.X509CertImpl;

final class EntrustTLSPolicy {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final Set<String> FINGERPRINTS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("73C176434F1BC6D5ADF45B0E76E727287C8DE57616C1E6E6141A2B2CBC7D8E4C", "02ED0EB28C14DA45165C566791700D6451D7FB56F0B2AB1D3B8EB070E56EDFF5", "43DF5774B03E7FEF5FE40D931A7BEDF1BB2E6B42738C4E6D3841103D3AA7F339", "DB3517D1F6732A2D5AB97C533EC70779EE3270A62FB4AC4238372460E6F01E88", "6DC47172E01CBCB0BF62580D895FE2B8AC9AD4F873801E0C10B9C837D21EB177")));
    private static final LocalDate NOVEMBER_11_2024 = LocalDate.of(2024, Month.NOVEMBER, 11);

    static void checkDistrust(X509Certificate[] x509CertificateArray) throws ValidatorException {
        X509Certificate x509Certificate = x509CertificateArray[x509CertificateArray.length - 1];
        String string = EntrustTLSPolicy.fingerprint(x509Certificate);
        if (string == null) {
            throw new ValidatorException("Cannot generate fingerprint for trust anchor of TLS server certificate");
        }
        if (FINGERPRINTS.contains(string)) {
            Date date = x509CertificateArray[0].getNotBefore();
            LocalDate localDate = date.toInstant().atZone(ZoneOffset.UTC).toLocalDate();
            EntrustTLSPolicy.checkNotBefore(localDate, NOVEMBER_11_2024, x509Certificate);
        }
    }

    private static String fingerprint(X509Certificate x509Certificate) {
        return X509CertImpl.getFingerprint("SHA-256", x509Certificate);
    }

    private static void checkNotBefore(LocalDate localDate, LocalDate localDate2, X509Certificate x509Certificate) throws ValidatorException {
        if (localDate.isAfter(localDate2)) {
            throw new ValidatorException("TLS Server certificate issued after " + localDate2 + " and anchored by a distrusted legacy Entrust root CA: " + x509Certificate.getSubjectX500Principal(), ValidatorException.T_UNTRUSTED_CERT, x509Certificate);
        }
    }

    private EntrustTLSPolicy() {
    }
}

