/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.cache.ExplicitTypeAnnotationContainer;
import com.intellij.psi.impl.cache.TypeAnnotationContainer;
import com.intellij.psi.impl.java.stubs.impl.PsiClassStubImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.BitUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class TypeInfo {
    private static final int HAS_TYPE_ANNOTATIONS = 128;
    public static final TypeInfo[] EMPTY_ARRAY = new TypeInfo[0];
    private static final String[] ourIndexFrequentType;
    private static final Object2IntMap<String> ourFrequentTypeIndex;
    private static final int ourTypeLengthMask;
    private static final TypeKind[] ALL_KINDS;
    private static final Map<String, TypeKind> TEXT_TO_KIND;
    @NotNull
    private final TypeKind kind;
    private TypeAnnotationContainer myTypeAnnotations;
    private static final TokenSet PRIMITIVE_TYPES;

    private TypeInfo(@NotNull TypeKind kind) {
        if (kind == null) {
            TypeInfo.$$$reportNull$$$0(0);
        }
        this.kind = kind;
    }

    String text(boolean isShort) {
        return isShort && this.kind.text == null ? "" : this.kind.text;
    }

    public final String text() {
        return this.text(false);
    }

    @NotNull
    public String annotatedText() {
        StringBuilder sb = new StringBuilder();
        this.appendAnnotatedText(this.getTypeAnnotations(), sb);
        String string = sb.toString();
        if (string == null) {
            TypeInfo.$$$reportNull$$$0(1);
        }
        return string;
    }

    void appendAnnotatedText(@NotNull TypeAnnotationContainer container, @NotNull StringBuilder sb) {
        if (container == null) {
            TypeInfo.$$$reportNull$$$0(2);
        }
        if (sb == null) {
            TypeInfo.$$$reportNull$$$0(3);
        }
        container.appendImmediateText(sb);
        sb.append(this.kind.text);
    }

    @NotNull
    public final TypeKind getKind() {
        TypeKind typeKind = this.kind;
        if (typeKind == null) {
            TypeInfo.$$$reportNull$$$0(4);
        }
        return typeKind;
    }

    public int innerDepth( @NotNull SignatureParsing.TypeInfoProvider provider) {
        if (provider == null) {
            TypeInfo.$$$reportNull$$$0(5);
        }
        return 0;
    }

    public boolean isEllipsis() {
        return this.kind == TypeKind.ELLIPSIS;
    }

    public TypeInfo withEllipsis() {
        throw new UnsupportedOperationException();
    }

    public void setTypeAnnotations(@NotNull TypeAnnotationContainer typeAnnotations) {
        if (typeAnnotations == null) {
            TypeInfo.$$$reportNull$$$0(6);
        }
        if (this == SimpleTypeInfo.NULL) {
            return;
        }
        if (this.myTypeAnnotations != null) {
            throw new IllegalStateException();
        }
        this.myTypeAnnotations = typeAnnotations;
    }

    @NotNull
    public TypeAnnotationContainer getTypeAnnotations() {
        TypeAnnotationContainer typeAnnotationContainer = this.myTypeAnnotations == null ? TypeAnnotationContainer.EMPTY : this.myTypeAnnotations;
        if (typeAnnotationContainer == null) {
            TypeInfo.$$$reportNull$$$0(7);
        }
        return typeAnnotationContainer;
    }

    @NotNull
    public String getShortTypeText() {
        String string = this.text(true);
        if (string == null) {
            TypeInfo.$$$reportNull$$$0(8);
        }
        return string;
    }

    public String toString() {
        String text = this.text();
        return text != null ? text : "null";
    }

    @NotNull
    public static TypeInfo createConstructorType() {
        SimpleTypeInfo simpleTypeInfo = SimpleTypeInfo.NULL;
        if (simpleTypeInfo == null) {
            TypeInfo.$$$reportNull$$$0(9);
        }
        return simpleTypeInfo;
    }

    @NotNull
    public static TypeInfo create(@NotNull LighterAST tree, @NotNull LighterASTNode element, StubElement<?> parentStub) {
        if (tree == null) {
            TypeInfo.$$$reportNull$$$0(10);
        }
        if (element == null) {
            TypeInfo.$$$reportNull$$$0(11);
        }
        int arrayCount = 0;
        LighterASTNode typeElement = null;
        if (element.getTokenType() == JavaElementType.ENUM_CONSTANT) {
            TypeInfo typeInfo = ((PsiClassStubImpl)parentStub).getQualifiedNameTypeInfo();
            if (typeInfo == null) {
                TypeInfo.$$$reportNull$$$0(12);
            }
            return typeInfo;
        }
        for (LighterASTNode child : tree.getChildren(element)) {
            IElementType type = child.getTokenType();
            if (type == JavaElementType.TYPE) {
                typeElement = child;
                continue;
            }
            if (type != JavaTokenType.LBRACKET) continue;
            ++arrayCount;
        }
        if (typeElement == null && element.getTokenType() == JavaElementType.FIELD) {
            LighterASTNode parent = tree.getParent(element);
            assert (parent != null) : element;
            List fields = LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)parent, (IElementType)JavaElementType.FIELD);
            int idx = fields.indexOf(element);
            for (int i = idx - 1; i >= 0 && typeElement == null; --i) {
                typeElement = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)((LighterASTNode)fields.get(i)), (IElementType)JavaElementType.TYPE);
            }
        }
        assert (typeElement != null) : element + " in " + parentStub;
        TypeInfo typeInfo = TypeInfo.fromTypeElement(tree, typeElement);
        for (int i = 0; i < arrayCount; ++i) {
            typeInfo = typeInfo.arrayOf();
        }
        byte[] prefix = new byte[arrayCount];
        Arrays.fill(prefix, (byte)0);
        ExplicitTypeAnnotationContainer.Collector collector = new ExplicitTypeAnnotationContainer.Collector(typeInfo);
        TypeInfo.collectAnnotations(typeInfo, collector, tree, typeElement, prefix);
        collector.install();
        TypeInfo typeInfo2 = typeInfo;
        if (typeInfo2 == null) {
            TypeInfo.$$$reportNull$$$0(13);
        }
        return typeInfo2;
    }

    private static void collectAnnotations(@NotNull TypeInfo info, @NotNull ExplicitTypeAnnotationContainer.Collector collector, @NotNull LighterAST tree, @NotNull LighterASTNode element, byte @NotNull [] prefix) {
        if (info == null) {
            TypeInfo.$$$reportNull$$$0(14);
        }
        if (collector == null) {
            TypeInfo.$$$reportNull$$$0(15);
        }
        if (tree == null) {
            TypeInfo.$$$reportNull$$$0(16);
        }
        if (element == null) {
            TypeInfo.$$$reportNull$$$0(17);
        }
        if (prefix == null) {
            TypeInfo.$$$reportNull$$$0(18);
        }
        int arrayCount = 0;
        List children = tree.getChildren(element);
        for (LighterASTNode child : children) {
            IElementType tokenType = child.getTokenType();
            if (tokenType != JavaTokenType.LBRACKET) continue;
            ++arrayCount;
        }
        int nestingLevel = 0;
        boolean bound = false;
        for (LighterASTNode child : children) {
            IElementType tokenType = child.getTokenType();
            if (tokenType == JavaTokenType.EXTENDS_KEYWORD || tokenType == JavaTokenType.SUPER_KEYWORD) {
                bound = true;
                continue;
            }
            if (tokenType == JavaElementType.JAVA_CODE_REFERENCE && info instanceof RefTypeInfo) {
                TypeInfo.collectAnnotationsFromReference((RefTypeInfo)info, collector, tree, child, prefix);
                continue;
            }
            if (tokenType == JavaElementType.TYPE && info instanceof DerivedTypeInfo) {
                byte[] newPrefix;
                if (bound) {
                    newPrefix = Arrays.copyOf(prefix, prefix.length + 1);
                    newPrefix[prefix.length] = 2;
                } else {
                    newPrefix = Arrays.copyOf(prefix, prefix.length + arrayCount);
                    Arrays.fill(newPrefix, prefix.length, newPrefix.length, (byte)0);
                }
                TypeInfo.collectAnnotations(((DerivedTypeInfo)info).child(), collector, tree, child, newPrefix);
                continue;
            }
            if (tokenType == JavaTokenType.LBRACKET) {
                ++nestingLevel;
                continue;
            }
            if (tokenType != JavaElementType.ANNOTATION) continue;
            String anno = LightTreeUtil.toFilteredString((LighterAST)tree, (LighterASTNode)child, null);
            byte[] typePath = Arrays.copyOf(prefix, prefix.length + nestingLevel);
            Arrays.fill(typePath, prefix.length, typePath.length, (byte)0);
            collector.add(typePath, anno);
        }
    }

    private static void collectAnnotationsFromReference(@NotNull RefTypeInfo info, @NotNull ExplicitTypeAnnotationContainer.Collector collector, @NotNull LighterAST tree, @NotNull LighterASTNode child, byte @NotNull [] prefix) {
        if (info == null) {
            TypeInfo.$$$reportNull$$$0(19);
        }
        if (tree == null) {
            TypeInfo.$$$reportNull$$$0(20);
        }
        if (child == null) {
            TypeInfo.$$$reportNull$$$0(21);
        }
        if (collector == null) {
            TypeInfo.$$$reportNull$$$0(22);
        }
        if (prefix == null) {
            TypeInfo.$$$reportNull$$$0(23);
        }
        List refChildren = tree.getChildren(child);
        for (LighterASTNode refChild : refChildren) {
            IElementType refTokenType = refChild.getTokenType();
            if (refTokenType == JavaElementType.JAVA_CODE_REFERENCE) {
                RefTypeInfo outerType = info.outerType();
                if (outerType == null) continue;
                byte[] newPrefix = Arrays.copyOf(prefix, prefix.length + 1);
                newPrefix[prefix.length] = 1;
                TypeInfo.collectAnnotationsFromReference(outerType, collector, tree, refChild, newPrefix);
                continue;
            }
            if (refTokenType == JavaElementType.REFERENCE_PARAMETER_LIST) {
                List subTypes = LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)refChild, (IElementType)JavaElementType.TYPE);
                if (subTypes.isEmpty()) continue;
                for (int i = 0; i < subTypes.size(); ++i) {
                    TypeInfo componentInfo = info.genericComponent(i);
                    if (componentInfo == null) continue;
                    byte[] newPrefix = Arrays.copyOf(prefix, prefix.length + 2);
                    newPrefix[prefix.length] = 3;
                    newPrefix[prefix.length + 1] = (byte)i;
                    TypeInfo.collectAnnotations(componentInfo, collector, tree, (LighterASTNode)subTypes.get(i), newPrefix);
                }
                continue;
            }
            if (refTokenType != JavaElementType.ANNOTATION) continue;
            collector.add(prefix, LightTreeUtil.toFilteredString((LighterAST)tree, (LighterASTNode)refChild, null));
        }
    }

    @NotNull
    private static TypeInfo fromTypeElement(@NotNull LighterAST tree, @NotNull LighterASTNode typeElement) {
        if (tree == null) {
            TypeInfo.$$$reportNull$$$0(24);
        }
        if (typeElement == null) {
            TypeInfo.$$$reportNull$$$0(25);
        }
        TypeInfo info = null;
        TypeKind derivedKind = null;
        for (LighterASTNode child : tree.getChildren(typeElement)) {
            IElementType tokenType = child.getTokenType();
            if (PRIMITIVE_TYPES.contains(tokenType)) {
                info = new SimpleTypeInfo(TEXT_TO_KIND.get(((LighterASTTokenNode)child).getText().toString()));
            } else if (tokenType == JavaElementType.TYPE) {
                info = TypeInfo.fromTypeElement(tree, child);
            } else if (tokenType == JavaElementType.DUMMY_ELEMENT) {
                info = TypeInfo.fromString(LightTreeUtil.toFilteredString((LighterAST)tree, (LighterASTNode)child, null));
            } else if (tokenType == JavaElementType.JAVA_CODE_REFERENCE) {
                info = TypeInfo.fromCodeReference(tree, child);
            } else if (tokenType == JavaTokenType.EXTENDS_KEYWORD) {
                derivedKind = TypeKind.EXTENDS;
            } else if (tokenType == JavaTokenType.SUPER_KEYWORD) {
                derivedKind = TypeKind.SUPER;
            } else if (tokenType == JavaTokenType.QUEST) {
                info = new SimpleTypeInfo(TypeKind.WILDCARD);
            }
            if (tokenType == JavaTokenType.LBRACKET) {
                info = ((TypeInfo)Objects.requireNonNull(info)).arrayOf();
                continue;
            }
            if (tokenType != JavaTokenType.ELLIPSIS) continue;
            info = ((TypeInfo)Objects.requireNonNull(info)).arrayOf().withEllipsis();
        }
        if (info == null) {
            throw new IllegalArgumentException("Malformed type: " + LightTreeUtil.toFilteredString((LighterAST)tree, (LighterASTNode)typeElement, null));
        }
        if (derivedKind != null) {
            info = new DerivedTypeInfo(derivedKind, info);
        }
        DerivedTypeInfo derivedTypeInfo = info;
        if (derivedTypeInfo == null) {
            TypeInfo.$$$reportNull$$$0(26);
        }
        return derivedTypeInfo;
    }

    private static RefTypeInfo fromCodeReference(@NotNull LighterAST tree, @NotNull LighterASTNode ref) {
        if (tree == null) {
            TypeInfo.$$$reportNull$$$0(27);
        }
        if (ref == null) {
            TypeInfo.$$$reportNull$$$0(28);
        }
        RefTypeInfo info = null;
        for (LighterASTNode child : tree.getChildren(ref)) {
            IElementType tokenType = child.getTokenType();
            if (tokenType == JavaElementType.JAVA_CODE_REFERENCE) {
                info = TypeInfo.fromCodeReference(tree, child);
                continue;
            }
            if (tokenType == JavaTokenType.IDENTIFIER) {
                String text = ((LighterASTTokenNode)child).getText().toString();
                info = new RefTypeInfo(text, info);
                continue;
            }
            if (tokenType != JavaElementType.REFERENCE_PARAMETER_LIST) continue;
            if (info == null) {
                throw new IllegalArgumentException("Malformed type: " + LightTreeUtil.toFilteredString((LighterAST)tree, (LighterASTNode)ref, null));
            }
            ArrayList<TypeInfo> components = new ArrayList<TypeInfo>();
            for (LighterASTNode component : tree.getChildren(child)) {
                if (component.getTokenType() != JavaElementType.TYPE) continue;
                components.add(TypeInfo.fromTypeElement(tree, component));
            }
            info = info.withComponents(components);
        }
        return info;
    }

    @NotNull
    public DerivedTypeInfo arrayOf() {
        return new DerivedTypeInfo(TypeKind.ARRAY, this);
    }

    @ApiStatus.Internal
    @NotNull
    public static TypeInfo fromString(@Nullable String text) {
        if (text == null) {
            SimpleTypeInfo simpleTypeInfo = SimpleTypeInfo.NULL;
            if (simpleTypeInfo == null) {
                TypeInfo.$$$reportNull$$$0(29);
            }
            return simpleTypeInfo;
        }
        TypeKind kind = TEXT_TO_KIND.get(text);
        if (kind != null) {
            return kind.isReference() ? new RefTypeInfo(text) : new SimpleTypeInfo(kind);
        }
        if (text.startsWith("? extends ")) {
            return new DerivedTypeInfo(TypeKind.EXTENDS, TypeInfo.fromString(text.substring("? extends ".length())));
        }
        if (text.startsWith("? super ")) {
            return new DerivedTypeInfo(TypeKind.SUPER, TypeInfo.fromString(text.substring("? super ".length())));
        }
        if (text.endsWith("[]")) {
            DerivedTypeInfo derivedTypeInfo = TypeInfo.fromString(text.substring(0, text.length() - 2)).arrayOf();
            if (derivedTypeInfo == null) {
                TypeInfo.$$$reportNull$$$0(30);
            }
            return derivedTypeInfo;
        }
        if (text.endsWith("...")) {
            return new DerivedTypeInfo(TypeKind.ELLIPSIS, TypeInfo.fromString(text.substring(0, text.length() - 3)));
        }
        if (text.endsWith(">")) {
            int depth = 1;
            int end = text.length() - 1;
            ArrayList<TypeInfo> components = new ArrayList<TypeInfo>();
            for (int pos = end - 1; pos > 0; --pos) {
                String name;
                RefTypeInfo outer;
                String component;
                char ch = text.charAt(pos);
                if (ch == '>') {
                    ++depth;
                    continue;
                }
                if (ch == ',' && depth == 1) {
                    component = text.substring(pos + 1, end);
                    end = pos;
                    components.add(TypeInfo.fromString(component));
                    continue;
                }
                if (ch != '<' || --depth != 0) continue;
                component = text.substring(pos + 1, end);
                components.add(TypeInfo.fromString(component));
                Collections.reverse(components);
                int prevGeneric = text.lastIndexOf(62, pos);
                if (prevGeneric > 0) {
                    if (text.charAt(prevGeneric + 1) != '.') {
                        throw new IllegalArgumentException("Malformed type: " + text);
                    }
                    outer = (RefTypeInfo)TypeInfo.fromString(text.substring(0, prevGeneric + 1));
                    name = text.substring(prevGeneric + 2, pos);
                } else {
                    name = text.substring(0, pos);
                    outer = null;
                }
                return new RefTypeInfo(name, outer, components.toArray(EMPTY_ARRAY));
            }
            throw new IllegalArgumentException("Malformed type: " + text);
        }
        return new RefTypeInfo(text);
    }

    @NotNull
    public static TypeInfo readTYPE(@NotNull StubInputStream record) throws IOException {
        TypeInfo info;
        if (record == null) {
            TypeInfo.$$$reportNull$$$0(31);
        }
        int flags = record.readByte() & 0xFF;
        boolean hasTypeAnnotations = BitUtil.isSet((int)flags, (int)128);
        int kindOrdinal = BitUtil.clear((int)flags, (int)128);
        if (kindOrdinal >= ALL_KINDS.length) {
            throw new IOException("Unexpected TypeKind: " + flags);
        }
        TypeKind kind = ALL_KINDS[kindOrdinal];
        RefTypeInfo outer = null;
        switch (kind.ordinal()) {
            case 1: {
                info = new RefTypeInfo(Objects.requireNonNull(record.readNameString()));
                break;
            }
            case 14: {
                outer = new RefTypeInfo(Objects.requireNonNull(record.readNameString()));
                info = new RefTypeInfo(Objects.requireNonNull(record.readNameString()), outer);
                break;
            }
            case 13: {
                outer = (RefTypeInfo)TypeInfo.readTYPE(record);
                info = new RefTypeInfo(Objects.requireNonNull(record.readNameString()), outer);
                break;
            }
            case 15: {
                outer = (RefTypeInfo)TypeInfo.readTYPE(record);
            }
            case 2: {
                String name = Objects.requireNonNull(record.readNameString());
                int count = record.readByte();
                TypeInfo[] components = new TypeInfo[count];
                for (int i = 0; i < count; ++i) {
                    components[i] = TypeInfo.readTYPE(record);
                }
                info = new RefTypeInfo(name, outer, components);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                info = new DerivedTypeInfo(kind, TypeInfo.readTYPE(record));
                break;
            }
            default: {
                info = kind.isReference() ? new RefTypeInfo(Objects.requireNonNull(kind.text)) : new SimpleTypeInfo(kind);
            }
        }
        info.setTypeAnnotations(hasTypeAnnotations ? ExplicitTypeAnnotationContainer.readTypeAnnotations(record) : TypeAnnotationContainer.EMPTY);
        TypeInfo typeInfo = info;
        if (typeInfo == null) {
            TypeInfo.$$$reportNull$$$0(32);
        }
        return typeInfo;
    }

    public static void writeTYPE(@NotNull StubOutputStream dataStream, @NotNull TypeInfo typeInfo) throws IOException {
        if (dataStream == null) {
            TypeInfo.$$$reportNull$$$0(33);
        }
        if (typeInfo == null) {
            TypeInfo.$$$reportNull$$$0(34);
        }
        boolean hasTypeAnnotations = typeInfo.myTypeAnnotations instanceof ExplicitTypeAnnotationContainer;
        dataStream.writeByte(typeInfo.kind.ordinal() | (hasTypeAnnotations ? 128 : 0));
        if (typeInfo instanceof DerivedTypeInfo) {
            TypeInfo.writeTYPE(dataStream, ((DerivedTypeInfo)typeInfo).myChild);
        } else if (typeInfo instanceof RefTypeInfo && typeInfo.kind.text == null) {
            if (typeInfo.kind == TypeKind.INNER_SIMPLE) {
                dataStream.writeName(Objects.requireNonNull(((RefTypeInfo)typeInfo).myOuter).myName);
            }
            if (typeInfo.kind == TypeKind.INNER || typeInfo.kind == TypeKind.INNER_GENERIC) {
                TypeInfo.writeTYPE(dataStream, Objects.requireNonNull(((RefTypeInfo)typeInfo).myOuter));
            }
            dataStream.writeName(((RefTypeInfo)typeInfo).myName);
            if (typeInfo.kind == TypeKind.INNER_GENERIC || typeInfo.kind == TypeKind.GENERIC) {
                TypeInfo[] components = ((RefTypeInfo)typeInfo).myComponents;
                dataStream.writeByte(components.length);
                for (TypeInfo component : components) {
                    TypeInfo.writeTYPE(dataStream, component);
                }
            }
        }
        if (hasTypeAnnotations) {
            ExplicitTypeAnnotationContainer.writeTypeAnnotations(dataStream, (ExplicitTypeAnnotationContainer)typeInfo.myTypeAnnotations);
        }
    }

    @NotNull
    public static String internFrequentType(@NotNull String type) {
        if (type == null) {
            TypeInfo.$$$reportNull$$$0(35);
        }
        int frequentIndex = type.length() < 32 && (ourTypeLengthMask & 1 << type.length()) != 0 ? ourFrequentTypeIndex.getInt((Object)type) : 0;
        String string = frequentIndex == 0 ? StringUtil.internEmptyString((String)type) : ourIndexFrequentType[frequentIndex];
        if (string == null) {
            TypeInfo.$$$reportNull$$$0(36);
        }
        return string;
    }

    static {
        int typeLengthMask = 0;
        ourIndexFrequentType = new String[]{"", "boolean", "byte", "char", "double", "float", "int", "long", "null", "short", "void", "java.lang.Object", "java.lang.String"};
        ourFrequentTypeIndex = new Object2IntOpenHashMap();
        for (int i = 0; i < ourIndexFrequentType.length; ++i) {
            String type = ourIndexFrequentType[i];
            ourFrequentTypeIndex.put((Object)type, i);
            assert (type.length() < 32);
            typeLengthMask |= 1 << type.length();
        }
        assert (ourFrequentTypeIndex.size() == ourIndexFrequentType.length);
        ourTypeLengthMask = typeLengthMask;
        ALL_KINDS = TypeKind.values();
        TEXT_TO_KIND = StreamEx.of((Object[])ALL_KINDS).mapToEntry(kind -> ((TypeKind)kind).text, kind -> kind).nonNullKeys().toImmutableMap();
        PRIMITIVE_TYPES = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.INT_KEYWORD, JavaTokenType.CHAR_KEYWORD, JavaTokenType.LONG_KEYWORD, JavaTokenType.DOUBLE_KEYWORD, JavaTokenType.FLOAT_KEYWORD, JavaTokenType.SHORT_KEYWORD, JavaTokenType.BOOLEAN_KEYWORD, JavaTokenType.BYTE_KEYWORD, JavaTokenType.VOID_KEYWORD});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/TypeInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAnnotations";
                break;
            }
            case 10: 
            case 16: 
            case 20: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInfo";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/TypeInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "annotatedText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAnnotations";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortTypeText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructorType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "fromTypeElement";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "fromString";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "readTYPE";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "internFrequentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 36: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendAnnotatedText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "innerDepth";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTypeAnnotations";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectAnnotations";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectAnnotationsFromReference";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fromTypeElement";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "fromCodeReference";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "readTYPE";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "writeTYPE";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "internFrequentType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum TypeKind {
        NULL,
        REF,
        GENERIC,
        JAVA_LANG_OBJECT("java.lang.Object"),
        JAVA_LANG_STRING("java.lang.String"),
        JAVA_LANG_THROWABLE("java.lang.Throwable"),
        JAVA_LANG_EXCEPTION("java.lang.Exception"),
        JAVA_UTIL_COLLECTION("java.util.Collection"),
        JAVA_UTIL_LIST("java.util.List"),
        JAVA_LANG_ITERABLE("java.lang.Iterable"),
        JAVA_UTIL_ITERATOR("java.util.Iterator"),
        JAVA_UTIL_MAP("java.util.Map"),
        JAVA_LANG_ANNOTATION_ANNOTATION("java.lang.annotation.Annotation"),
        INNER,
        INNER_SIMPLE,
        INNER_GENERIC,
        EXTENDS,
        SUPER,
        ARRAY,
        ELLIPSIS,
        BOOLEAN("boolean"),
        BYTE("byte"),
        CHAR("char"),
        DOUBLE("double"),
        FLOAT("float"),
        INT("int"),
        LONG("long"),
        SHORT("short"),
        VOID("void"),
        WILDCARD("?");

        @Nullable
        private final String text;

        private TypeKind() {
            this(null);
        }

        private TypeKind(String text) {
            this.text = text;
        }

        boolean isReference() {
            return this.ordinal() >= REF.ordinal() && this.ordinal() <= INNER_GENERIC.ordinal();
        }

        boolean isDerived() {
            return this.ordinal() >= EXTENDS.ordinal() && this.ordinal() <= ELLIPSIS.ordinal();
        }
    }

    public static final class SimpleTypeInfo
    extends TypeInfo {
        public static final SimpleTypeInfo NULL = new SimpleTypeInfo(TypeKind.NULL);

        public SimpleTypeInfo(@NotNull TypeKind kind) {
            if (kind == null) {
                SimpleTypeInfo.$$$reportNull$$$0(0);
            }
            super(kind);
            if (kind.isDerived() || kind.isReference()) {
                throw new IllegalArgumentException(kind.toString());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/psi/impl/cache/TypeInfo$SimpleTypeInfo", "<init>"));
        }
    }

    public static final class DerivedTypeInfo
    extends TypeInfo {
        private final TypeInfo myChild;

        public DerivedTypeInfo(@NotNull TypeKind kind, @NotNull TypeInfo child) {
            if (kind == null) {
                DerivedTypeInfo.$$$reportNull$$$0(0);
            }
            if (child == null) {
                DerivedTypeInfo.$$$reportNull$$$0(1);
            }
            super(kind);
            assert (kind.isDerived());
            this.myChild = child;
        }

        public TypeInfo child() {
            return this.myChild;
        }

        @Override
        public TypeInfo withEllipsis() {
            switch (this.getKind().ordinal()) {
                case 19: {
                    return this;
                }
                case 18: {
                    return new DerivedTypeInfo(TypeKind.ELLIPSIS, this.myChild);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        String text(boolean isShort) {
            switch (this.getKind().ordinal()) {
                case 16: {
                    return "? extends " + this.myChild.text(isShort);
                }
                case 17: {
                    return "? super " + this.myChild.text(isShort);
                }
                case 18: {
                    return this.myChild.text(isShort) + "[]";
                }
                case 19: {
                    return this.myChild.text(isShort) + "...";
                }
            }
            throw new IllegalStateException();
        }

        @Override
        void appendAnnotatedText(@NotNull TypeAnnotationContainer container, @NotNull StringBuilder sb) {
            if (container == null) {
                DerivedTypeInfo.$$$reportNull$$$0(2);
            }
            if (sb == null) {
                DerivedTypeInfo.$$$reportNull$$$0(3);
            }
            switch (this.getKind().ordinal()) {
                case 16: {
                    container.appendImmediateText(sb);
                    sb.append("? extends ");
                    this.myChild.appendAnnotatedText(container.forBound(), sb);
                    break;
                }
                case 17: {
                    container.appendImmediateText(sb);
                    sb.append("? super ");
                    this.myChild.appendAnnotatedText(container.forBound(), sb);
                    break;
                }
                case 18: {
                    int arrayCount = 1;
                    TypeAnnotationContainer curContainer = container.forArrayElement();
                    TypeInfo child = this.myChild;
                    while (child instanceof DerivedTypeInfo && child.getKind() == TypeKind.ARRAY) {
                        child = ((DerivedTypeInfo)child).child();
                        ++arrayCount;
                        curContainer = curContainer.forArrayElement();
                    }
                    child.appendAnnotatedText(curContainer, sb);
                    curContainer = container;
                    for (int i = 0; i < arrayCount; ++i) {
                        curContainer.appendImmediateText(sb);
                        sb.append("[]");
                        curContainer = curContainer.forArrayElement();
                    }
                    break;
                }
                case 19: {
                    this.myChild.appendAnnotatedText(container.forArrayElement(), sb);
                    container.appendImmediateText(sb);
                    sb.append("...");
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/cache/TypeInfo$DerivedTypeInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendAnnotatedText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class RefTypeInfo
    extends TypeInfo {
        private final String myName;
        @Nullable
        private final RefTypeInfo myOuter;
        @NotNull
        private final @NotNull TypeInfo @NotNull [] myComponents;

        public RefTypeInfo(@NotNull String name) {
            if (name == null) {
                RefTypeInfo.$$$reportNull$$$0(0);
            }
            this(name, null, EMPTY_ARRAY);
        }

        public RefTypeInfo(@NotNull String name, @Nullable RefTypeInfo outer) {
            if (name == null) {
                RefTypeInfo.$$$reportNull$$$0(1);
            }
            this(name, outer, EMPTY_ARRAY);
        }

        public RefTypeInfo(@NotNull String name, @Nullable RefTypeInfo outer, @NotNull @NotNull TypeInfo @NotNull [] components) {
            if (name == null) {
                RefTypeInfo.$$$reportNull$$$0(2);
            }
            if (components == null) {
                RefTypeInfo.$$$reportNull$$$0(3);
            }
            super(outer != null ? (components.length == 0 ? (outer.getKind() == TypeKind.REF ? TypeKind.INNER_SIMPLE : TypeKind.INNER) : TypeKind.INNER_GENERIC) : (components.length == 0 ? (name.startsWith("java.") ? TEXT_TO_KIND.getOrDefault(name, TypeKind.REF) : TypeKind.REF) : TypeKind.GENERIC));
            this.myName = name;
            this.myComponents = components;
            this.myOuter = outer;
        }

        @Override
        public String text(boolean isShort) {
            if (isShort) {
                return StringUtil.getShortName((String)this.myName);
            }
            if (this.myComponents.length == 0) {
                return this.myOuter != null ? this.myOuter.text(isShort) + "." + this.myName : this.myName;
            }
            StringBuilder sb = new StringBuilder();
            if (this.myOuter != null) {
                sb.append(this.myOuter.text(isShort));
                sb.append(".");
            }
            sb.append(this.myName);
            sb.append("<");
            for (int i = 0; i < this.myComponents.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(this.myComponents[i].text());
            }
            sb.append(">");
            return sb.toString();
        }

        @Override
        void appendAnnotatedText(@NotNull TypeAnnotationContainer container, @NotNull StringBuilder sb) {
            if (container == null) {
                RefTypeInfo.$$$reportNull$$$0(4);
            }
            if (sb == null) {
                RefTypeInfo.$$$reportNull$$$0(5);
            }
            if (this.myOuter != null) {
                this.myOuter.appendAnnotatedText(container.forEnclosingClass(), sb);
                sb.append(".");
            }
            container.appendImmediateText(sb);
            sb.append(this.myName);
            if (this.myComponents.length > 0) {
                sb.append("<");
                for (int i = 0; i < this.myComponents.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    this.myComponents[i].appendAnnotatedText(container.forTypeArgument(i), sb);
                }
                sb.append(">");
            }
        }

        String jvmName() {
            return this.myOuter == null ? this.myName.replace('.', '/') : this.myOuter.jvmName() + "$" + this.myName;
        }

        @Override
        public int innerDepth( @NotNull SignatureParsing.TypeInfoProvider provider) {
            if (provider == null) {
                RefTypeInfo.$$$reportNull$$$0(6);
            }
            return this.myOuter != null && !provider.isKnownStatic(this.jvmName()) ? this.myOuter.innerDepth(provider) + 1 : 0;
        }

        @NotNull
        public RefTypeInfo withComponents(@NotNull List<TypeInfo> components) {
            if (components == null) {
                RefTypeInfo.$$$reportNull$$$0(7);
            }
            return new RefTypeInfo(this.myName, this.myOuter, components.toArray(EMPTY_ARRAY));
        }

        @NotNull
        public RefTypeInfo withOuter(@Nullable RefTypeInfo outer) {
            if (this.myOuter != null) {
                return new RefTypeInfo(this.myName, this.myOuter.withOuter(outer), this.myComponents);
            }
            return new RefTypeInfo(this.myName, outer, this.myComponents);
        }

        @Nullable
        public TypeInfo genericComponent(int index) {
            return index >= this.myComponents.length ? null : this.myComponents[index];
        }

        @Nullable
        public RefTypeInfo outerType() {
            return this.myOuter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "components";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/cache/TypeInfo$RefTypeInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendAnnotatedText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "innerDepth";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withComponents";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

