/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.controlflow.instruction;

import com.intellij.codeInsight.controlflow.ControlFlowBuilder;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.controlflow.impl.DetachedInstructionImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLoopJunctionInstruction
extends DetachedInstructionImpl {
    private static final Logger LOG = Logger.getInstance(JSLoopJunctionInstruction.class);
    private final AtomicInteger myRegularPrevSize = new AtomicInteger();

    public JSLoopJunctionInstruction(@Nullable PsiElement element) {
        super(element);
    }

    public void addNodeAndMarkRegularPred(@NotNull ControlFlowBuilder builder) {
        if (builder == null) {
            JSLoopJunctionInstruction.$$$reportNull$$$0(0);
        }
        this.addNode(builder);
        this.myRegularPrevSize.set(this.allPred().size());
    }

    @NotNull
    public Collection<Instruction> getJumpPred() {
        int regularSize = this.myRegularPrevSize.get();
        List instructions = this.allPred();
        if (regularSize == 0) {
            List list = instructions;
            if (list == null) {
                JSLoopJunctionInstruction.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (regularSize < instructions.size()) {
            List<Instruction> list = instructions.subList(regularSize, instructions.size());
            if (list == null) {
                JSLoopJunctionInstruction.$$$reportNull$$$0(2);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            JSLoopJunctionInstruction.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public Collection<Instruction> getRegularPred() {
        int regularSize = this.myRegularPrevSize.get();
        List instructions = this.allPred();
        if (regularSize > 0) {
            List<Instruction> list = instructions.subList(0, regularSize);
            if (list == null) {
                JSLoopJunctionInstruction.$$$reportNull$$$0(4);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            JSLoopJunctionInstruction.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void replacePred(@NotNull Instruction oldInstruction, @NotNull Collection<? extends Instruction> newInstructions) {
        int marker;
        List instructions;
        int index;
        if (oldInstruction == null) {
            JSLoopJunctionInstruction.$$$reportNull$$$0(6);
        }
        if (newInstructions == null) {
            JSLoopJunctionInstruction.$$$reportNull$$$0(7);
        }
        if ((index = (instructions = this.allPred()).indexOf(oldInstruction)) >= (marker = this.myRegularPrevSize.get()) || index == -1) {
            if (index == -1) {
                LOG.error("CF graph is inconsistent, replace shouldn't be called for non-existing edges");
            }
            super.replacePred(oldInstruction, newInstructions);
            return;
        }
        if (!newInstructions.isEmpty()) {
            instructions.addAll(index, newInstructions);
        }
        instructions.remove(oldInstruction);
        int newIndex = marker + (newInstructions.size() - 1);
        if (newIndex < 0) {
            LOG.error("CF graph is inconsistent, marker shouldn't be less or equal zero in this branch: " + marker);
            newIndex = 0;
        }
        this.myRegularPrevSize.set(newIndex);
    }

    @NotNull
    public String getElementPresentation() {
        Collection<Instruction> allRegular = this.getRegularPred();
        Collection<Instruction> allJumps = this.getJumpPred();
        List allPred = this.allPred();
        String string = super.getElementPresentation() + " loop condition (p: " + allPred.size() + ", r: " + allRegular.size() + ", j: " + allJumps.size() + ")";
        if (string == null) {
            JSLoopJunctionInstruction.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/controlflow/instruction/JSLoopJunctionInstruction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldInstruction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInstructions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/controlflow/instruction/JSLoopJunctionInstruction";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getJumpPred";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegularPred";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addNodeAndMarkRegularPred";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replacePred";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 8 -> new IllegalStateException(string);
        };
    }
}

