/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model.state;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbReferenceModelState;
import com.intellij.database.schemaEditor.model.state.DbSingleValueModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbIndirectReferenceModelState<T extends BasicElement, V>
extends DbSingleValueModelState<V>
implements DbReferenceModelState<T> {
    private final @NotNull Function<? super @Nullable V, ? extends @Nullable BasicReference> myRefParser;
    private BasicReference myCheckRef;
    private ElementIdentity<T> myTargetId;
    private DbModelRef<T, DbStructureObjectModelState<T>> myTargetStructureRef;

    public DbIndirectReferenceModelState(V initial, @NotNull Function<? super @Nullable V, ? extends @Nullable BasicReference> refParser) {
        if (refParser == null) {
            DbIndirectReferenceModelState.$$$reportNull$$$0(0);
        }
        super(initial);
        this.myRefParser = refParser;
    }

    @Override
    public void setValue(@Nullable V value) {
        if (Objects.equals(value, this.getValue())) {
            return;
        }
        this.resetTargetOnSetValue();
        this.myCheckRef = this.getCheckRef(value);
        this.setValueImpl(value);
        this.modified();
    }

    protected void resetTargetOnSetValue() {
        this.myTargetId = null;
    }

    @Nullable
    private <E extends BasicElement> BasicReference getCheckRef(@Nullable V value) {
        return this.myRefParser.apply(value);
    }

    @Override
    @Nullable
    public ElementIdentity<T> getTargetId() {
        return this.myTargetId;
    }

    @Override
    @Nullable
    public BasicReference getActualRef() {
        return this.myCheckRef;
    }

    @Nullable
    public DbModelRef<T, DbStructureObjectModelState<T>> getTargetStructureRef() {
        return this.myTargetStructureRef;
    }

    public void setTargetId(@Nullable ElementIdentity<T> targetId, @Nullable DbModelRef<T, DbStructureObjectModelState<T>> targetStructureRef, @Nullable BasicReference checkRef, @Nullable V storedRef) {
        if (Objects.equals(checkRef, this.myCheckRef) && Objects.equals(this.getValue(), storedRef) && this.myTargetId == targetId && (targetStructureRef == null || this.myTargetStructureRef == targetStructureRef)) {
            return;
        }
        this.myTargetId = targetId;
        if (targetStructureRef != null) {
            this.myTargetStructureRef = targetStructureRef;
        }
        this.myCheckRef = checkRef;
        this.setValueImpl(storedRef);
        this.modified();
    }

    public void updateRef(@NotNull BasicReference checkRef, @Nullable V storedRef) {
        if (checkRef == null) {
            DbIndirectReferenceModelState.$$$reportNull$$$0(1);
        }
        if (checkRef.equals((Object)this.myCheckRef)) {
            return;
        }
        this.myCheckRef = checkRef;
        this.setValueImpl(storedRef);
        this.modified();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refParser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkRef";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/schemaEditor/model/state/DbIndirectReferenceModelState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateRef";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

