/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.annotation;

import com.google.common.base.Ascii;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.DumbAware;
import com.intellij.protobuf.lang.PbLangBundle;
import com.intellij.protobuf.lang.psi.PbElement;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbGroupDefinition;
import com.intellij.protobuf.lang.psi.PbMapField;
import com.intellij.protobuf.lang.psi.PbOneofDefinition;
import com.intellij.protobuf.lang.psi.PbVisitor;
import com.intellij.protobuf.lang.psi.SyntaxLevelKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class Proto2Annotator
implements Annotator,
DumbAware {
    public void annotate(@NotNull PsiElement element, final @NotNull AnnotationHolder holder) {
        PbElement pbElement;
        if (element == null) {
            Proto2Annotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            Proto2Annotator.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PbElement) || !SyntaxLevelKt.isDeprecatedProto2Syntax((pbElement = (PbElement)element).getPbFile().getSyntaxLevel())) {
            return;
        }
        element.accept((PsiElementVisitor)new PbVisitor(this){

            @Override
            public void visitField(@NotNull PbField field) {
                if (field == null) {
                    1.$$$reportNull$$$0(0);
                }
                Proto2Annotator.annotateField(field, holder);
            }

            @Override
            public void visitGroupDefinition(@NotNull PbGroupDefinition group) {
                if (group == null) {
                    1.$$$reportNull$$$0(1);
                }
                Proto2Annotator.annotateGroupDefinition(group, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "group";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/protobuf/lang/annotation/Proto2Annotator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitField";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitGroupDefinition";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void annotateField(PbField field, AnnotationHolder holder) {
        if (field instanceof PbMapField) {
            return;
        }
        if (field.getStatementOwner() instanceof PbOneofDefinition) {
            return;
        }
        if (field.getDeclaredLabel() == null) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("proto2.field.label.required", new Object[0])).range((PsiElement)field).create();
        }
    }

    private static void annotateGroupDefinition(PbGroupDefinition group, AnnotationHolder holder) {
        PsiElement nameIdentifier = group.getNameIdentifier();
        String name = group.getName();
        if (name != null && nameIdentifier != null && !Ascii.isUpperCase((char)name.charAt(0))) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("proto2.group.name.capital.letter", new Object[0])).range(nameIdentifier).create();
        }
        if (!(group.getStatementOwner() instanceof PbOneofDefinition) && group.getDeclaredLabel() == null) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("proto2.field.label.required", new Object[0])).range((PsiElement)group).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/protobuf/lang/annotation/Proto2Annotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

