/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	context "context"

	resourcev1 "k8s.io/api/resource/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	applyconfigurationsresourcev1 "k8s.io/client-go/applyconfigurations/resource/v1"
	gentype "k8s.io/client-go/gentype"
	scheme "k8s.io/client-go/kubernetes/scheme"
)

// DeviceClassesGetter has a method to return a DeviceClassInterface.
// A group's client should implement this interface.
type DeviceClassesGetter interface {
	DeviceClasses() DeviceClassInterface
}

// DeviceClassInterface has methods to work with DeviceClass resources.
type DeviceClassInterface interface {
	Create(ctx context.Context, deviceClass *resourcev1.DeviceClass, opts metav1.CreateOptions) (*resourcev1.DeviceClass, error)
	Update(ctx context.Context, deviceClass *resourcev1.DeviceClass, opts metav1.UpdateOptions) (*resourcev1.DeviceClass, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*resourcev1.DeviceClass, error)
	List(ctx context.Context, opts metav1.ListOptions) (*resourcev1.DeviceClassList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *resourcev1.DeviceClass, err error)
	Apply(ctx context.Context, deviceClass *applyconfigurationsresourcev1.DeviceClassApplyConfiguration, opts metav1.ApplyOptions) (result *resourcev1.DeviceClass, err error)
	DeviceClassExpansion
}

// deviceClasses implements DeviceClassInterface
type deviceClasses struct {
	*gentype.ClientWithListAndApply[*resourcev1.DeviceClass, *resourcev1.DeviceClassList, *applyconfigurationsresourcev1.DeviceClassApplyConfiguration]
}

// newDeviceClasses returns a DeviceClasses
func newDeviceClasses(c *ResourceV1Client) *deviceClasses {
	return &deviceClasses{
		gentype.NewClientWithListAndApply[*resourcev1.DeviceClass, *resourcev1.DeviceClassList, *applyconfigurationsresourcev1.DeviceClassApplyConfiguration](
			"deviceclasses",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *resourcev1.DeviceClass { return &resourcev1.DeviceClass{} },
			func() *resourcev1.DeviceClassList { return &resourcev1.DeviceClassList{} },
			gentype.PrefersProtobuf[*resourcev1.DeviceClass](),
		),
	}
}
