/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.csi;

import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smackx.csi.packet.ClientStateIndication;

public class ClientStateIndicationManager {
    public static void active(XMPPConnection connection) throws SmackException.NotConnectedException, InterruptedException {
        ClientStateIndicationManager.throwIaeIfNotSupported(connection);
        connection.sendNonza(ClientStateIndication.Active.INSTANCE);
    }

    public static void inactive(XMPPConnection connection) throws SmackException.NotConnectedException, InterruptedException {
        ClientStateIndicationManager.throwIaeIfNotSupported(connection);
        connection.sendNonza(ClientStateIndication.Inactive.INSTANCE);
    }

    public static boolean isSupported(XMPPConnection connection) {
        return connection.hasFeature("csi", "urn:xmpp:csi:0");
    }

    private static void throwIaeIfNotSupported(XMPPConnection connection) {
        if (!ClientStateIndicationManager.isSupported(connection)) {
            throw new IllegalArgumentException("Client State Indication not supported by server");
        }
    }
}

