/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.httpfileupload.provider;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.httpfileupload.HttpFileUploadManager;
import org.jivesoftware.smackx.httpfileupload.UploadService;
import org.jivesoftware.smackx.httpfileupload.element.Slot;
import org.jivesoftware.smackx.httpfileupload.element.Slot_V0_2;
import org.jxmpp.JxmppContext;

public class SlotProvider
extends IqProvider<Slot> {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Slot parse(XmlPullParser parser, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException, SmackParsingException.SmackUriSyntaxParsingException {
        String namespace = parser.getNamespace();
        UploadService.Version version = HttpFileUploadManager.namespaceToVersion(namespace);
        assert (version != null);
        URL putUrl = null;
        URL getUrl = null;
        PutElement_V0_4_Content putElementV04Content = null;
        block24: while (true) {
            XmlPullParser.Event event = parser.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "put": {
                            switch (version) {
                                case v0_2: {
                                    String putUrlString = parser.nextText();
                                    putUrl = SlotProvider.toUrl(putUrlString);
                                    break block0;
                                }
                                case v0_3: {
                                    putElementV04Content = SlotProvider.parsePutElement_V0_4(parser);
                                    break block0;
                                }
                            }
                            throw new AssertionError();
                        }
                        case "get": {
                            String getUrlString;
                            switch (version) {
                                case v0_2: {
                                    getUrlString = parser.nextText();
                                    break;
                                }
                                case v0_3: {
                                    getUrlString = parser.getAttributeValue(null, "url");
                                    break;
                                }
                                default: {
                                    throw new AssertionError();
                                }
                            }
                            getUrl = SlotProvider.toUrl(getUrlString);
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() == initialDepth) break block24;
                }
            }
        }
        switch (version) {
            case v0_3: {
                return new Slot(putElementV04Content.putUrl, getUrl, putElementV04Content.headers);
            }
            case v0_2: {
                return new Slot_V0_2(putUrl, getUrl);
            }
        }
        throw new AssertionError();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static PutElement_V0_4_Content parsePutElement_V0_4(XmlPullParser parser) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        String putUrlString = parser.getAttributeValue(null, "url");
        URL putUrl = URI.create(putUrlString).toURL();
        HashMap<String, String> headers = null;
        while (true) {
            XmlPullParser.Event next = parser.next();
            block0 : switch (next) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "header": {
                            String headerName = ParserUtils.getRequiredAttribute(parser, "name");
                            String headerValue = ParserUtils.getRequiredNextText(parser);
                            if (headers == null) {
                                headers = new HashMap<String, String>();
                            }
                            headers.put(headerName, headerValue);
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return new PutElement_V0_4_Content(putUrl, headers);
                }
            }
        }
    }

    public static final class PutElement_V0_4_Content {
        private final URL putUrl;
        private final Map<String, String> headers;

        private PutElement_V0_4_Content(URL putUrl, Map<String, String> headers) {
            this.putUrl = putUrl;
            this.headers = headers;
        }

        public URL getPutUrl() {
            return this.putUrl;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }
    }
}

