/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.stringprep;

import java.io.IOException;

public class XmppStringprepException
extends IOException {
    private static final long serialVersionUID = -8491853210107124624L;
    private final String causingString;

    public XmppStringprepException(String causingString, Exception exception) {
        super("XmppStringprepException caused by '" + causingString + "': " + String.valueOf(exception));
        this.initCause(exception);
        this.causingString = causingString;
    }

    public XmppStringprepException(String causingString, String message) {
        super(message);
        this.causingString = causingString;
    }

    public String getCausingString() {
        return this.causingString;
    }

    public static class MissingDomainpart
    extends XmppStringprepException {
        private static final long serialVersionUID = 1L;

        private MissingDomainpart(String causingString) {
            super(causingString, "The provided string does not have a domainpart");
        }

        public static MissingDomainpart from(String localpart, String resourcepart) {
            StringBuilder causingString = new StringBuilder();
            if (localpart != null) {
                causingString.append(localpart).append('@');
            }
            if (resourcepart != null) {
                causingString.append('/').append(resourcepart);
            }
            return new MissingDomainpart(causingString.toString());
        }
    }
}

