/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification.syntax_check;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.pgpainless.decryption_verification.syntax_check.InputSymbol;
import org.pgpainless.decryption_verification.syntax_check.StackSymbol;
import org.pgpainless.decryption_verification.syntax_check.State;
import org.pgpainless.decryption_verification.syntax_check.Syntax;
import org.pgpainless.decryption_verification.syntax_check.Transition;
import org.pgpainless.exception.MalformedOpenPgpMessageException;

public class OpenPgpMessageSyntax
implements Syntax {
    @Override
    @Nonnull
    public Transition transition(@Nonnull State from, @Nonnull InputSymbol input, @Nullable StackSymbol stackItem) throws MalformedOpenPgpMessageException {
        switch (from) {
            case OpenPgpMessage: {
                return this.fromOpenPgpMessage(input, stackItem);
            }
            case LiteralMessage: {
                return this.fromLiteralMessage(input, stackItem);
            }
            case CompressedMessage: {
                return this.fromCompressedMessage(input, stackItem);
            }
            case EncryptedMessage: {
                return this.fromEncryptedMessage(input, stackItem);
            }
            case Valid: {
                return this.fromValid(input, stackItem);
            }
        }
        throw new MalformedOpenPgpMessageException(from, input, stackItem);
    }

    @Nonnull
    Transition fromOpenPgpMessage(@Nonnull InputSymbol input, @Nullable StackSymbol stackItem) throws MalformedOpenPgpMessageException {
        if (stackItem != StackSymbol.msg) {
            throw new MalformedOpenPgpMessageException(State.OpenPgpMessage, input, stackItem);
        }
        switch (input) {
            case LiteralData: {
                return new Transition(State.LiteralMessage, new StackSymbol[0]);
            }
            case Signature: {
                return new Transition(State.OpenPgpMessage, StackSymbol.msg);
            }
            case OnePassSignature: {
                return new Transition(State.OpenPgpMessage, StackSymbol.ops, StackSymbol.msg);
            }
            case CompressedData: {
                return new Transition(State.CompressedMessage, new StackSymbol[0]);
            }
            case EncryptedData: {
                return new Transition(State.EncryptedMessage, new StackSymbol[0]);
            }
        }
        throw new MalformedOpenPgpMessageException(State.OpenPgpMessage, input, stackItem);
    }

    @Nonnull
    Transition fromLiteralMessage(@Nonnull InputSymbol input, @Nullable StackSymbol stackItem) throws MalformedOpenPgpMessageException {
        switch (input) {
            case Signature: {
                if (stackItem != StackSymbol.ops) break;
                return new Transition(State.LiteralMessage, new StackSymbol[0]);
            }
            case EndOfSequence: {
                if (stackItem != StackSymbol.terminus) break;
                return new Transition(State.Valid, new StackSymbol[0]);
            }
        }
        throw new MalformedOpenPgpMessageException(State.LiteralMessage, input, stackItem);
    }

    @Nonnull
    Transition fromCompressedMessage(@Nonnull InputSymbol input, @Nullable StackSymbol stackItem) throws MalformedOpenPgpMessageException {
        switch (input) {
            case Signature: {
                if (stackItem != StackSymbol.ops) break;
                return new Transition(State.CompressedMessage, new StackSymbol[0]);
            }
            case EndOfSequence: {
                if (stackItem != StackSymbol.terminus) break;
                return new Transition(State.Valid, new StackSymbol[0]);
            }
        }
        throw new MalformedOpenPgpMessageException(State.CompressedMessage, input, stackItem);
    }

    @Nonnull
    Transition fromEncryptedMessage(@Nonnull InputSymbol input, @Nullable StackSymbol stackItem) throws MalformedOpenPgpMessageException {
        switch (input) {
            case Signature: {
                if (stackItem != StackSymbol.ops) break;
                return new Transition(State.EncryptedMessage, new StackSymbol[0]);
            }
            case EndOfSequence: {
                if (stackItem != StackSymbol.terminus) break;
                return new Transition(State.Valid, new StackSymbol[0]);
            }
        }
        throw new MalformedOpenPgpMessageException(State.EncryptedMessage, input, stackItem);
    }

    @Nonnull
    Transition fromValid(@Nonnull InputSymbol input, @Nullable StackSymbol stackItem) throws MalformedOpenPgpMessageException {
        if (input == InputSymbol.EndOfSequence) {
            return new Transition(State.Valid, new StackSymbol[0]);
        }
        throw new MalformedOpenPgpMessageException(State.Valid, input, stackItem);
    }
}

