/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.builder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.builder.AbstractSignatureBuilder;
import org.pgpainless.signature.subpackets.CertificationSubpackets;

public class ThirdPartyCertificationSignatureBuilder
extends AbstractSignatureBuilder<ThirdPartyCertificationSignatureBuilder> {
    public ThirdPartyCertificationSignatureBuilder(PGPSecretKey signingKey, SecretKeyRingProtector protector) throws PGPException {
        this(SignatureType.GENERIC_CERTIFICATION, signingKey, protector);
    }

    public ThirdPartyCertificationSignatureBuilder(SignatureType signatureType, PGPSecretKey signingKey, SecretKeyRingProtector protector) throws PGPException {
        super(signatureType, signingKey, protector);
    }

    public ThirdPartyCertificationSignatureBuilder(PGPSecretKey signingKey, SecretKeyRingProtector protector, PGPSignature archetypeSignature) throws PGPException {
        super(signingKey, protector, archetypeSignature);
    }

    public CertificationSubpackets getHashedSubpackets() {
        return this.hashedSubpackets;
    }

    public CertificationSubpackets getUnhashedSubpackets() {
        return this.unhashedSubpackets;
    }

    public void applyCallback(@Nullable CertificationSubpackets.Callback callback) {
        if (callback != null) {
            callback.modifyHashedSubpackets(this.getHashedSubpackets());
            callback.modifyUnhashedSubpackets(this.getUnhashedSubpackets());
        }
    }

    public PGPSignature build(PGPPublicKeyRing certifiedKey, String userId) throws PGPException {
        return this.buildAndInitSignatureGenerator().generateCertification(userId, certifiedKey.getPublicKey());
    }

    public PGPSignature build(PGPPublicKeyRing certifiedKey, PGPUserAttributeSubpacketVector userAttribute) throws PGPException {
        return this.buildAndInitSignatureGenerator().generateCertification(userAttribute, certifiedKey.getPublicKey());
    }

    @Override
    protected boolean isValidSignatureType(@Nonnull SignatureType type) {
        switch (type) {
            case GENERIC_CERTIFICATION: 
            case NO_CERTIFICATION: 
            case CASUAL_CERTIFICATION: 
            case POSITIVE_CERTIFICATION: {
                return true;
            }
        }
        return false;
    }
}

