/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util.selection.keyring.impl;

import java.util.Iterator;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.pgpainless.util.selection.keyring.PublicKeyRingSelectionStrategy;
import org.pgpainless.util.selection.keyring.SecretKeyRingSelectionStrategy;

public final class ExactUserId {
    private ExactUserId() {
    }

    public static class SecRingSelectionStrategy
    extends SecretKeyRingSelectionStrategy<String> {
        @Override
        public boolean accept(String identifier, PGPSecretKeyRing keyRing) {
            Iterator<String> userIds = keyRing.getPublicKey().getUserIDs();
            while (userIds.hasNext()) {
                if (!userIds.next().equals(identifier)) continue;
                return true;
            }
            return false;
        }
    }

    public static class PubRingSelectionStrategy
    extends PublicKeyRingSelectionStrategy<String> {
        @Override
        public boolean accept(String identifier, PGPPublicKeyRing keyRing) {
            Iterator<String> userIds = keyRing.getPublicKey().getUserIDs();
            while (userIds.hasNext()) {
                if (!userIds.next().equals(identifier)) continue;
                return true;
            }
            return false;
        }
    }
}

