/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.items;

import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.library.items.SwitchItem;
import org.openhab.core.library.types.IncreaseDecreaseType;
import org.openhab.core.library.types.OnOffType;
import org.openhab.core.library.types.PercentType;
import org.openhab.core.types.Command;
import org.openhab.core.types.RefreshType;
import org.openhab.core.types.State;
import org.openhab.core.types.TimeSeries;
import org.openhab.core.types.UnDefType;

@NonNullByDefault
public class DimmerItem
extends SwitchItem {
    private static final List<Class<? extends State>> ACCEPTED_DATA_TYPES = List.of(PercentType.class, OnOffType.class, UnDefType.class);
    private static final List<Class<? extends Command>> ACCEPTED_COMMAND_TYPES = List.of(PercentType.class, OnOffType.class, IncreaseDecreaseType.class, RefreshType.class);

    public DimmerItem(String name) {
        super("Dimmer", name);
    }

    DimmerItem(String type, String name) {
        super(type, name);
    }

    public void send(PercentType command) {
        this.internalSend(command, null);
    }

    public void send(PercentType command, @Nullable String source) {
        this.internalSend(command, source);
    }

    public void send(IncreaseDecreaseType command) {
        this.internalSend(command, null);
    }

    public void send(IncreaseDecreaseType command, @Nullable String source) {
        this.internalSend(command, source);
    }

    @Override
    public List<Class<? extends State>> getAcceptedDataTypes() {
        return ACCEPTED_DATA_TYPES;
    }

    @Override
    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        return ACCEPTED_COMMAND_TYPES;
    }

    @Override
    public void setState(State state, @Nullable String source) {
        if (this.isAcceptedState(ACCEPTED_DATA_TYPES, state)) {
            PercentType convertedState = state.as(PercentType.class);
            if (convertedState != null) {
                this.applyState(convertedState, source);
            } else {
                this.applyState(state, source);
            }
        } else {
            this.logSetTypeError(state);
        }
    }

    @Override
    public void setTimeSeries(TimeSeries timeSeries) {
        if (timeSeries.getStates().allMatch(s -> s.state() instanceof PercentType)) {
            super.applyTimeSeries(timeSeries);
        } else {
            this.logSetTypeError(timeSeries);
        }
    }
}

