/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.format;

import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.format.AbstractQuantityFormat;
import tech.units.indriya.format.CommonFormatter;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.units.indriya.internal.format.RationalNumberScanner;
import tech.units.indriya.quantity.MixedQuantity;
import tech.units.indriya.quantity.Quantities;
import tech.units.indriya.spi.Range;

public class SimpleQuantityFormat
extends AbstractQuantityFormat {
    private static final SimpleQuantityFormat DEFAULT = new SimpleQuantityFormat();
    private static final String NUM_PART = "n";
    private static final String UNIT_PART = "u";
    private static final String RADIX = "~";
    private static final String RANGE_COMPACT = "rc";
    private static final String DEFAULT_PATTERN = "n u";
    private final String pattern;
    private String delimiter;
    private String mixDelimiter;
    private final boolean rangeCompact;
    private static final long serialVersionUID = 2758248665095734058L;

    public SimpleQuantityFormat(String pattern) {
        Objects.requireNonNull(pattern);
        if (pattern != null && !pattern.isEmpty()) {
            if (RANGE_COMPACT.equals(pattern)) {
                this.rangeCompact = true;
                this.pattern = DEFAULT_PATTERN;
            } else if (pattern.contains(RANGE_COMPACT)) {
                this.pattern = pattern;
                this.rangeCompact = true;
            } else {
                this.pattern = pattern;
                this.rangeCompact = false;
            }
            if (this.pattern.contains(RADIX)) {
                String singlePattern = this.pattern.substring(0, this.pattern.indexOf(RADIX));
                this.mixDelimiter = this.pattern.substring(this.pattern.indexOf(RADIX) + 1);
                this.delimiter = singlePattern.substring(this.pattern.indexOf(NUM_PART) + 1, this.pattern.indexOf(UNIT_PART));
            } else {
                this.delimiter = this.pattern.substring(this.pattern.indexOf(NUM_PART) + 1, this.pattern.indexOf(UNIT_PART));
            }
        } else {
            throw new IllegalArgumentException("Pattern cannot be empty");
        }
    }

    protected SimpleQuantityFormat() {
        this(DEFAULT_PATTERN);
    }

    @Override
    public Appendable format(Quantity<?> quantity, Appendable dest) throws IOException {
        Unit unit = quantity.getUnit();
        dest.append(quantity.getValue().toString());
        if (quantity.getUnit().equals(AbstractUnit.ONE)) {
            return dest;
        }
        dest.append(this.delimiter);
        return SimpleUnitFormat.getInstance().format(unit, dest);
    }

    public String formatRange(Range<?> range) {
        StringBuilder sb = new StringBuilder().append(this.rangeCompact ? "min=" : "minimum=").append(range.getMinimum()).append(this.rangeCompact ? ", max=" : ", maximum=").append(range.getMaximum());
        if (range.getResolution() != null) {
            sb.append(this.rangeCompact ? ", res=" : ", resolution=").append(range.getResolution());
        }
        return sb.toString();
    }

    @Override
    public Quantity<?> parse(CharSequence csq, ParsePosition cursor) throws MeasurementParseException {
        NumberFormat numberFormat = NumberFormat.getInstance();
        SimpleUnitFormat simpleUnitFormat = SimpleUnitFormat.getInstance();
        if (this.mixDelimiter != null && !this.mixDelimiter.equals(this.delimiter)) {
            return CommonFormatter.parseMixedAsLeading(csq.toString(), numberFormat, simpleUnitFormat, this.delimiter, this.mixDelimiter, cursor.getIndex());
        }
        if (this.mixDelimiter != null && this.mixDelimiter.equals(this.delimiter)) {
            return CommonFormatter.parseMixedAsLeading(csq.toString(), numberFormat, simpleUnitFormat, this.delimiter, cursor.getIndex());
        }
        RationalNumberScanner scanner = new RationalNumberScanner(csq, cursor, null);
        Number number = scanner.getNumber();
        Unit<?> unit = simpleUnitFormat.parse(csq, cursor);
        return Quantities.getQuantity(number, unit);
    }

    @Override
    protected Quantity<?> parse(CharSequence csq, int index) throws MeasurementParseException {
        return this.parse(csq, new ParsePosition(index));
    }

    @Override
    public Quantity<?> parse(CharSequence csq) throws MeasurementParseException {
        return this.parse(csq, new ParsePosition(0));
    }

    public static SimpleQuantityFormat getInstance() {
        return DEFAULT;
    }

    public static SimpleQuantityFormat getInstance(String pattern) {
        return new SimpleQuantityFormat(pattern);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    protected StringBuffer formatMixed(MixedQuantity<?> mixed, StringBuffer dest) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (Quantity<?> q : mixed.getQuantities()) {
            sb.append(this.format(q));
            if (i < mixed.getQuantities().size() - 1) {
                sb.append(this.mixDelimiter != null ? this.mixDelimiter : " ");
            }
            ++i;
        }
        return sb;
    }
}

