/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Reflections {
    public static Object invoke(Method method, Object target, Object ... args) throws Exception {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalArgumentException iae) {
            String message = "Could not invoke method by reflection: " + Reflections.toString(method);
            if (args != null && args.length > 0) {
                message = message + " with parameters: (" + Reflections.toClassNameString(", ", args) + ")";
            }
            message = message + " on: " + target.getClass().getName();
            throw new IllegalArgumentException(message, iae);
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() instanceof Exception) {
                throw (Exception)ite.getCause();
            }
            throw ite;
        }
    }

    public static Object get(Field field, Object target) throws Exception {
        boolean accessible = Reflections.canAccessField(field);
        try {
            field.setAccessible(true);
            Object object = field.get(target);
            return object;
        }
        catch (IllegalArgumentException iae) {
            String message = "Could not get field value by reflection: " + Reflections.toString(field) + " on: " + target.getClass().getName();
            throw new IllegalArgumentException(message, iae);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    public static Method getMethod(Class clazz, String name) {
        for (Class superClass = clazz; superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                return superClass.getDeclaredMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        throw new IllegalArgumentException("No such method: " + clazz.getName() + "." + name);
    }

    public static void set(Field field, Object target, Object value) throws Exception {
        boolean accessible = Reflections.canAccessField(field);
        try {
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (IllegalArgumentException iae) {
            String message = "Could not set field value by reflection: " + Reflections.toString(field) + " on: " + field.getDeclaringClass().getName();
            message = value == null ? message + " with null value" : message + " with value: " + String.valueOf(value.getClass());
            throw new IllegalArgumentException(message, iae);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    public static String getMethodPropertyName(String methodName) {
        String methodPropertyName = null;
        if (methodName.startsWith("get")) {
            methodPropertyName = Reflections.decapitalize(methodName.substring(3));
        } else if (methodName.startsWith("is")) {
            methodPropertyName = Reflections.decapitalize(methodName.substring(2));
        } else if (methodName.startsWith("set")) {
            methodPropertyName = Reflections.decapitalize(methodName.substring(3));
        }
        return methodPropertyName;
    }

    public static Method getGetterMethod(Class clazz, String name) {
        for (Class superClass = clazz; superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
            for (Method method : superClass.getDeclaredMethods()) {
                String methodName = method.getName();
                if (method.getParameterTypes().length != 0 || !(methodName.startsWith("get") ? Reflections.decapitalize(methodName.substring(3)).equals(name) : methodName.startsWith("is") && Reflections.decapitalize(methodName.substring(2)).equals(name))) continue;
                return method;
            }
        }
        return null;
    }

    public static List<Method> getMethods(Class clazz, Class annotation) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class superClass = clazz; superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
            for (Method method : superClass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(annotation)) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    public static Field getField(Class clazz, String name) {
        for (Class superClass = clazz; superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                return superClass.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static List<Field> getFields(Class clazz, Class annotation) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class superClass = clazz; superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
            for (Field field : superClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(annotation)) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    public static <T> List<Class<?>> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        HashMap resolvedTypes = new HashMap();
        Type type = childClass;
        while (!Reflections.getClass(type).equals(baseClass)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
            }
            if (rawType.equals(baseClass)) continue;
            type = rawType.getGenericSuperclass();
        }
        Type[] actualTypeArguments = type instanceof Class ? type.getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
        ArrayList typeArgumentsAsClasses = new ArrayList();
        for (Type baseType : actualTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(Reflections.getClass(baseType));
        }
        return typeArgumentsAsClasses;
    }

    public static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return Reflections.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = Reflections.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    public static Object getAndWrap(Field field, Object target) {
        boolean accessible = Reflections.canAccessField(field);
        try {
            field.setAccessible(true);
            Object object = Reflections.get(field, target);
            return object;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalArgumentException("exception setting: " + field.getName(), e);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    public static void setAndWrap(Field field, Object target, Object value) {
        boolean accessible = Reflections.canAccessField(field);
        try {
            field.setAccessible(true);
            Reflections.set(field, target, value);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalArgumentException("exception setting: " + field.getName(), e);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    public static Object invokeAndWrap(Method method, Object target, Object ... args) {
        try {
            return Reflections.invoke(method, target, args);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("exception invoking: " + method.getName(), e);
        }
    }

    public static String toString(Member member) {
        return Reflections.unqualify(member.getDeclaringClass().getName()) + "." + member.getName();
    }

    public static Class classForName(String name) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (Exception e) {
            return Class.forName(name);
        }
    }

    public static boolean isClassAvailable(String name) {
        try {
            Reflections.classForName(name);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static Class getCollectionElementType(Type collectionType) {
        Type typeArgument;
        if (!(collectionType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("collection type not parameterized");
        }
        Type[] typeArguments = ((ParameterizedType)collectionType).getActualTypeArguments();
        if (typeArguments.length == 0) {
            throw new IllegalArgumentException("no type arguments for collection type");
        }
        Type type = typeArgument = typeArguments.length == 1 ? typeArguments[0] : typeArguments[1];
        if (typeArgument instanceof ParameterizedType) {
            typeArgument = ((ParameterizedType)typeArgument).getRawType();
        }
        if (!(typeArgument instanceof Class)) {
            throw new IllegalArgumentException("type argument not a class");
        }
        return (Class)typeArgument;
    }

    public static Class getMapKeyType(Type collectionType) {
        if (!(collectionType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("collection type not parameterized");
        }
        Type[] typeArguments = ((ParameterizedType)collectionType).getActualTypeArguments();
        if (typeArguments.length == 0) {
            throw new IllegalArgumentException("no type arguments for collection type");
        }
        Type typeArgument = typeArguments[0];
        if (!(typeArgument instanceof Class)) {
            throw new IllegalArgumentException("type argument not a class");
        }
        return (Class)typeArgument;
    }

    public static Method getSetterMethod(Class clazz, String name) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith("set") || method.getParameterTypes().length != 1 || !Reflections.decapitalize(methodName.substring(3)).equals(name)) continue;
            return method;
        }
        throw new IllegalArgumentException("no such setter method: " + clazz.getName() + "." + name);
    }

    public static Method getMethod(Annotation annotation, String name) {
        try {
            return annotation.annotationType().getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
    }

    public static boolean isInstanceOf(Class clazz, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        for (Class c = clazz; c != Object.class; c = c.getSuperclass()) {
            if (!Reflections.instanceOf(c, name)) continue;
            return true;
        }
        return false;
    }

    private static boolean instanceOf(Class clazz, String name) {
        if (name.equals(clazz.getName())) {
            return true;
        }
        boolean found = false;
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length && !found; ++i) {
            found = Reflections.instanceOf(interfaces[i], name);
        }
        return found;
    }

    public static String toClassNameString(String sep, Object ... objects) {
        if (objects.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Object object : objects) {
            builder.append(sep);
            if (object == null) {
                builder.append("null");
                continue;
            }
            builder.append(object.getClass().getName());
        }
        return builder.substring(sep.length());
    }

    public static String unqualify(String name) {
        return Reflections.unqualify(name, '.');
    }

    public static String unqualify(String name, char sep) {
        return name.substring(name.lastIndexOf(sep) + 1);
    }

    public static String decapitalize(String name) {
        if (name == null) {
            return null;
        }
        if (name.isEmpty() || name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canAccessField(Field field) {
        boolean isAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            boolean bl = true;
            return bl;
        }
        catch (SecurityException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            field.setAccessible(isAccessible);
        }
    }
}

