/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap.option;

import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionNumberRegistry;
import org.eclipse.californium.core.coap.option.BaseOptionDefinition;

public class IntegerOptionDefinition
extends BaseOptionDefinition {
    private static final int[] LENGTHS = new int[]{0, 8};

    public IntegerOptionDefinition(int number, String name) {
        this(number, name, true, LENGTHS);
    }

    public IntegerOptionDefinition(int number, String name, boolean singleValue) {
        this(number, name, singleValue, LENGTHS);
    }

    public IntegerOptionDefinition(int number, String name, boolean singleValue, int ... lengths) {
        super(number, name, OptionNumberRegistry.OptionFormat.INTEGER, singleValue, lengths);
    }

    @Override
    public Option create(long value) {
        return new Option(this, value);
    }

    public static int getIntegerValue(byte[] value) {
        int ret = 0;
        for (int i = 0; i < value.length; ++i) {
            ret += (value[value.length - i - 1] & 0xFF) << i * 8;
        }
        return ret;
    }

    public static long getLongValue(byte[] value) {
        long ret = 0L;
        for (int i = 0; i < value.length; ++i) {
            ret += (long)(value[value.length - i - 1] & 0xFF) << i * 8;
        }
        return ret;
    }

    public static byte[] setIntegerValue(int val) {
        int length = (32 - Integer.numberOfLeadingZeros(val) + 7) / 8;
        byte[] value = new byte[length];
        for (int i = 0; i < length; ++i) {
            value[length - i - 1] = (byte)(val >> i * 8);
        }
        return value;
    }

    public static byte[] setLongValue(long val) {
        int length = (64 - Long.numberOfLeadingZeros(val) + 7) / 8;
        byte[] value = new byte[length];
        for (int i = 0; i < length; ++i) {
            value[length - i - 1] = (byte)(val >> i * 8);
        }
        return value;
    }
}

