/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.mapper;

import com.igormaznitsa.jbbp.exceptions.JBBPMapperException;
import com.igormaznitsa.jbbp.io.JBBPBitNumber;
import com.igormaznitsa.jbbp.io.JBBPBitOrder;
import com.igormaznitsa.jbbp.mapper.Bin;
import com.igormaznitsa.jbbp.mapper.BinFieldFilter;
import com.igormaznitsa.jbbp.mapper.BinType;
import com.igormaznitsa.jbbp.mapper.JBBPMapper;
import com.igormaznitsa.jbbp.mapper.JBBPMapperCustomFieldProcessor;
import com.igormaznitsa.jbbp.model.JBBPAbstractArrayField;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayBit;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayByte;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayInt;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayLong;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayShort;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayStruct;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayUByte;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayUInt;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayUShort;
import com.igormaznitsa.jbbp.model.JBBPFieldInt;
import com.igormaznitsa.jbbp.model.JBBPFieldLong;
import com.igormaznitsa.jbbp.model.JBBPFieldString;
import com.igormaznitsa.jbbp.model.JBBPFieldStruct;
import com.igormaznitsa.jbbp.model.JBBPNumericField;
import com.igormaznitsa.jbbp.utils.Function;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class MappedFieldRecord
implements Comparable<MappedFieldRecord> {
    private static final Function<Class<?>, Object> STATIC_MAKE_CLASS_INSTANCE_INSTANTIATOR = klazz -> {
        boolean find;
        Class<?> currentClass = klazz;
        Object result = null;
        do {
            try {
                Method method = currentClass.getMethod("newInstance", Class.class);
                if (Modifier.isStatic(method.getModifiers())) {
                    result = method.invoke(null, klazz);
                }
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(String.format("Can't get access to static method %s(%ss) in %s", "newInstance", klazz, currentClass), ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(String.format("Can't call static method %s(%s) in %s", "newInstance", klazz, currentClass), ex);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (result == null) {
                if (currentClass.isLocalClass()) {
                    find = (currentClass = currentClass.getEnclosingClass()) != null;
                    continue;
                }
                find = false;
                continue;
            }
            find = false;
        } while (find);
        return result;
    };
    private static final Function<Class<?>, Object> DEFAULT_CONSTRUCTOR_INSTANTIATOR = aClass -> {
        try {
            if (!aClass.isLocalClass() || Modifier.isStatic(aClass.getModifiers())) {
                return aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(String.format("Error during default constructor call, class %s", aClass), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(String.format("Can't get access to default constructor , class %s", aClass), ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(String.format("Can't make instance of class %s", aClass), ex);
        }
    };
    private static final FieldProcessor PROC_ARRAYS = (record, rootStructure, instance, customFieldProcessor, binField, flags, binFieldFilter, instantiators) -> {
        if (binField instanceof JBBPAbstractArrayField) {
            if (binField instanceof JBBPFieldArrayStruct) {
                JBBPFieldArrayStruct structArray = (JBBPFieldArrayStruct)binField;
                Class<?> componentType = record.mappingField.getType().getComponentType();
                Object valueArray = MappedFieldRecord.getFieldValue(instance, record.getter, record.mappingField);
                Object object = valueArray = valueArray == null ? Array.newInstance(componentType, structArray.size()) : valueArray;
                if (Array.getLength(valueArray) != structArray.size()) {
                    throw new JBBPMapperException("Can't map an array field for different expected size [" + Array.getLength(valueArray) + "!=" + structArray.size() + "]", binField, record.mappingClass, record.mappingField, null);
                }
                for (int i = 0; i < structArray.size(); ++i) {
                    Object curInstance = Array.get(valueArray, i);
                    if (curInstance == null) {
                        Array.set(valueArray, i, JBBPMapper.map(structArray.getElementAt(i), MappedFieldRecord.tryMakeInstance(componentType, binField, instance, record.mappingField, instantiators), customFieldProcessor, 0, binFieldFilter, instantiators));
                        continue;
                    }
                    Array.set(valueArray, i, JBBPMapper.map(structArray.getElementAt(i), curInstance, customFieldProcessor, 0, binFieldFilter, new Function[0]));
                }
                MappedFieldRecord.setFieldValue(instance, record.setter, record.mappingField, binField, valueArray);
            } else {
                MappedFieldRecord.mapArrayField(instance, record.setter, record.mappingField, (JBBPAbstractArrayField)binField, record.binAnnotation.bitOrder() == JBBPBitOrder.MSB0);
            }
        } else {
            throw new JBBPMapperException("Can't map a non-array value to an array mapping field", binField, record.mappingClass, record.mappingField, null);
        }
    };
    private static final FieldProcessor PROC_NUM = (record, rootStructure, instance, customFieldProcessor, binField, flags, binFieldFilter, instantiators) -> {
        if (binField instanceof JBBPNumericField) {
            MappedFieldRecord.mapNumericField(instance, record.setter, record.mappingField, (JBBPNumericField)((Object)binField), record.binAnnotation.bitOrder() == JBBPBitOrder.MSB0);
        } else if (binField instanceof JBBPFieldString) {
            if (record.mappingField.getType().isPrimitive()) {
                throw new JBBPMapperException("Can't map string to a primitive mapping field", binField, record.mappingClass, record.mappingField, null);
            }
            MappedFieldRecord.setFieldValue(instance, record.setter, record.mappingField, binField, ((JBBPFieldString)binField).getAsString());
        } else if (binField instanceof JBBPFieldStruct) {
            if (record.mappingField.getType().isPrimitive()) {
                throw new JBBPMapperException("Can't map structure to a primitive mapping field", binField, record.mappingClass, record.mappingField, null);
            }
            Object curValue = MappedFieldRecord.getFieldValue(instance, record.getter, record.mappingField);
            if (curValue == null) {
                if (record.instanceMaker == null) {
                    MappedFieldRecord.setFieldValue(instance, record.setter, record.mappingField, binField, JBBPMapper.map((JBBPFieldStruct)binField, MappedFieldRecord.tryMakeInstance(record.mappingField.getType(), binField, instance, record.mappingField, instantiators), customFieldProcessor, 0, binFieldFilter, new Function[0]));
                } else {
                    try {
                        JBBPMapper.map((JBBPFieldStruct)binField, record.instanceMaker.invoke(instance, new Object[0]), new Function[0]);
                    }
                    catch (Exception ex) {
                        throw new JBBPMapperException("Can't map field which member generated by instance", binField, record.mappingClass, record.mappingField, ex);
                    }
                }
            } else {
                MappedFieldRecord.setFieldValue(instance, record.setter, record.mappingField, binField, JBBPMapper.map((JBBPFieldStruct)binField, curValue, customFieldProcessor, new Function[0]));
            }
        } else {
            String convertedValue;
            boolean processed = false;
            if (record.mappingField.getType() == String.class && binField instanceof JBBPAbstractArrayField && (convertedValue = MappedFieldRecord.convertFieldValueToString((JBBPAbstractArrayField)binField)) != null) {
                MappedFieldRecord.setFieldValue(instance, record.setter, record.mappingField, binField, convertedValue);
                processed = true;
            }
            if (!processed) {
                throw new JBBPMapperException("Can't map a field for its value incompatibility", binField, record.mappingClass, record.mappingField, null);
            }
        }
    };
    public final Field mappingField;
    public final Class<?> mappingClass;
    public final Method setter;
    public final Method getter;
    public final Method instanceMaker;
    public final Bin binAnnotation;
    public final boolean bitWideField;
    public final String fieldName;
    public final String fieldPath;
    public final JBBPBitNumber mappedBitNumber;
    public final BinType fieldType;
    public final FieldProcessor proc;

    MappedFieldRecord(Field mappingField, Method instanceMaker, Method setter, Method getter, Class<?> mappingClass, Bin binAnnotation) {
        this.instanceMaker = instanceMaker;
        this.setter = setter;
        this.getter = getter;
        this.mappingField = mappingField;
        this.mappingClass = mappingClass;
        this.binAnnotation = binAnnotation;
        this.mappedBitNumber = binAnnotation.bitNumber();
        if (binAnnotation.type() == BinType.UNDEFINED) {
            BinType compatibleBinType = BinType.findCompatible(mappingField.getType());
            if (compatibleBinType == null) {
                throw new IllegalStateException("Can't find compatible mapped type for field");
            }
            if (this.mappedBitNumber.getBitNumber() < 8 && compatibleBinType != BinType.STRUCT && compatibleBinType != BinType.STRUCT_ARRAY) {
                compatibleBinType = compatibleBinType.isArray() ? BinType.BIT_ARRAY : BinType.BIT;
            }
            this.fieldType = compatibleBinType;
        } else {
            this.fieldType = binAnnotation.type();
        }
        this.bitWideField = this.fieldType == BinType.BIT || this.fieldType == BinType.BIT_ARRAY;
        this.fieldName = binAnnotation.name().isEmpty() ? mappingField.getName() : binAnnotation.name();
        this.fieldPath = binAnnotation.path();
        this.proc = this.mappingField.getType().isArray() ? PROC_ARRAYS : PROC_NUM;
    }

    private static void mapArrayField(Object mappingClassInstance, Method setter, Field mappingField, JBBPAbstractArrayField<?> arrayField, boolean invertBitOrder) {
        try {
            Object value;
            if (arrayField instanceof JBBPFieldArrayLong && mappingField.getType().getComponentType() == Double.TYPE) {
                long[] longArray = (long[])arrayField.getValueArrayAsObject(invertBitOrder);
                double[] doubleArray = new double[longArray.length];
                for (int i = 0; i < longArray.length; ++i) {
                    doubleArray[i] = Double.longBitsToDouble(longArray[i]);
                }
                value = doubleArray;
            } else if (arrayField instanceof JBBPFieldArrayUInt && mappingField.getType().getComponentType() == Double.TYPE) {
                long[] longArray = (long[])arrayField.getValueArrayAsObject(invertBitOrder);
                double[] doubleArray = new double[longArray.length];
                for (int i = 0; i < longArray.length; ++i) {
                    doubleArray[i] = Double.longBitsToDouble(longArray[i]);
                }
                value = doubleArray;
            } else if (arrayField instanceof JBBPFieldArrayInt && mappingField.getType().getComponentType() == Float.TYPE) {
                int[] intArray = (int[])arrayField.getValueArrayAsObject(invertBitOrder);
                float[] floatArray = new float[intArray.length];
                for (int i = 0; i < intArray.length; ++i) {
                    floatArray[i] = Float.intBitsToFloat(intArray[i]);
                }
                value = floatArray;
            } else if (arrayField instanceof JBBPFieldArrayUInt && mappingField.getType().getComponentType() == Float.TYPE) {
                long[] longArray = (long[])arrayField.getValueArrayAsObject(invertBitOrder);
                float[] floatArray = new float[longArray.length];
                for (int i = 0; i < longArray.length; ++i) {
                    floatArray[i] = Float.intBitsToFloat((int)longArray[i]);
                }
                value = floatArray;
            } else if (arrayField instanceof JBBPFieldArrayUInt && mappingField.getType().getComponentType() == Integer.TYPE) {
                long[] longArray = (long[])arrayField.getValueArrayAsObject(invertBitOrder);
                int[] intArray = new int[longArray.length];
                for (int i = 0; i < longArray.length; ++i) {
                    intArray[i] = (int)longArray[i];
                }
                value = intArray;
            } else if (arrayField instanceof JBBPFieldArrayUShort && mappingField.getType().getComponentType() == Character.TYPE) {
                short[] shortArray = (short[])arrayField.getValueArrayAsObject(invertBitOrder);
                char[] charArray = new char[shortArray.length];
                for (int i = 0; i < shortArray.length; ++i) {
                    charArray[i] = (char)shortArray[i];
                }
                value = charArray;
            } else {
                value = arrayField.getValueArrayAsObject(invertBitOrder);
            }
            if (setter == null) {
                mappingField.set(mappingClassInstance, value);
            } else {
                setter.invoke(mappingClassInstance, value);
            }
        }
        catch (IllegalAccessException ex) {
            throw new JBBPMapperException("Can't get access to a mapping field", arrayField, mappingClassInstance.getClass(), mappingField, ex);
        }
        catch (IllegalArgumentException ex) {
            throw new JBBPMapperException("Can't set argument to a mapping field", arrayField, mappingClassInstance.getClass(), mappingField, ex);
        }
        catch (InvocationTargetException ex) {
            throw new JBBPMapperException("Can't set argument to field through setter", arrayField, mappingClassInstance.getClass(), mappingField, ex);
        }
    }

    private static String convertFieldValueToString(JBBPAbstractArrayField<?> field) {
        StringBuilder result;
        if (field instanceof JBBPFieldArrayBit) {
            JBBPFieldArrayBit array = (JBBPFieldArrayBit)field;
            result = new StringBuilder(array.size());
            for (byte b : array.getArray()) {
                result.append((char)(b & 0xFF));
            }
        } else if (field instanceof JBBPFieldArrayByte) {
            JBBPFieldArrayByte array = (JBBPFieldArrayByte)field;
            result = new StringBuilder(array.size());
            for (byte b : array.getArray()) {
                result.append((char)(b & 0xFF));
            }
        } else if (field instanceof JBBPFieldArrayUByte) {
            JBBPFieldArrayUByte array = (JBBPFieldArrayUByte)field;
            result = new StringBuilder(array.size());
            for (byte b : array.getArray()) {
                result.append((char)(b & 0xFF));
            }
        } else if (field instanceof JBBPFieldArrayShort) {
            JBBPFieldArrayShort array = (JBBPFieldArrayShort)field;
            result = new StringBuilder(array.size());
            for (short b : array.getArray()) {
                result.append((char)b);
            }
        } else if (field instanceof JBBPFieldArrayUShort) {
            JBBPFieldArrayUShort array = (JBBPFieldArrayUShort)field;
            result = new StringBuilder(array.size());
            for (short b : array.getArray()) {
                result.append((char)b);
            }
        } else {
            result = null;
        }
        return result == null ? null : result.toString();
    }

    private static void mapNumericField(Object mappingClassInstance, Method setter, Field mappingField, JBBPNumericField numericField, boolean invertBitOrder) {
        block32: {
            Class<?> fieldClass = mappingField.getType();
            try {
                if (fieldClass == Byte.TYPE) {
                    byte value = (byte)(invertBitOrder ? numericField.getAsInvertedBitOrder() : (long)numericField.getAsInt());
                    if (setter == null) {
                        mappingField.setByte(mappingClassInstance, value);
                    } else {
                        setter.invoke(mappingClassInstance, value);
                    }
                    break block32;
                }
                if (fieldClass == Boolean.TYPE) {
                    if (setter == null) {
                        mappingField.setBoolean(mappingClassInstance, numericField.getAsBool());
                    } else {
                        setter.invoke(mappingClassInstance, numericField.getAsBool());
                    }
                    break block32;
                }
                if (fieldClass == Character.TYPE) {
                    char value = (char)(invertBitOrder ? numericField.getAsInvertedBitOrder() : (long)numericField.getAsInt());
                    if (setter == null) {
                        mappingField.setChar(mappingClassInstance, value);
                    } else {
                        setter.invoke(mappingClassInstance, Character.valueOf(value));
                    }
                    break block32;
                }
                if (fieldClass == Short.TYPE) {
                    short value = (short)(invertBitOrder ? numericField.getAsInvertedBitOrder() : (long)numericField.getAsInt());
                    if (setter == null) {
                        mappingField.setShort(mappingClassInstance, value);
                    } else {
                        setter.invoke(mappingClassInstance, value);
                    }
                    break block32;
                }
                if (fieldClass == Integer.TYPE) {
                    int value = (int)(invertBitOrder ? numericField.getAsInvertedBitOrder() : (long)numericField.getAsInt());
                    if (setter == null) {
                        mappingField.setInt(mappingClassInstance, value);
                    } else {
                        setter.invoke(mappingClassInstance, value);
                    }
                    break block32;
                }
                if (fieldClass == Long.TYPE) {
                    long value;
                    long l = value = invertBitOrder ? numericField.getAsInvertedBitOrder() : numericField.getAsLong();
                    if (setter == null) {
                        mappingField.setLong(mappingClassInstance, value);
                    } else {
                        setter.invoke(mappingClassInstance, value);
                    }
                    break block32;
                }
                if (fieldClass == Float.TYPE) {
                    float value;
                    if (numericField instanceof JBBPFieldInt) {
                        value = invertBitOrder ? Float.intBitsToFloat((int)numericField.getAsInvertedBitOrder()) : Float.intBitsToFloat(numericField.getAsInt());
                    } else {
                        float f = value = invertBitOrder ? Float.intBitsToFloat((int)numericField.getAsInvertedBitOrder()) : numericField.getAsFloat();
                    }
                    if (setter == null) {
                        mappingField.setFloat(mappingClassInstance, value);
                    } else {
                        setter.invoke(mappingClassInstance, Float.valueOf(value));
                    }
                    break block32;
                }
                if (fieldClass == Double.TYPE) {
                    double value;
                    if (numericField instanceof JBBPFieldLong) {
                        value = invertBitOrder ? Double.longBitsToDouble(numericField.getAsInvertedBitOrder()) : Double.longBitsToDouble(numericField.getAsLong());
                    } else {
                        double d = value = invertBitOrder ? Double.longBitsToDouble(numericField.getAsInvertedBitOrder()) : numericField.getAsDouble();
                    }
                    if (setter == null) {
                        mappingField.setDouble(mappingClassInstance, value);
                    } else {
                        setter.invoke(mappingClassInstance, value);
                    }
                    break block32;
                }
                throw new JBBPMapperException("Unsupported mapping class field type to be mapped for binary parsed data", (JBBPAbstractField)((Object)numericField), mappingClassInstance.getClass(), mappingField, null);
            }
            catch (IllegalAccessException ex) {
                throw new JBBPMapperException("Can't get access to a mapping field", (JBBPAbstractField)((Object)numericField), mappingClassInstance.getClass(), mappingField, ex);
            }
            catch (IllegalArgumentException ex) {
                throw new JBBPMapperException("Can't set argument to a mapping field", (JBBPAbstractField)((Object)numericField), mappingClassInstance.getClass(), mappingField, ex);
            }
            catch (InvocationTargetException ex) {
                throw new JBBPMapperException("Can't set argument to a mapping field through setter", (JBBPAbstractField)((Object)numericField), mappingClassInstance.getClass(), mappingField, ex);
            }
        }
    }

    private static Object getFieldValue(Object classInstance, Method getter, Field classField) {
        try {
            if (getter == null) {
                return classField.get(classInstance);
            }
            return getter.invoke(classInstance, new Object[0]);
        }
        catch (IllegalArgumentException ex) {
            throw new JBBPMapperException("Can't set get value from a mapping field", null, classInstance.getClass(), classField, ex);
        }
        catch (IllegalAccessException ex) {
            throw new JBBPMapperException("Can't get access to a mapping field", null, classInstance.getClass(), classField, ex);
        }
        catch (InvocationTargetException ex) {
            throw new JBBPMapperException("Can't get field value through getter", null, classInstance.getClass(), classField, ex);
        }
    }

    static void setFieldValue(Object classInstance, Method setter, Field classField, JBBPAbstractField binField, Object value) {
        try {
            if (setter == null) {
                classField.set(classInstance, value);
            } else {
                setter.invoke(classInstance, value);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new JBBPMapperException("Can't set value to a mapping field", binField, classInstance.getClass(), classField, ex);
        }
        catch (IllegalAccessException ex) {
            throw new JBBPMapperException("Can't get access to a mapping field", binField, classInstance.getClass(), classField, ex);
        }
        catch (InvocationTargetException ex) {
            throw new JBBPMapperException("Can't set field value through setter", binField, classInstance.getClass(), classField, ex);
        }
    }

    private static <T> T tryMakeInstance(Class<T> type, JBBPAbstractField binField, Object mappingObject, Field mappingField, Function<Class<?>, Object>[] instantiators) {
        Function<Class<?>, Object> instantiator;
        T result = null;
        Function<Class<?>, Object>[] functionArray = instantiators;
        int n = functionArray.length;
        for (int i = 0; i < n && (result = (T)type.cast((instantiator = functionArray[i]).apply(type))) == null; ++i) {
        }
        if (result == null) {
            ReflectiveOperationException detectedException = null;
            try {
                Method method = mappingObject.getClass().getMethod("newInstance", Class.class);
                if (!Modifier.isStatic(method.getModifiers())) {
                    result = type.cast(mappingObject.getClass().getMethod("newInstance", Class.class).invoke(mappingObject, type));
                }
            }
            catch (NoSuchMethodException method) {
            }
            catch (IllegalAccessException ex) {
                detectedException = ex;
            }
            catch (InvocationTargetException ex) {
                detectedException = ex;
            }
            if (detectedException != null) {
                throw new RuntimeException(String.format("Error during %s(%s) call", "newInstance", mappingObject.getClass()), detectedException);
            }
            if (result == null && (result = (T)type.cast(STATIC_MAKE_CLASS_INSTANCE_INSTANTIATOR.apply(type))) == null) {
                result = type.cast(DEFAULT_CONSTRUCTOR_INSTANTIATOR.apply(type));
            }
            if (result == null) {
                throw new JBBPMapperException(String.format("Can't create instance of %s", type), binField, mappingObject.getClass(), mappingField, null);
            }
        }
        return result;
    }

    @Override
    public int compareTo(MappedFieldRecord o) {
        int thatOrder;
        int thisOrder = this.binAnnotation.order();
        int result = thisOrder == (thatOrder = o.binAnnotation.order()) ? this.mappingField.getName().compareTo(o.mappingField.getName()) : (thisOrder < thatOrder ? -1 : 1);
        return result;
    }

    public static interface FieldProcessor {
        public void apply(MappedFieldRecord var1, JBBPFieldStruct var2, Object var3, JBBPMapperCustomFieldProcessor var4, JBBPAbstractField var5, int var6, BinFieldFilter var7, Function<Class<?>, Object> ... var8);
    }
}

