/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.utils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

public final class ReflectUtils {
    private static final Queue<PrivilegedProcessor> PROCESSORS_QUEUE = new ArrayBlockingQueue<PrivilegedProcessor>(32);

    private ReflectUtils() {
    }

    public static boolean isPotentiallyAccessibleClass(Class<?> klazz) {
        if (klazz.isLocalClass() && !ReflectUtils.isPotentiallyAccessibleClass(klazz.getEnclosingClass())) {
            return false;
        }
        return Modifier.isPublic(klazz.getModifiers());
    }

    public static boolean isPotentiallyAccessibleField(Field field) {
        return ReflectUtils.isPotentiallyAccessibleClass(field.getDeclaringClass()) && Modifier.isPublic(field.getModifiers());
    }

    public static <T extends AccessibleObject> T makeAccessible(T obj) {
        if (obj != null) {
            PrivilegedProcessor processor = PROCESSORS_QUEUE.poll();
            if (processor == null) {
                processor = new PrivilegedProcessor();
            }
            processor.setAccessibleObject(obj);
            AccessController.doPrivileged(processor);
            if (!PROCESSORS_QUEUE.offer(processor)) {
                throw new Error("Can't place processor into queue");
            }
        }
        return obj;
    }

    public static <T> T newInstance(Class<T> klazz) {
        try {
            return klazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Can't create instance of %s for error %s", klazz, ex.getMessage()), ex);
        }
    }

    private static final class PrivilegedProcessor
    implements PrivilegedAction<AccessibleObject> {
        private AccessibleObject theObject;

        private PrivilegedProcessor() {
        }

        public void setAccessibleObject(AccessibleObject obj) {
            this.theObject = obj;
        }

        @Override
        public AccessibleObject run() {
            AccessibleObject objectToProcess = this.theObject;
            this.theObject = null;
            if (objectToProcess != null) {
                objectToProcess.setAccessible(true);
            }
            return objectToProcess;
        }
    }
}

