%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM0": ["0x3FF0000000000000", "0x3FF0000000000000", "0x3FF0000000000000", "0x3FF0000000000000"],
    "XMM1": ["0x4000000000000000", "0x4000000000000000", "0x4000000000000000", "0x4000000000000000"],
    "XMM2": ["0x3FE0000000000000", "0x3FE0000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM3": ["0x3FE0000000000000", "0x3FE0000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM4": ["0x3FE0000000000000", "0x3FE0000000000000", "0x3FE0000000000000", "0x3FE0000000000000"],
    "XMM5": ["0x4000000000000000", "0x4000000000000000", "0x4000000000000000", "0x4000000000000000"],
    "XMM6": ["0x3FE0000000000000", "0x3FE0000000000000", "0x3FE0000000000000", "0x3FE0000000000000"],
    "XMM7": ["0x4000000000000000", "0x4000000000000000", "0x4000000000000000", "0x4000000000000000"]
  }
}
%endif

lea rdx, [rel .data]

vmovapd ymm0, [rdx]
vmovapd ymm1, [rdx + 32]

; Memory operand
vdivpd xmm2, xmm0, [rdx + 32]
vdivpd ymm4, ymm0, [rdx + 32]

; Register only
vdivpd xmm3, xmm0, xmm1
vdivpd ymm5, ymm1, ymm0

; Some tests for aliasing destination and source vectors
vmovapd ymm6, ymm0
vdivpd ymm6, ymm6, ymm1

vmovapd ymm7, ymm0
vdivpd ymm7, ymm1, ymm7

hlt

align 32
.data:
dq 0x3FF0000000000000
dq 0x3FF0000000000000
dq 0x3FF0000000000000
dq 0x3FF0000000000000

dq 0x4000000000000000
dq 0x4000000000000000
dq 0x4000000000000000
dq 0x4000000000000000
