// Copyright (c) 2023 Intel Corporation
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#pragma once

#include "mfx_common.h"
#if defined(MFX_ENABLE_AV1_VIDEO_ENCODE)

#include "av1ehw_base_data.h"
#include "av1ehw_base_lin.h"
#include "av1ehw_base_impl.h"

namespace AV1EHW
{
namespace Linux
{
namespace Xe2
{

    enum eFeatureId
    {
        FEATURE_XE2CDEF = AV1EHW::Base::eFeatureId::NUM_FEATURES
        , NUM_FEATURES
    };

    class MFXVideoENCODEAV1_HW
        : public Linux::Base::MFXVideoENCODEAV1_HW
    {
    public:
        using TBaseImpl = Linux::Base::MFXVideoENCODEAV1_HW;

        MFXVideoENCODEAV1_HW(
            VideoCORE& core
            , mfxStatus& status
            , eFeatureMode mode = eFeatureMode::INIT);
    };

} //Xe2
} //Linux
}// namespace AV1EHW

#endif //defined(MFX_ENABLE_AV1_VIDEO_ENCODE)