/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Vector;

public final class ManhattanConnectionRouter
extends AbstractRouter {
    private final Map<Integer, Integer> rowsUsed = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> colsUsed = new HashMap<Integer, Integer>();
    private final Map<Connection, ReservedInfo> reservedInfo = new HashMap<Connection, ReservedInfo>();
    private static final Vector UP = new Vector(0.0, -1.0);
    private static final Vector DOWN = new Vector(0.0, 1.0);
    private static final Vector LEFT = new Vector(-1.0, 0.0);
    private static final Vector RIGHT = new Vector(1.0, 0.0);

    @Override
    public void invalidate(Connection connection) {
        this.removeReservedLines(connection);
    }

    private int getColumnNear(Connection connection, int r, int n, int x) {
        int min = Math.min(n, x);
        int max = Math.max(n, x);
        if (min > r) {
            max = min;
            min = r - (min - r);
        }
        if (max < r) {
            min = max;
            max = r + (r - max);
        }
        int proximity = 0;
        int direction = -1;
        if (r % 2 == 1) {
            --r;
        }
        while (proximity < r) {
            Integer i = r + proximity * direction;
            if (!this.colsUsed.containsKey(i)) {
                this.colsUsed.put(i, i);
                this.reserveColumn(connection, i);
                return i;
            }
            int j = i;
            if (j <= min) {
                return j + 2;
            }
            if (j >= max) {
                return j - 2;
            }
            if (direction == 1) {
                direction = -1;
                continue;
            }
            direction = 1;
            proximity += 2;
        }
        return r;
    }

    protected Vector getDirection(Rectangle r, Point p) {
        int distance = Math.abs(r.x - p.x);
        Vector direction = LEFT;
        int i = Math.abs(r.y - p.y);
        if (i <= distance) {
            distance = i;
            direction = UP;
        }
        if ((i = Math.abs(r.bottom() - p.y)) <= distance) {
            distance = i;
            direction = DOWN;
        }
        if ((i = Math.abs(r.right() - p.x)) < distance) {
            direction = RIGHT;
        }
        return direction;
    }

    protected Vector getEndDirection(Connection conn) {
        Rectangle rect;
        ConnectionAnchor anchor = conn.getTargetAnchor();
        Point p = this.getEndPoint(conn);
        if (anchor.getOwner() == null) {
            rect = new Rectangle(p.x - 1, p.y - 1, 2, 2);
        } else {
            rect = conn.getTargetAnchor().getOwner().getBounds().getCopy();
            conn.getTargetAnchor().getOwner().translateToAbsolute(rect);
        }
        return this.getDirection(rect, p);
    }

    protected int getRowNear(Connection connection, int r, int n, int x) {
        int min = Math.min(n, x);
        int max = Math.max(n, x);
        if (min > r) {
            max = min;
            min = r - (min - r);
        }
        if (max < r) {
            min = max;
            max = r + (r - max);
        }
        int proximity = 0;
        int direction = -1;
        if (r % 2 == 1) {
            --r;
        }
        while (proximity < r) {
            Integer i = r + proximity * direction;
            if (!this.rowsUsed.containsKey(i)) {
                this.rowsUsed.put(i, i);
                this.reserveRow(connection, i);
                return i;
            }
            int j = i;
            if (j <= min) {
                return j + 2;
            }
            if (j >= max) {
                return j - 2;
            }
            if (direction == 1) {
                direction = -1;
                continue;
            }
            direction = 1;
            proximity += 2;
        }
        return r;
    }

    protected Vector getStartDirection(Connection conn) {
        Rectangle rect;
        ConnectionAnchor anchor = conn.getSourceAnchor();
        Point p = this.getStartPoint(conn);
        if (anchor.getOwner() == null) {
            rect = new Rectangle(p.x - 1, p.y - 1, 2, 2);
        } else {
            rect = conn.getSourceAnchor().getOwner().getBounds().getCopy();
            conn.getSourceAnchor().getOwner().translateToAbsolute(rect);
        }
        return this.getDirection(rect, p);
    }

    protected void processPositions(Vector start, Vector end, List<Double> positions, boolean horizontal, Connection conn) {
        this.removeReservedLines(conn);
        int[] pos = new int[positions.size() + 2];
        pos[0] = horizontal ? (int)start.x : (int)start.y;
        int i = 0;
        while (i < positions.size()) {
            pos[i + 1] = positions.get(i).intValue();
            ++i;
        }
        pos[++i] = horizontal == (positions.size() % 2 == 1) ? (int)end.x : (int)end.y;
        PointList points = new PointList();
        points.addPoint(new Point((int)start.x, (int)start.y));
        i = 2;
        while (i < pos.length - 1) {
            Point p;
            boolean adjust;
            horizontal = !horizontal;
            int prev = pos[i - 1];
            int current = pos[i];
            boolean bl = adjust = i != pos.length - 2;
            if (horizontal) {
                if (adjust) {
                    min = pos[i - 2];
                    max = pos[i + 2];
                    pos[i] = current = this.getRowNear(conn, current, min, max);
                }
                p = new Point(prev, current);
            } else {
                if (adjust) {
                    min = pos[i - 2];
                    max = pos[i + 2];
                    pos[i] = current = this.getColumnNear(conn, current, min, max);
                }
                p = new Point(current, prev);
            }
            points.addPoint(p);
            ++i;
        }
        points.addPoint(new Point((int)end.x, (int)end.y));
        conn.setPoints(points);
    }

    @Override
    public void remove(Connection connection) {
        this.removeReservedLines(connection);
    }

    protected void removeReservedLines(Connection connection) {
        ReservedInfo rInfo = this.reservedInfo.get(connection);
        if (rInfo == null) {
            return;
        }
        for (Integer element : rInfo.reservedRows) {
            this.rowsUsed.remove(element);
        }
        for (Integer element : rInfo.reservedCols) {
            this.colsUsed.remove(element);
        }
        this.reservedInfo.remove(connection);
    }

    protected void reserveColumn(Connection connection, Integer column) {
        ReservedInfo info = this.reservedInfo.computeIfAbsent(connection, dummy -> new ReservedInfo());
        info.reservedCols.add(column);
    }

    protected void reserveRow(Connection connection, Integer row) {
        ReservedInfo info = this.reservedInfo.computeIfAbsent(connection, dummy -> new ReservedInfo());
        info.reservedRows.add(row);
    }

    @Override
    public void route(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getTargetAnchor() == null) {
            return;
        }
        Point startPoint = this.getStartPoint(conn);
        conn.translateToRelative(startPoint);
        Point endPoint = this.getEndPoint(conn);
        conn.translateToRelative(endPoint);
        Vector start = new Vector(startPoint);
        Vector end = new Vector(endPoint);
        Vector average = start.getAveraged(end);
        Vector direction = new Vector(start, end);
        Vector startNormal = this.getStartDirection(conn);
        Vector endNormal = this.getEndDirection(conn);
        ArrayList<Double> positions = new ArrayList<Double>(5);
        boolean horizontal = startNormal.isHorizontal();
        if (horizontal) {
            positions.add(start.y);
        } else {
            positions.add(start.x);
        }
        boolean bl = horizontal = !horizontal;
        if (startNormal.getDotProduct(endNormal) == 0.0) {
            if (!(startNormal.getDotProduct(direction) >= 0.0) || !(endNormal.getDotProduct(direction) <= 0.0)) {
                double i = startNormal.getDotProduct(direction) < 0.0 ? startNormal.getSimilarity(start.getAdded(startNormal.getMultiplied(10.0))) : (horizontal ? average.y : average.x);
                positions.add(i);
                boolean bl2 = horizontal = !horizontal;
                i = endNormal.getDotProduct(direction) > 0.0 ? endNormal.getSimilarity(end.getAdded(endNormal.getMultiplied(10.0))) : (horizontal ? average.y : average.x);
                positions.add(i);
                horizontal = !horizontal;
            }
        } else if (startNormal.getDotProduct(endNormal) > 0.0) {
            double i = startNormal.getDotProduct(direction) >= 0.0 ? startNormal.getSimilarity(start.getAdded(startNormal.getMultiplied(10.0))) : endNormal.getSimilarity(end.getAdded(endNormal.getMultiplied(10.0)));
            positions.add(i);
            horizontal = !horizontal;
        } else {
            double i;
            if (startNormal.getDotProduct(direction) < 0.0) {
                i = startNormal.getSimilarity(start.getAdded(startNormal.getMultiplied(10.0)));
                positions.add(i);
                horizontal = !horizontal;
            }
            i = horizontal ? average.y : average.x;
            positions.add(i);
            boolean bl3 = horizontal = !horizontal;
            if (startNormal.getDotProduct(direction) < 0.0) {
                i = endNormal.getSimilarity(end.getAdded(endNormal.getMultiplied(10.0)));
                positions.add(i);
                boolean bl4 = horizontal = !horizontal;
            }
        }
        if (horizontal) {
            positions.add(end.y);
        } else {
            positions.add(end.x);
        }
        this.processPositions(start, end, positions, startNormal.isHorizontal(), conn);
    }

    private class ReservedInfo {
        public final List<Integer> reservedRows = new ArrayList<Integer>(2);
        public final List<Integer> reservedCols = new ArrayList<Integer>(2);

        private ReservedInfo() {
        }
    }
}

