//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "dispatch2")]
use dispatch2::*;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfmessageport?language=objc)
///
/// This is toll-free bridged with `NSMessagePort`.
#[doc(alias = "CFMessagePortRef")]
#[repr(C)]
pub struct CFMessagePort {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFMessagePort {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFMessagePort"> for CFMessagePort {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfmessageportsuccess?language=objc)
pub const kCFMessagePortSuccess: i32 = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfmessageportsendtimeout?language=objc)
pub const kCFMessagePortSendTimeout: i32 = -1;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfmessageportreceivetimeout?language=objc)
pub const kCFMessagePortReceiveTimeout: i32 = -2;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfmessageportisinvalid?language=objc)
pub const kCFMessagePortIsInvalid: i32 = -3;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfmessageporttransporterror?language=objc)
pub const kCFMessagePortTransportError: i32 = -4;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfmessageportbecameinvaliderror?language=objc)
pub const kCFMessagePortBecameInvalidError: i32 = -5;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfmessageportcontext?language=objc)
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFMessagePortContext {
    pub version: CFIndex,
    pub info: *mut c_void,
    pub retain: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>,
    pub release: Option<unsafe extern "C-unwind" fn(*const c_void)>,
    pub copyDescription: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFMessagePortContext {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFIndex>::ENCODING,
            <*mut c_void>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void)>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFMessagePortContext {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfmessageportcallback?language=objc)
#[cfg(feature = "CFData")]
pub type CFMessagePortCallBack = Option<
    unsafe extern "C-unwind" fn(
        *mut CFMessagePort,
        i32,
        *const CFData,
        *mut c_void,
    ) -> *const CFData,
>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfmessageportinvalidationcallback?language=objc)
pub type CFMessagePortInvalidationCallBack =
    Option<unsafe extern "C-unwind" fn(*mut CFMessagePort, *mut c_void)>;

unsafe impl ConcreteType for CFMessagePort {
    #[doc(alias = "CFMessagePortGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFMessagePortGetTypeID() -> CFTypeID;
        }
        unsafe { CFMessagePortGetTypeID() }
    }
}

impl CFMessagePort {
    /// # Safety
    ///
    /// - `allocator` might not allow `None`.
    /// - `name` might not allow `None`.
    /// - `callout` must be implemented correctly.
    /// - `context` must be a valid pointer.
    /// - `should_free_info` must be a valid pointer.
    #[doc(alias = "CFMessagePortCreateLocal")]
    #[cfg(feature = "CFData")]
    #[inline]
    pub unsafe fn new_local(
        allocator: Option<&CFAllocator>,
        name: Option<&CFString>,
        callout: CFMessagePortCallBack,
        context: *mut CFMessagePortContext,
        should_free_info: *mut Boolean,
    ) -> Option<CFRetained<CFMessagePort>> {
        extern "C-unwind" {
            fn CFMessagePortCreateLocal(
                allocator: Option<&CFAllocator>,
                name: Option<&CFString>,
                callout: CFMessagePortCallBack,
                context: *mut CFMessagePortContext,
                should_free_info: *mut Boolean,
            ) -> Option<NonNull<CFMessagePort>>;
        }
        let ret = unsafe {
            CFMessagePortCreateLocal(allocator, name, callout, context, should_free_info)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFMessagePortCreateRemote")]
    #[inline]
    pub fn new_remote(
        allocator: Option<&CFAllocator>,
        name: Option<&CFString>,
    ) -> Option<CFRetained<CFMessagePort>> {
        extern "C-unwind" {
            fn CFMessagePortCreateRemote(
                allocator: Option<&CFAllocator>,
                name: Option<&CFString>,
            ) -> Option<NonNull<CFMessagePort>>;
        }
        let ret = unsafe { CFMessagePortCreateRemote(allocator, name) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFMessagePortIsRemote")]
    #[inline]
    pub fn is_remote(&self) -> bool {
        extern "C-unwind" {
            fn CFMessagePortIsRemote(ms: &CFMessagePort) -> Boolean;
        }
        let ret = unsafe { CFMessagePortIsRemote(self) };
        ret != 0
    }

    #[doc(alias = "CFMessagePortGetName")]
    #[inline]
    pub fn name(&self) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFMessagePortGetName(ms: &CFMessagePort) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFMessagePortGetName(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CFMessagePortSetName")]
    #[inline]
    pub fn set_name(&self, new_name: Option<&CFString>) -> bool {
        extern "C-unwind" {
            fn CFMessagePortSetName(ms: &CFMessagePort, new_name: Option<&CFString>) -> Boolean;
        }
        let ret = unsafe { CFMessagePortSetName(self, new_name) };
        ret != 0
    }

    /// # Safety
    ///
    /// `context` must be a valid pointer.
    #[doc(alias = "CFMessagePortGetContext")]
    #[inline]
    pub unsafe fn context(&self, context: *mut CFMessagePortContext) {
        extern "C-unwind" {
            fn CFMessagePortGetContext(ms: &CFMessagePort, context: *mut CFMessagePortContext);
        }
        unsafe { CFMessagePortGetContext(self, context) }
    }

    #[doc(alias = "CFMessagePortInvalidate")]
    #[inline]
    pub fn invalidate(&self) {
        extern "C-unwind" {
            fn CFMessagePortInvalidate(ms: &CFMessagePort);
        }
        unsafe { CFMessagePortInvalidate(self) }
    }

    #[doc(alias = "CFMessagePortIsValid")]
    #[inline]
    pub fn is_valid(&self) -> bool {
        extern "C-unwind" {
            fn CFMessagePortIsValid(ms: &CFMessagePort) -> Boolean;
        }
        let ret = unsafe { CFMessagePortIsValid(self) };
        ret != 0
    }

    #[doc(alias = "CFMessagePortGetInvalidationCallBack")]
    #[inline]
    pub fn invalidation_call_back(&self) -> CFMessagePortInvalidationCallBack {
        extern "C-unwind" {
            fn CFMessagePortGetInvalidationCallBack(
                ms: &CFMessagePort,
            ) -> CFMessagePortInvalidationCallBack;
        }
        unsafe { CFMessagePortGetInvalidationCallBack(self) }
    }

    /// # Safety
    ///
    /// `callout` must be implemented correctly.
    #[doc(alias = "CFMessagePortSetInvalidationCallBack")]
    #[inline]
    pub unsafe fn set_invalidation_call_back(&self, callout: CFMessagePortInvalidationCallBack) {
        extern "C-unwind" {
            fn CFMessagePortSetInvalidationCallBack(
                ms: &CFMessagePort,
                callout: CFMessagePortInvalidationCallBack,
            );
        }
        unsafe { CFMessagePortSetInvalidationCallBack(self, callout) }
    }

    /// # Safety
    ///
    /// - `data` might not allow `None`.
    /// - `reply_mode` might not allow `None`.
    /// - `return_data` must be a valid pointer.
    #[doc(alias = "CFMessagePortSendRequest")]
    #[cfg(all(feature = "CFData", feature = "CFDate"))]
    #[inline]
    pub unsafe fn send_request(
        &self,
        msgid: i32,
        data: Option<&CFData>,
        send_timeout: CFTimeInterval,
        rcv_timeout: CFTimeInterval,
        reply_mode: Option<&CFString>,
        return_data: *mut *const CFData,
    ) -> i32 {
        extern "C-unwind" {
            fn CFMessagePortSendRequest(
                remote: &CFMessagePort,
                msgid: i32,
                data: Option<&CFData>,
                send_timeout: CFTimeInterval,
                rcv_timeout: CFTimeInterval,
                reply_mode: Option<&CFString>,
                return_data: *mut *const CFData,
            ) -> i32;
        }
        unsafe {
            CFMessagePortSendRequest(
                self,
                msgid,
                data,
                send_timeout,
                rcv_timeout,
                reply_mode,
                return_data,
            )
        }
    }

    #[doc(alias = "CFMessagePortCreateRunLoopSource")]
    #[cfg(feature = "CFRunLoop")]
    #[inline]
    pub fn new_run_loop_source(
        allocator: Option<&CFAllocator>,
        local: Option<&CFMessagePort>,
        order: CFIndex,
    ) -> Option<CFRetained<CFRunLoopSource>> {
        extern "C-unwind" {
            fn CFMessagePortCreateRunLoopSource(
                allocator: Option<&CFAllocator>,
                local: Option<&CFMessagePort>,
                order: CFIndex,
            ) -> Option<NonNull<CFRunLoopSource>>;
        }
        let ret = unsafe { CFMessagePortCreateRunLoopSource(allocator, local, order) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// - `queue` possibly has additional threading requirements.
    /// - `queue` might not allow `None`.
    #[doc(alias = "CFMessagePortSetDispatchQueue")]
    #[cfg(feature = "dispatch2")]
    #[inline]
    pub unsafe fn set_dispatch_queue(&self, queue: Option<&DispatchQueue>) {
        extern "C-unwind" {
            fn CFMessagePortSetDispatchQueue(ms: &CFMessagePort, queue: Option<&DispatchQueue>);
        }
        unsafe { CFMessagePortSetDispatchQueue(self, queue) }
    }
}

#[cfg(feature = "CFData")]
#[deprecated = "renamed to `CFMessagePort::new_local`"]
#[inline]
pub unsafe extern "C-unwind" fn CFMessagePortCreateLocal(
    allocator: Option<&CFAllocator>,
    name: Option<&CFString>,
    callout: CFMessagePortCallBack,
    context: *mut CFMessagePortContext,
    should_free_info: *mut Boolean,
) -> Option<CFRetained<CFMessagePort>> {
    extern "C-unwind" {
        fn CFMessagePortCreateLocal(
            allocator: Option<&CFAllocator>,
            name: Option<&CFString>,
            callout: CFMessagePortCallBack,
            context: *mut CFMessagePortContext,
            should_free_info: *mut Boolean,
        ) -> Option<NonNull<CFMessagePort>>;
    }
    let ret =
        unsafe { CFMessagePortCreateLocal(allocator, name, callout, context, should_free_info) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFMessagePort::new_remote`"]
#[inline]
pub extern "C-unwind" fn CFMessagePortCreateRemote(
    allocator: Option<&CFAllocator>,
    name: Option<&CFString>,
) -> Option<CFRetained<CFMessagePort>> {
    extern "C-unwind" {
        fn CFMessagePortCreateRemote(
            allocator: Option<&CFAllocator>,
            name: Option<&CFString>,
        ) -> Option<NonNull<CFMessagePort>>;
    }
    let ret = unsafe { CFMessagePortCreateRemote(allocator, name) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFMessagePort::is_remote`"]
#[inline]
pub extern "C-unwind" fn CFMessagePortIsRemote(ms: &CFMessagePort) -> bool {
    extern "C-unwind" {
        fn CFMessagePortIsRemote(ms: &CFMessagePort) -> Boolean;
    }
    let ret = unsafe { CFMessagePortIsRemote(ms) };
    ret != 0
}

#[deprecated = "renamed to `CFMessagePort::name`"]
#[inline]
pub extern "C-unwind" fn CFMessagePortGetName(ms: &CFMessagePort) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFMessagePortGetName(ms: &CFMessagePort) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFMessagePortGetName(ms) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `CFMessagePort::set_name`"]
#[inline]
pub extern "C-unwind" fn CFMessagePortSetName(
    ms: &CFMessagePort,
    new_name: Option<&CFString>,
) -> bool {
    extern "C-unwind" {
        fn CFMessagePortSetName(ms: &CFMessagePort, new_name: Option<&CFString>) -> Boolean;
    }
    let ret = unsafe { CFMessagePortSetName(ms, new_name) };
    ret != 0
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMessagePort::context`"]
    pub fn CFMessagePortGetContext(ms: &CFMessagePort, context: *mut CFMessagePortContext);
}

#[deprecated = "renamed to `CFMessagePort::invalidate`"]
#[inline]
pub extern "C-unwind" fn CFMessagePortInvalidate(ms: &CFMessagePort) {
    extern "C-unwind" {
        fn CFMessagePortInvalidate(ms: &CFMessagePort);
    }
    unsafe { CFMessagePortInvalidate(ms) }
}

#[deprecated = "renamed to `CFMessagePort::is_valid`"]
#[inline]
pub extern "C-unwind" fn CFMessagePortIsValid(ms: &CFMessagePort) -> bool {
    extern "C-unwind" {
        fn CFMessagePortIsValid(ms: &CFMessagePort) -> Boolean;
    }
    let ret = unsafe { CFMessagePortIsValid(ms) };
    ret != 0
}

#[deprecated = "renamed to `CFMessagePort::invalidation_call_back`"]
#[inline]
pub extern "C-unwind" fn CFMessagePortGetInvalidationCallBack(
    ms: &CFMessagePort,
) -> CFMessagePortInvalidationCallBack {
    extern "C-unwind" {
        fn CFMessagePortGetInvalidationCallBack(
            ms: &CFMessagePort,
        ) -> CFMessagePortInvalidationCallBack;
    }
    unsafe { CFMessagePortGetInvalidationCallBack(ms) }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMessagePort::set_invalidation_call_back`"]
    pub fn CFMessagePortSetInvalidationCallBack(
        ms: &CFMessagePort,
        callout: CFMessagePortInvalidationCallBack,
    );
}

extern "C-unwind" {
    #[cfg(all(feature = "CFData", feature = "CFDate"))]
    #[deprecated = "renamed to `CFMessagePort::send_request`"]
    pub fn CFMessagePortSendRequest(
        remote: &CFMessagePort,
        msgid: i32,
        data: Option<&CFData>,
        send_timeout: CFTimeInterval,
        rcv_timeout: CFTimeInterval,
        reply_mode: Option<&CFString>,
        return_data: *mut *const CFData,
    ) -> i32;
}

#[cfg(feature = "CFRunLoop")]
#[deprecated = "renamed to `CFMessagePort::new_run_loop_source`"]
#[inline]
pub extern "C-unwind" fn CFMessagePortCreateRunLoopSource(
    allocator: Option<&CFAllocator>,
    local: Option<&CFMessagePort>,
    order: CFIndex,
) -> Option<CFRetained<CFRunLoopSource>> {
    extern "C-unwind" {
        fn CFMessagePortCreateRunLoopSource(
            allocator: Option<&CFAllocator>,
            local: Option<&CFMessagePort>,
            order: CFIndex,
        ) -> Option<NonNull<CFRunLoopSource>>;
    }
    let ret = unsafe { CFMessagePortCreateRunLoopSource(allocator, local, order) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "dispatch2")]
    #[deprecated = "renamed to `CFMessagePort::set_dispatch_queue`"]
    pub fn CFMessagePortSetDispatchQueue(ms: &CFMessagePort, queue: Option<&DispatchQueue>);
}
