package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteScreenSetting invokes the aegis.DeleteScreenSetting API synchronously
// api document: https://help.aliyun.com/api/aegis/deletescreensetting.html
func (client *Client) DeleteScreenSetting(request *DeleteScreenSettingRequest) (response *DeleteScreenSettingResponse, err error) {
	response = CreateDeleteScreenSettingResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteScreenSettingWithChan invokes the aegis.DeleteScreenSetting API asynchronously
// api document: https://help.aliyun.com/api/aegis/deletescreensetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteScreenSettingWithChan(request *DeleteScreenSettingRequest) (<-chan *DeleteScreenSettingResponse, <-chan error) {
	responseChan := make(chan *DeleteScreenSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteScreenSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteScreenSettingWithCallback invokes the aegis.DeleteScreenSetting API asynchronously
// api document: https://help.aliyun.com/api/aegis/deletescreensetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteScreenSettingWithCallback(request *DeleteScreenSettingRequest, callback func(response *DeleteScreenSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteScreenSettingResponse
		var err error
		defer close(result)
		response, err = client.DeleteScreenSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteScreenSettingRequest is the request struct for api DeleteScreenSetting
type DeleteScreenSettingRequest struct {
	*requests.RpcRequest
	SourceIp    string `position:"Query" name:"SourceIp"`
	ScreenTitle string `position:"Query" name:"ScreenTitle"`
}

// DeleteScreenSettingResponse is the response struct for api DeleteScreenSetting
type DeleteScreenSettingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteScreenSettingRequest creates a request to invoke DeleteScreenSetting API
func CreateDeleteScreenSettingRequest() (request *DeleteScreenSettingRequest) {
	request = &DeleteScreenSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DeleteScreenSetting", "vipaegis", "openAPI")
	return
}

// CreateDeleteScreenSettingResponse creates a response to parse from DeleteScreenSetting response
func CreateDeleteScreenSettingResponse() (response *DeleteScreenSettingResponse) {
	response = &DeleteScreenSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
