package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetQueryOptimizeExecErrorStats invokes the das.GetQueryOptimizeExecErrorStats API synchronously
func (client *Client) GetQueryOptimizeExecErrorStats(request *GetQueryOptimizeExecErrorStatsRequest) (response *GetQueryOptimizeExecErrorStatsResponse, err error) {
	response = CreateGetQueryOptimizeExecErrorStatsResponse()
	err = client.DoAction(request, response)
	return
}

// GetQueryOptimizeExecErrorStatsWithChan invokes the das.GetQueryOptimizeExecErrorStats API asynchronously
func (client *Client) GetQueryOptimizeExecErrorStatsWithChan(request *GetQueryOptimizeExecErrorStatsRequest) (<-chan *GetQueryOptimizeExecErrorStatsResponse, <-chan error) {
	responseChan := make(chan *GetQueryOptimizeExecErrorStatsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetQueryOptimizeExecErrorStats(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetQueryOptimizeExecErrorStatsWithCallback invokes the das.GetQueryOptimizeExecErrorStats API asynchronously
func (client *Client) GetQueryOptimizeExecErrorStatsWithCallback(request *GetQueryOptimizeExecErrorStatsRequest, callback func(response *GetQueryOptimizeExecErrorStatsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetQueryOptimizeExecErrorStatsResponse
		var err error
		defer close(result)
		response, err = client.GetQueryOptimizeExecErrorStats(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetQueryOptimizeExecErrorStatsRequest is the request struct for api GetQueryOptimizeExecErrorStats
type GetQueryOptimizeExecErrorStatsRequest struct {
	*requests.RpcRequest
	Keywords        string `position:"Query" name:"Keywords"`
	ConsoleContext  string `position:"Query" name:"ConsoleContext"`
	Engine          string `position:"Query" name:"Engine"`
	PageSize        string `position:"Query" name:"PageSize"`
	OrderBy         string `position:"Query" name:"OrderBy"`
	DbNames         string `position:"Query" name:"DbNames"`
	LogicalOperator string `position:"Query" name:"LogicalOperator"`
	Asc             string `position:"Query" name:"Asc"`
	InstanceIds     string `position:"Query" name:"InstanceIds"`
	PageNo          string `position:"Query" name:"PageNo"`
	Time            string `position:"Query" name:"Time"`
}

// GetQueryOptimizeExecErrorStatsResponse is the response struct for api GetQueryOptimizeExecErrorStats
type GetQueryOptimizeExecErrorStatsResponse struct {
	*responses.BaseResponse
	Code      string                               `json:"Code" xml:"Code"`
	Message   string                               `json:"Message" xml:"Message"`
	RequestId string                               `json:"RequestId" xml:"RequestId"`
	Success   string                               `json:"Success" xml:"Success"`
	Data      DataInGetQueryOptimizeExecErrorStats `json:"Data" xml:"Data"`
}

// CreateGetQueryOptimizeExecErrorStatsRequest creates a request to invoke GetQueryOptimizeExecErrorStats API
func CreateGetQueryOptimizeExecErrorStatsRequest() (request *GetQueryOptimizeExecErrorStatsRequest) {
	request = &GetQueryOptimizeExecErrorStatsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetQueryOptimizeExecErrorStats", "", "")
	request.Method = requests.GET
	return
}

// CreateGetQueryOptimizeExecErrorStatsResponse creates a response to parse from GetQueryOptimizeExecErrorStats response
func CreateGetQueryOptimizeExecErrorStatsResponse() (response *GetQueryOptimizeExecErrorStatsResponse) {
	response = &GetQueryOptimizeExecErrorStatsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
